/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.performance.concurrent;

import javax.persistence.EntityManager;
import org.eclipse.persistence.testing.framework.ConcurrentPerformanceComparisonTest;
import org.eclipse.persistence.testing.models.jpa.performance.Employee;
import org.eclipse.persistence.testing.models.jpa.performance.PhoneNumber;

public class JPAAddPhoneConcurrencyComparisonTest
extends ConcurrentPerformanceComparisonTest {
    protected Employee employee;
    protected int errors;

    public JPAAddPhoneConcurrencyComparisonTest() {
        this.setDescription("This test compares the concurrency of complex update Employee.");
    }

    public void setup() {
        super.setup();
        EntityManager manager = this.createEntityManager();
        this.employee = (Employee)manager.createQuery("Select e from Employee e").getResultList().get(0);
        this.employee.getAddress().getCity();
        this.employee.getPhoneNumbers().size();
        manager.close();
    }

    public void runTask() throws Exception {
        EntityManager manager = this.createEntityManager();
        manager.getTransaction().begin();
        Employee employee = (Employee)manager.find(Employee.class, (Object)this.employee.getId());
        PhoneNumber workFax = null;
        for (PhoneNumber phone : employee.getPhoneNumbers()) {
            if (!phone.getType().equals("work-fax")) continue;
            workFax = phone;
            break;
        }
        if (workFax == null) {
            PhoneNumber phone = new PhoneNumber();
            phone.setType("work-fax");
            phone.setAreaCode("613");
            phone.setNumber("9991111");
            employee.addPhoneNumber(phone);
        } else {
            employee.removePhoneNumber(workFax);
            manager.remove(workFax);
        }
        try {
            manager.getTransaction().commit();
        }
        catch (Exception exception) {
            ++this.errors;
            System.out.println("" + this.errors + ":" + exception);
        }
        manager.close();
    }
}

