/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.jpql;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.exceptions.JPQLException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.expressions.ExpressionMath;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.jpa.JpaEntityManager;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.sessions.server.ClientSession;
import org.eclipse.persistence.sessions.server.Server;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.advanced.Address;
import org.eclipse.persistence.testing.models.jpa.advanced.AdvancedTableCreator;
import org.eclipse.persistence.testing.models.jpa.advanced.Buyer;
import org.eclipse.persistence.testing.models.jpa.advanced.Employee;
import org.eclipse.persistence.testing.models.jpa.advanced.EmployeePopulator;
import org.eclipse.persistence.testing.models.jpa.advanced.LargeProject;
import org.eclipse.persistence.testing.models.jpa.advanced.PhoneNumber;
import org.eclipse.persistence.testing.models.jpa.advanced.Project;
import org.eclipse.persistence.testing.models.jpa.advanced.SmallProject;
import org.eclipse.persistence.testing.tests.jpa.jpql.JUnitDomainObjectComparer;

public class JUnitJPQLSimpleTestSuite
extends JUnitTestCase {
    static JUnitDomainObjectComparer comparer;

    public JUnitJPQLSimpleTestSuite() {
    }

    public JUnitJPQLSimpleTestSuite(String name) {
        super(name);
    }

    public void tearDown() {
        this.clearCache();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("JUnitJPQLSimpleTestSuite");
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("testSetup"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("simpleSingleArgSubstringTest"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("simpleJoinFetchTest"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("simpleJoinFetchTest2"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("baseTestCase"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("simpleABSTest"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("simpleBetweenTest"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("simpleConcatTest"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("simpleConcatTestWithParameters"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("simpleConcatTestWithConstants1"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("simpleThreeArgConcatTest"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("simpleDistinctTest"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("simpleDistinctNullTest"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("simpleDistinctMultipleResultTest"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("simpleDoubleOrTest"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("simpleEqualsBracketsTest"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("simpleEqualsTest"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("simpleEqualsTestWithJoin"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("simpleEqualsWithAs"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("collectionMemberIdentifierEqualsTest"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("abstractSchemaIdentifierEqualsTest"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("abstractSchemaIdentifierNotEqualsTest"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("simpleInOneDotTest"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("simpleInTest"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("simpleInListTest"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("simpleInNegativeTest"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("simpleLengthTest"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("simpleLikeTest"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("simpleLikeTestWithParameter"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("simpleLikeEscapeTestWithParameter"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("simpleNotBetweenTest"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("simpleNotEqualsVariablesInteger"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("simpleNotInTest"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("simpleNotLikeTest"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("simpleOrFollowedByAndTest"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("simpleOrFollowedByAndTestWithStaticNames"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("simpleOrTest"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("simpleParameterTest"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("simpleParameterTestChangingParameters"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("simpleReverseAbsTest"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("simpleReverseConcatTest"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("simpleReverseEqualsTest"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("simpleReverseLengthTest"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("simpleReverseParameterTest"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("simpleReverseSqrtTest"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("simpleReverseSubstringTest"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("simpleSqrtTest"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("simpleSubstringTest"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("simpleNullTest"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("simpleNotNullTest"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("distinctTest"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("conformResultsInUnitOfWorkTest"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("simpleModTest"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("simpleIsEmptyTest"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("simpleIsNotEmptyTest"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("simpleApostrohpeTest"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("simpleEscapeUnderscoreTest"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("simpleEnumTest"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("smallProjectMemberOfProjectsTest"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("smallProjectNOTMemberOfProjectsTest"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("selectCountOneToOneTest"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("selectOneToOneTest"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("selectPhonenumberDeclaredInINClauseTest"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("selectPhoneUsingALLTest"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("selectSimpleMemberOfWithParameterTest"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("selectSimpleNotMemberOfWithParameterTest"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("selectSimpleNotMemberOfWithParameterNestedTest"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("selectDirectCollectionNotMemberTest"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("selectDirectCollectionNonMemberNestedTest"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("selectSimpleBetweenWithParameterTest"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("selectSimpleInWithParameterTest"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("selectAverageQueryForByteColumnTest"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("selectUsingLockModeQueryHintTest"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("multipleExecutionOfNamedQueryTest"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("testOneEqualsOne"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("testParameterEqualsParameter"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("simpleTypeTest"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("simpleAsOrderByTest"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("simpleLiteralDateTest"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("simpleLiteralLongTest_Long1"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("simpleLiteralLongTest_Long2"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("simpleLiteralLongTest_Float1"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("simpleLiteralLongTest_Float2"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("simpleLiteralLongTest_Double1"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("simpleLiteralLongTest_Double2"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("simpleSingleArgSubstringTest"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("elementCollectionIsNotEmptyTest"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("relationshipElementCollectionIsNotEmptyTest"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("enumWithToStringTest"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("selectFromClauseWithFullyQualifiedClassName"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("selectFromClauseWithTableName"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("selectFromClauseWithJoin"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("testMultipleSubqueries"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("testDirectCollectionComparison"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("simpleQueryWithFirstUnusedEntity"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("testSimpleGroupByOrderByClauses"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("testOrderByWithParenthesesAsc"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("testOrderByWithParenthesesDesc"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("testOrderByWithParenthesesCalculatedAsc"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("testOrderByWithParenthesesCalculatedDesc"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("testOrderByWithParenthesesCalculatedAndNormalAsc"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("testOrderByWithParenthesesCalculatedAndNormalDesc"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("testOrderByWithParenthesesCalculatedAndNormalHybrid"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("testOrderByWithParenthesesCalculatedDefault"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("testOrderByWithParenthesesDefault"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("testOrderByWithParenthesesCalculatedAndNormalDefault"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("testOrderByWithParenthesesAllAttributes"));
        suite.addTest((Test)new JUnitJPQLSimpleTestSuite("testOrderByWithParenthesesAllAttributesHybrid"));
        return suite;
    }

    public void testSetup() {
        this.clearCache();
        ServerSession session = JUnitTestCase.getServerSession();
        EmployeePopulator employeePopulator = new EmployeePopulator();
        new AdvancedTableCreator().replaceTables((DatabaseSession)session);
        comparer = new JUnitDomainObjectComparer();
        comparer.setSession((AbstractSession)session.getActiveSession());
        employeePopulator.buildExamples();
        employeePopulator.persistExample((Session)session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testParameterEqualsParameter() throws Exception {
        DatabasePlatform databasePlatform = JUnitTestCase.getServerSession().getPlatform();
        if (databasePlatform.isSymfoware()) {
            JUnitJPQLSimpleTestSuite.getServerSession().logMessage("Test testParameterEqualsParameter skipped for this platform, Symfoware doesn't allow dynamic parameters on both sides of the equals operator at the same time. (bug 304897)");
            return;
        }
        if (databasePlatform.isMaxDB()) {
            JUnitJPQLSimpleTestSuite.getServerSession().logMessage("Test testParameterEqualsParameter skipped for this platform, MaxDB doesn't allow dynamic parameters on both sides of the equals operator at the same time. (bug 326962)");
            return;
        }
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Query query = em.createQuery("SELECT e FROM Employee e");
            List emps = query.getResultList();
            Assert.assertNotNull((Object)emps);
            int numRead = emps.size();
            query = em.createQuery("SELECT e FROM Employee e WHERE :arg1=:arg2");
            query.setParameter("arg1", (Object)1);
            query.setParameter("arg2", (Object)1);
            emps = query.getResultList();
            Assert.assertNotNull((Object)emps);
            Assert.assertEquals((int)numRead, (int)emps.size());
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOneEqualsOne() throws Exception {
        if (JUnitTestCase.getServerSession().getPlatform().isSymfoware()) {
            JUnitJPQLSimpleTestSuite.getServerSession().logMessage("Test testOneEqualsOne skipped for this platform, Symfoware doesn't allow dynamic parameters on both sides of the equals operator at the same time. (bug 304897)");
            return;
        }
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Query query = em.createQuery("SELECT e FROM Employee e");
            List emps = query.getResultList();
            Assert.assertNotNull((Object)emps);
            int numRead = emps.size();
            query = em.createQuery("SELECT e FROM Employee e WHERE 1=1");
            emps = query.getResultList();
            Assert.assertNotNull((Object)emps);
            Assert.assertEquals((int)numRead, (int)emps.size());
            ExpressionBuilder builder = new ExpressionBuilder();
            query = ((JpaEntityManager)em.getDelegate()).createQuery(builder.value(1).equal(builder.value(1)), Employee.class);
            emps = query.getResultList();
            Assert.assertNotNull((Object)emps);
            Assert.assertEquals((int)numRead, (int)emps.size());
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    public void simpleJoinFetchTest() throws Exception {
        if (JUnitJPQLSimpleTestSuite.isOnServer()) {
            return;
        }
        JpaEntityManager em = (JpaEntityManager)this.createEntityManager();
        this.simpleJoinFetchTest(em);
    }

    public void simpleJoinFetchTest2() throws Exception {
        if (JUnitJPQLSimpleTestSuite.isOnServer()) {
            return;
        }
        JpaEntityManager em = (JpaEntityManager)this.createEntityManager();
        String ejbqlString = "SELECT e FROM Employee e";
        List result = em.createQuery(ejbqlString).getResultList();
        result.size();
        this.simpleJoinFetchTest(em);
    }

    public void simpleJoinFetchTest(JpaEntityManager em) throws Exception {
        String ejbqlString = "SELECT e FROM Employee e LEFT JOIN FETCH e.phoneNumbers";
        List result = em.createQuery(ejbqlString).getResultList();
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        ObjectOutputStream stream = new ObjectOutputStream(byteStream);
        stream.writeObject(result);
        stream.flush();
        byte[] arr = byteStream.toByteArray();
        ByteArrayInputStream inByteStream = new ByteArrayInputStream(arr);
        ObjectInputStream inObjStream = new ObjectInputStream(inByteStream);
        List deserialResult = (List)inObjStream.readObject();
        for (Employee emp : deserialResult) {
            emp.getPhoneNumbers().size();
        }
        ReportQuery reportQuery = new ReportQuery();
        reportQuery.setShouldReturnWithoutReportQueryResult(true);
        reportQuery.setReferenceClass(Employee.class);
        ExpressionBuilder builder = reportQuery.getExpressionBuilder();
        ArrayList<Expression> joins = new ArrayList<Expression>(1);
        joins.add(builder.anyOfAllowingNone("phoneNumbers"));
        reportQuery.addItem("emp", (Expression)builder, joins);
        Vector expectedResult = (Vector)em.getUnitOfWork().executeQuery((DatabaseQuery)reportQuery);
        if (!comparer.compareObjects(result, (Collection)expectedResult)) {
            JUnitJPQLSimpleTestSuite.fail((String)("simpleJoinFetchTest Failed when using cache, collections do not match: " + result + " expected: " + expectedResult));
        }
        this.clearCache();
        em.clear();
        result = em.createQuery(ejbqlString).getResultList();
        byteStream = new ByteArrayOutputStream();
        stream = new ObjectOutputStream(byteStream);
        stream.writeObject(result);
        stream.flush();
        arr = byteStream.toByteArray();
        inByteStream = new ByteArrayInputStream(arr);
        inObjStream = new ObjectInputStream(inByteStream);
        deserialResult = (List)inObjStream.readObject();
        for (Employee emp : deserialResult) {
            emp.getPhoneNumbers().size();
        }
        this.clearCache();
        expectedResult = (Vector)em.getUnitOfWork().executeQuery((DatabaseQuery)reportQuery);
        if (!comparer.compareObjects(result, (Collection)expectedResult)) {
            JUnitJPQLSimpleTestSuite.fail((String)("simpleJoinFetchTest Failed when not using cache, collections do not match: " + result + " expected: " + expectedResult));
        }
    }

    public void baseTestCase() {
        EntityManager em = this.createEntityManager();
        Vector expectedResult = JUnitJPQLSimpleTestSuite.getServerSession().readAllObjects(Employee.class);
        this.clearCache();
        List result = em.createQuery("SELECT OBJECT(emp) FROM Employee emp").getResultList();
        Assert.assertTrue((String)"Base Test Case Failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
    }

    public void simpleABSTest() {
        EntityManager em = this.createEntityManager();
        Employee expectedResult = (Employee)JUnitJPQLSimpleTestSuite.getServerSession().readAllObjects(Employee.class).firstElement();
        this.clearCache();
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE ";
        ejbqlString = ejbqlString + "ABS(emp.salary) = ";
        ejbqlString = ejbqlString + expectedResult.getSalary();
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"ABS test failed", (boolean)comparer.compareObjects((Object)result, expectedResult));
    }

    public void simpleBetweenTest() {
        BigDecimal empId = new BigDecimal(0);
        EntityManager em = this.createEntityManager();
        Employee employee = (Employee)JUnitJPQLSimpleTestSuite.getServerSession().readAllObjects(Employee.class).lastElement();
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = builder.get("id").between((Object)empId, (Object)employee.getId());
        ReadAllQuery raq = new ReadAllQuery();
        raq.setReferenceClass(Employee.class);
        raq.setSelectionCriteria(whereClause);
        Vector expectedResult = (Vector)JUnitJPQLSimpleTestSuite.getServerSession().executeQuery((DatabaseQuery)raq);
        this.clearCache();
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE emp.id BETWEEN " + empId + " AND " + employee.getId();
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"Between test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
    }

    public void simpleConcatTest() {
        EntityManager em = this.createEntityManager();
        Employee expectedResult = (Employee)JUnitJPQLSimpleTestSuite.getServerSession().readAllObjects(Employee.class).firstElement();
        this.clearCache();
        String partOne = expectedResult.getFirstName().substring(0, 2);
        String partTwo = expectedResult.getFirstName().substring(2);
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE ";
        ejbqlString = ejbqlString + "emp.firstName = ";
        ejbqlString = ejbqlString + "CONCAT(\"";
        ejbqlString = ejbqlString + partOne;
        ejbqlString = ejbqlString + "\", \"";
        ejbqlString = ejbqlString + partTwo;
        ejbqlString = ejbqlString + "\")";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"Concat test failed", (boolean)comparer.compareObjects((Object)result, expectedResult));
    }

    public void simpleConcatTestWithParameters() {
        if (JUnitTestCase.getServerSession().getPlatform().isSymfoware()) {
            JUnitJPQLSimpleTestSuite.getServerSession().logMessage("Test simpleConcatTestWithParameters skipped for this platform, Symfoware doesn't allow dynamic parameters in both arguments to CONCAT at the same time. (bug 304897)");
            return;
        }
        EntityManager em = this.createEntityManager();
        Employee expectedResult = (Employee)JUnitJPQLSimpleTestSuite.getServerSession().readAllObjects(Employee.class).firstElement();
        this.clearCache();
        String partOne = expectedResult.getFirstName().substring(0, 2);
        String partTwo = expectedResult.getFirstName().substring(2);
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE ";
        ejbqlString = ejbqlString + "emp.firstName = ";
        ejbqlString = ejbqlString + "CONCAT(";
        ejbqlString = ejbqlString + ":partOne";
        ejbqlString = ejbqlString + ", ";
        ejbqlString = ejbqlString + ":partTwo";
        ejbqlString = ejbqlString + ")";
        List result = em.createQuery(ejbqlString).setParameter("partOne", (Object)partOne).setParameter("partTwo", (Object)partTwo).getResultList();
        Assert.assertTrue((String)"Concat test failed", (boolean)comparer.compareObjects((Object)result, expectedResult));
    }

    public void simpleConcatTestWithConstants1() {
        EntityManager em = this.createEntityManager();
        Employee emp = (Employee)JUnitJPQLSimpleTestSuite.getServerSession().readAllObjects(Employee.class).firstElement();
        String partOne = emp.getFirstName();
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = builder.get("firstName").concat((Object)"Smith").like(partOne + "Smith");
        ReadAllQuery raq = new ReadAllQuery();
        raq.setReferenceClass(Employee.class);
        raq.setSelectionCriteria(whereClause);
        Vector expectedResult = (Vector)JUnitJPQLSimpleTestSuite.getServerSession().executeQuery((DatabaseQuery)raq);
        this.clearCache();
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE ";
        ejbqlString = ejbqlString + "CONCAT(emp.firstName,\"Smith\") LIKE ";
        ejbqlString = ejbqlString + "\"" + partOne + "Smith\"";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"Concat test with constraints failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
    }

    public void simpleThreeArgConcatTest() {
        EntityManager em = this.createEntityManager();
        Employee expectedResult = (Employee)JUnitJPQLSimpleTestSuite.getServerSession().readAllObjects(Employee.class).firstElement();
        this.clearCache();
        String partOne = expectedResult.getFirstName().substring(0, 1);
        String partTwo = expectedResult.getFirstName().substring(1, 2);
        String partThree = expectedResult.getFirstName().substring(2);
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE ";
        ejbqlString = ejbqlString + "emp.firstName = ";
        ejbqlString = ejbqlString + "CONCAT(\"";
        ejbqlString = ejbqlString + partOne;
        ejbqlString = ejbqlString + "\", \"";
        ejbqlString = ejbqlString + partTwo;
        ejbqlString = ejbqlString + "\", \"";
        ejbqlString = ejbqlString + partThree;
        ejbqlString = ejbqlString + "\")";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"Concat test failed", (boolean)comparer.compareObjects((Object)result, expectedResult));
    }

    public void simpleDistinctTest() {
        EntityManager em = this.createEntityManager();
        String ejbqlString = "SELECT DISTINCT e FROM Employee e JOIN FETCH e.phoneNumbers ";
        List result = em.createQuery(ejbqlString).getResultList();
        HashSet<Employee> testSet = new HashSet<Employee>();
        for (Employee emp : result) {
            JUnitJPQLSimpleTestSuite.assertFalse((String)"Result was not distinct", (boolean)testSet.contains(emp));
            testSet.add(emp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleDistinctNullTest() {
        EntityManager em = this.createEntityManager();
        Employee emp = (Employee)em.createQuery("SELECT e from Employee e").getResultList().get(0);
        String oldFirstName = emp.getFirstName();
        this.beginTransaction(em);
        try {
            emp = (Employee)em.find(Employee.class, (Object)emp.getId());
            emp.setFirstName(null);
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        try {
            String ejbqlString = "SELECT DISTINCT e.firstName FROM Employee e WHERE e.lastName = '" + emp.getLastName() + "'";
            List result = em.createQuery(ejbqlString).getResultList();
            JUnitJPQLSimpleTestSuite.assertTrue((String)"Failed to return null value", (boolean)result.contains(null));
        }
        finally {
            try {
                this.beginTransaction(em);
                emp = (Employee)em.find(Employee.class, (Object)emp.getId());
                emp.setFirstName(oldFirstName);
                this.commitTransaction(em);
            }
            catch (RuntimeException ex) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                this.closeEntityManager(em);
                throw ex;
            }
        }
    }

    public void simpleDistinctMultipleResultTest() {
        EntityManager em = this.createEntityManager();
        String ejbqlString = "SELECT DISTINCT e, e.firstName FROM Employee e JOIN FETCH e.phoneNumbers ";
        List result = em.createQuery(ejbqlString).getResultList();
        HashSet<String> testSet = new HashSet<String>();
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            String ids = "";
            Object[] row = (Object[])iterator.next();
            Employee emp = (Employee)row[0];
            String string = (String)row[1];
            ids = "_" + emp.getId() + "_" + string;
            JUnitJPQLSimpleTestSuite.assertFalse((String)"Result was not distinct", (boolean)testSet.contains(ids));
            testSet.add(ids);
        }
    }

    public void simpleDoubleOrTest() {
        EntityManager em = this.createEntityManager();
        Employee emp1 = (Employee)JUnitJPQLSimpleTestSuite.getServerSession().readAllObjects(Employee.class).firstElement();
        Employee emp2 = (Employee)JUnitJPQLSimpleTestSuite.getServerSession().readAllObjects(Employee.class).elementAt(1);
        Employee emp3 = (Employee)JUnitJPQLSimpleTestSuite.getServerSession().readAllObjects(Employee.class).elementAt(2);
        this.clearCache();
        Vector<Employee> expectedResult = new Vector<Employee>();
        expectedResult.add(emp1);
        expectedResult.add(emp2);
        expectedResult.add(emp3);
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE emp.id = " + emp1.getId() + " OR emp.id = " + emp2.getId() + " OR emp.id = " + emp3.getId();
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"Double OR test failed", (boolean)comparer.compareObjects(result, expectedResult));
    }

    public void simpleEqualsBracketsTest() {
        EntityManager em = this.createEntityManager();
        Employee expectedResult = (Employee)JUnitJPQLSimpleTestSuite.getServerSession().readAllObjects(Employee.class).firstElement();
        this.clearCache();
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE ";
        ejbqlString = ejbqlString + "( emp.firstName = ";
        ejbqlString = ejbqlString + "\"" + expectedResult.getFirstName() + "\")";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"Equals brackets test failed", (boolean)comparer.compareObjects((Object)result, expectedResult));
    }

    public void simpleEqualsTest() {
        EntityManager em = this.createEntityManager();
        Employee expectedResult = (Employee)JUnitJPQLSimpleTestSuite.getServerSession().readAllObjects(Employee.class).firstElement();
        this.clearCache();
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE ";
        ejbqlString = ejbqlString + "emp.firstName = ";
        ejbqlString = ejbqlString + "\"" + expectedResult.getFirstName() + "\"";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"Equals test failed", (boolean)comparer.compareObjects((Object)expectedResult, (Collection)result));
    }

    public void simpleEqualsTestWithJoin() {
        EntityManager em = this.createEntityManager();
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = builder.anyOf("managedEmployees").get("address").get("city").equal((Object)"Ottawa");
        Vector expectedResult = JUnitJPQLSimpleTestSuite.getServerSession().readAllObjects(Employee.class, whereClause);
        this.clearCache();
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp, IN(emp.managedEmployees) managedEmployees WHERE managedEmployees.address.city = 'Ottawa'";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"Equals test with Join failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
    }

    public void simpleEqualsWithAs() {
        EntityManager em = this.createEntityManager();
        Employee expectedResult = (Employee)JUnitJPQLSimpleTestSuite.getServerSession().readAllObjects(Employee.class).firstElement();
        this.clearCache();
        Vector<Employee> employeesUsed = new Vector<Employee>();
        employeesUsed.add(expectedResult);
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee AS emp WHERE emp.id = " + expectedResult.getId();
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"Equals test with As failed", (boolean)comparer.compareObjects((Object)expectedResult, (Collection)result));
    }

    public void collectionMemberIdentifierEqualsTest() {
        EntityManager em = this.createEntityManager();
        ExpressionBuilder employees = new ExpressionBuilder();
        Expression exp = employees.get("firstName").equal((Object)"Bob");
        exp = exp.and(employees.get("lastName").equal((Object)"Smith"));
        Employee expectedResult = (Employee)JUnitJPQLSimpleTestSuite.getServerSession().readAllObjects(Employee.class, exp).firstElement();
        this.clearCache();
        PhoneNumber phoneNumber = (PhoneNumber)((Vector)expectedResult.getPhoneNumbers()).firstElement();
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp, IN (emp.phoneNumbers) phone WHERE phone = ?1";
        List result = em.createQuery(ejbqlString).setParameter(1, (Object)phoneNumber).getResultList();
        Assert.assertTrue((String)"CollectionMemberIdentifierEqualsTest failed", (boolean)comparer.compareObjects((Object)expectedResult, (Collection)result));
    }

    public void abstractSchemaIdentifierEqualsTest() {
        EntityManager em = this.createEntityManager();
        Employee expectedResult = (Employee)JUnitJPQLSimpleTestSuite.getServerSession().readAllObjects(Employee.class).firstElement();
        this.clearCache();
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE emp = ?1";
        List result = em.createQuery(ejbqlString).setParameter(1, (Object)expectedResult).getResultList();
        Assert.assertTrue((String)"abstractSchemaIdentifierEqualsTest failed", (boolean)comparer.compareObjects((Object)expectedResult, (Collection)result));
    }

    public void abstractSchemaIdentifierNotEqualsTest() {
        EntityManager em = this.createEntityManager();
        Vector expectedResult = JUnitJPQLSimpleTestSuite.getServerSession().readAllObjects(Employee.class);
        this.clearCache();
        Employee emp = (Employee)expectedResult.firstElement();
        expectedResult.removeElementAt(0);
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE emp <> ?1";
        List result = em.createQuery(ejbqlString).setParameter(1, (Object)emp).getResultList();
        Assert.assertTrue((String)"abstractSchemaIdentifierNotEqualsTest failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
    }

    public void simpleInOneDotTest() {
        EntityManager em = this.createEntityManager();
        ReadObjectQuery roq = new ReadObjectQuery(Employee.class);
        ExpressionBuilder empBldr = new ExpressionBuilder();
        Expression exp1 = empBldr.get("firstName").equal((Object)"Bob");
        Expression exp2 = empBldr.get("lastName").equal((Object)"Smith");
        roq.setSelectionCriteria(exp1.and(exp2));
        Employee expectedResult = (Employee)JUnitJPQLSimpleTestSuite.getServerSession().executeQuery((DatabaseQuery)roq);
        this.clearCache();
        PhoneNumber empPhoneNumbers = (PhoneNumber)((Vector)expectedResult.getPhoneNumbers()).firstElement();
        String ejbqlString = "SelecT OBJECT(emp) from Employee emp, in (emp.phoneNumbers) phone Where phone.areaCode = \"" + empPhoneNumbers.getAreaCode() + "\"" + "AND emp.firstName = \"" + expectedResult.getFirstName() + "\"";
        ejbqlString = ejbqlString + "AND emp.lastName = \"" + expectedResult.getLastName() + "\"";
        Employee result = (Employee)em.createQuery(ejbqlString).getSingleResult();
        Assert.assertTrue((String)"Simple In Dot Test failed", (boolean)comparer.compareObjects((Object)result, expectedResult));
    }

    public void selectAverageQueryForByteColumnTest() {
        EntityManager em = this.createEntityManager();
        String ejbqlString = "Select AVG(emp.salary)from Employee emp";
        Object result = em.createQuery(ejbqlString).getSingleResult();
        Assert.assertTrue((String)("AVG result type [" + result.getClass() + "] not of type Double"), (result.getClass() == Double.class ? 1 : 0) != 0);
    }

    public void simpleInTest() {
        EntityManager em = this.createEntityManager();
        Employee expectedResult = (Employee)JUnitJPQLSimpleTestSuite.getServerSession().readAllObjects(Employee.class).elementAt(0);
        this.clearCache();
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE emp.id IN (" + expectedResult.getId().toString() + ")";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"Simple In Test failed", (boolean)comparer.compareObjects((Object)result, expectedResult));
    }

    public void simpleInListTest() {
        EntityManager em = this.createEntityManager();
        Employee expectedResult = (Employee)JUnitJPQLSimpleTestSuite.getServerSession().readAllObjects(Employee.class).elementAt(0);
        ArrayList<Integer> expectedResultList = new ArrayList<Integer>();
        expectedResultList.add(expectedResult.getId());
        this.clearCache();
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE emp.id IN :result";
        List result = em.createQuery(ejbqlString).setParameter("result", expectedResultList).getResultList();
        Assert.assertTrue((String)"Simple In Test failed", (boolean)comparer.compareObjects((Object)result, expectedResult));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleInNegativeTest() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Employee expectedResult = new Employee();
            expectedResult.setSalary(-12345);
            em.persist((Object)expectedResult);
            em.flush();
            this.clearCache();
            String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE emp.salary IN(-12345)";
            Employee result = (Employee)em.createQuery(ejbqlString).getSingleResult();
            Assert.assertTrue((String)"Simple In Negative Test failed", (boolean)comparer.compareObjects((Object)result, expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    public void simpleLengthTest() {
        if (JUnitTestCase.getServerSession().getPlatform().isSQLServer()) {
            JUnitJPQLSimpleTestSuite.getServerSession().logMessage("Warning SQL doesnot support LENGTH function");
            return;
        }
        EntityManager em = this.createEntityManager();
        Employee expectedResult = (Employee)JUnitJPQLSimpleTestSuite.getServerSession().readAllObjects(Employee.class).elementAt(0);
        this.clearCache();
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE ";
        ejbqlString = ejbqlString + "LENGTH ( emp.firstName     ) = ";
        ejbqlString = ejbqlString + expectedResult.getFirstName().length();
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"Simple Length Test failed", (boolean)comparer.compareObjects((Object)result, expectedResult));
    }

    public void simpleLikeTest() {
        EntityManager em = this.createEntityManager();
        Employee expectedResult = (Employee)JUnitJPQLSimpleTestSuite.getServerSession().readAllObjects(Employee.class).elementAt(0);
        this.clearCache();
        String partialFirstName = expectedResult.getFirstName().substring(0, 3) + "%";
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE emp.firstName LIKE \"" + partialFirstName + "\"";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"Simple Like Test failed", (boolean)comparer.compareObjects((Object)result, expectedResult));
    }

    public void simpleLikeTestWithParameter() {
        EntityManager em = this.createEntityManager();
        Employee emp = (Employee)JUnitJPQLSimpleTestSuite.getServerSession().readAllObjects(Employee.class).elementAt(0);
        String partialFirstName = "%" + emp.getFirstName().substring(0, 3) + "%";
        ReadAllQuery raq = new ReadAllQuery();
        raq.setReferenceClass(Employee.class);
        Vector<String> parameters = new Vector<String>();
        parameters.add(partialFirstName);
        ExpressionBuilder eb = new ExpressionBuilder();
        Expression whereClause = eb.get("firstName").like(partialFirstName);
        raq.setSelectionCriteria(whereClause);
        Vector expectedResult = (Vector)JUnitJPQLSimpleTestSuite.getServerSession().executeQuery((DatabaseQuery)raq);
        this.clearCache();
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE emp.firstName LIKE ?1";
        List result = em.createQuery(ejbqlString).setParameter(1, (Object)partialFirstName).getResultList();
        Assert.assertTrue((String)"Simple Like Test with Parameter failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
    }

    public void simpleLikeEscapeTestWithParameter() {
        EntityManager em = this.createEntityManager();
        Address expectedResult = new Address();
        expectedResult.setCity("TAIYUAN");
        expectedResult.setCountry("CHINA");
        expectedResult.setProvince("SHANXI");
        expectedResult.setPostalCode("030024");
        expectedResult.setStreet("234 RUBY _Way");
        ServerSession serverSession = JUnitTestCase.getServerSession();
        ClientSession clientSession = serverSession.acquireClientSession();
        UnitOfWork uow = clientSession.acquireUnitOfWork();
        uow.registerObject((Object)expectedResult);
        uow.commit();
        String ejbqlString = "SELECT OBJECT(address) FROM Address address WHERE address.street LIKE :pattern ESCAPE :esc";
        String patternString = null;
        Character escChar = null;
        if (JUnitJPQLSimpleTestSuite.getServerSession().getPlatform().isMySQL()) {
            patternString = "234 RUBY $_Way";
            escChar = new Character('$');
        } else {
            patternString = "234 RUBY \\_Way";
            escChar = new Character('\\');
        }
        List result = em.createQuery(ejbqlString).setParameter("pattern", (Object)patternString).setParameter("esc", (Object)escChar).getResultList();
        Assert.assertTrue((String)"Simple Escape Underscore test failed", (boolean)comparer.compareObjects((Object)result, expectedResult));
    }

    public void simpleNotBetweenTest() {
        EntityManager em = this.createEntityManager();
        Employee emp1 = (Employee)JUnitJPQLSimpleTestSuite.getServerSession().readAllObjects(Employee.class).firstElement();
        Employee emp2 = (Employee)JUnitJPQLSimpleTestSuite.getServerSession().readAllObjects(Employee.class).lastElement();
        ReadAllQuery raq = new ReadAllQuery();
        raq.setReferenceClass(Employee.class);
        ExpressionBuilder eb = new ExpressionBuilder();
        Expression whereClause = eb.get("id").between((Object)emp1.getId(), (Object)emp2.getId()).not();
        raq.setSelectionCriteria(whereClause);
        Vector expectedResult = (Vector)JUnitJPQLSimpleTestSuite.getServerSession().executeQuery((DatabaseQuery)raq);
        this.clearCache();
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE ";
        ejbqlString = ejbqlString + "emp.id NOT BETWEEN ";
        ejbqlString = ejbqlString + emp1.getId().toString();
        ejbqlString = ejbqlString + " AND ";
        ejbqlString = ejbqlString + emp2.getId().toString();
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"Simple Not Between Test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
    }

    public void simpleNotEqualsVariablesInteger() {
        EntityManager em = this.createEntityManager();
        Vector expectedResult = JUnitJPQLSimpleTestSuite.getServerSession().readAllObjects(Employee.class);
        this.clearCache();
        Employee emp = (Employee)expectedResult.elementAt(0);
        expectedResult.removeElementAt(0);
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE emp.id <> " + emp.getId();
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"Simple Like Test with Parameter failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
    }

    public void simpleNotInTest() {
        EntityManager em = this.createEntityManager();
        Employee emp = (Employee)JUnitJPQLSimpleTestSuite.getServerSession().readAllObjects(Employee.class).elementAt(0);
        ExpressionBuilder builder = new ExpressionBuilder();
        Vector<Integer> idVector = new Vector<Integer>();
        idVector.add(emp.getId());
        Expression whereClause = builder.get("id").notIn(idVector);
        ReadAllQuery raq = new ReadAllQuery();
        raq.setReferenceClass(Employee.class);
        raq.setSelectionCriteria(whereClause);
        Vector expectedResult = (Vector)JUnitJPQLSimpleTestSuite.getServerSession().executeQuery((DatabaseQuery)raq);
        this.clearCache();
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE emp.id NOT IN (" + emp.getId().toString() + ")";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"Simple Not In Test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
    }

    public void simpleNotLikeTest() {
        EntityManager em = this.createEntityManager();
        Employee emp = (Employee)JUnitJPQLSimpleTestSuite.getServerSession().readAllObjects(Employee.class).elementAt(0);
        String partialFirstName = emp.getFirstName().substring(0, 3) + "%";
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = builder.get("firstName").notLike(partialFirstName);
        ReadAllQuery raq = new ReadAllQuery();
        raq.setReferenceClass(Employee.class);
        raq.setSelectionCriteria(whereClause);
        Vector expectedResult = (Vector)JUnitJPQLSimpleTestSuite.getServerSession().executeQuery((DatabaseQuery)raq);
        this.clearCache();
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE emp.firstName NOT LIKE \"" + partialFirstName + "\"";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"Simple Not Like Test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
    }

    public void simpleOrFollowedByAndTest() {
        EntityManager em = this.createEntityManager();
        Employee emp1 = (Employee)JUnitJPQLSimpleTestSuite.getServerSession().readAllObjects(Employee.class).elementAt(0);
        Employee emp2 = (Employee)JUnitJPQLSimpleTestSuite.getServerSession().readAllObjects(Employee.class).elementAt(1);
        Employee emp3 = (Employee)JUnitJPQLSimpleTestSuite.getServerSession().readAllObjects(Employee.class).elementAt(2);
        Vector<Employee> expectedResult = new Vector<Employee>();
        expectedResult.add(emp1);
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE emp.id = " + emp1.getId() + " OR emp.id = " + emp2.getId() + " AND emp.id = " + emp3.getId();
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"Simple Or followed by And Test failed", (boolean)comparer.compareObjects(result, expectedResult));
    }

    public void simpleOrFollowedByAndTestWithStaticNames() {
        EntityManager em = this.createEntityManager();
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = builder.get("firstName").equal((Object)"John").or(builder.get("firstName").equal((Object)"Bob").and(builder.get("lastName").equal((Object)"Smith")));
        ReadAllQuery raq = new ReadAllQuery();
        raq.setReferenceClass(Employee.class);
        raq.setSelectionCriteria(whereClause);
        Vector expectedResult = (Vector)JUnitJPQLSimpleTestSuite.getServerSession().executeQuery((DatabaseQuery)raq);
        this.clearCache();
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE emp.firstName = \"John\" OR emp.firstName = \"Bob\" AND emp.lastName = \"Smith\"";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"Simple Or followed by And With Static Names Test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
    }

    public void simpleOrTest() {
        EntityManager em = this.createEntityManager();
        Employee emp1 = (Employee)JUnitJPQLSimpleTestSuite.getServerSession().readAllObjects(Employee.class).elementAt(0);
        Employee emp2 = (Employee)JUnitJPQLSimpleTestSuite.getServerSession().readAllObjects(Employee.class).elementAt(1);
        Vector<Employee> expectedResult = new Vector<Employee>();
        expectedResult.add(emp1);
        expectedResult.add(emp2);
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE emp.id = " + emp1.getId() + " OR emp.id = " + emp2.getId();
        List result = em.createQuery(ejbqlString).getResultList();
        this.clearCache();
        Assert.assertTrue((String)"Simple Or Test failed", (boolean)comparer.compareObjects(result, expectedResult));
    }

    public void simpleParameterTest() {
        EntityManager em = this.createEntityManager();
        Employee expectedResult = (Employee)JUnitJPQLSimpleTestSuite.getServerSession().readAllObjects(Employee.class).elementAt(0);
        String parameterName = "firstName";
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = builder.get("firstName").equal(builder.getParameter(parameterName));
        ReadAllQuery raq = new ReadAllQuery();
        raq.setReferenceClass(Employee.class);
        raq.setSelectionCriteria(whereClause);
        raq.addArgument(parameterName);
        Vector<String> parameters = new Vector<String>();
        parameters.add(expectedResult.getFirstName());
        List employees = (List)JUnitJPQLSimpleTestSuite.getServerSession().executeQuery((DatabaseQuery)raq, parameters);
        employees.size();
        this.clearCache();
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE emp.firstName = ?1 ";
        List result = em.createQuery(ejbqlString).setParameter(1, parameters.get(0)).getResultList();
        Assert.assertTrue((String)"Simple Parameter Test failed", (boolean)comparer.compareObjects((Object)result, expectedResult));
    }

    public void simpleParameterTestChangingParameters() {
        EntityManager em = this.createEntityManager();
        Employee emp1 = (Employee)JUnitJPQLSimpleTestSuite.getServerSession().readAllObjects(Employee.class).elementAt(0);
        Employee emp2 = (Employee)JUnitJPQLSimpleTestSuite.getServerSession().readAllObjects(Employee.class).elementAt(1);
        String parameterName = "firstName";
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = builder.get("firstName").equal(builder.getParameter(parameterName));
        ReadAllQuery raq = new ReadAllQuery();
        raq.setReferenceClass(Employee.class);
        raq.setSelectionCriteria(whereClause);
        raq.addArgument(parameterName);
        Vector<String> firstParameters = new Vector<String>();
        firstParameters.add(emp1.getFirstName());
        Vector<String> secondParameters = new Vector<String>();
        secondParameters.add(emp2.getFirstName());
        Vector firstEmployees = (Vector)JUnitJPQLSimpleTestSuite.getServerSession().executeQuery((DatabaseQuery)raq, firstParameters);
        this.clearCache();
        Vector secondEmployees = (Vector)JUnitJPQLSimpleTestSuite.getServerSession().executeQuery((DatabaseQuery)raq, secondParameters);
        this.clearCache();
        Vector expectedResult = new Vector();
        expectedResult.addAll(firstEmployees);
        expectedResult.addAll(secondEmployees);
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE emp.firstName = ?1 ";
        List firstResultSet = em.createQuery(ejbqlString).setParameter(1, firstParameters.get(0)).getResultList();
        this.clearCache();
        List secondResultSet = em.createQuery(ejbqlString).setParameter(1, secondParameters.get(0)).getResultList();
        this.clearCache();
        Vector result = new Vector();
        result.addAll(firstResultSet);
        result.addAll(secondResultSet);
        Assert.assertTrue((String)"Simple Parameter Test Changing Parameters failed", (boolean)comparer.compareObjects(result, expectedResult));
    }

    public void simpleReverseAbsTest() {
        EntityManager em = this.createEntityManager();
        Employee expectedResult = (Employee)JUnitJPQLSimpleTestSuite.getServerSession().readAllObjects(Employee.class).elementAt(0);
        this.clearCache();
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE " + expectedResult.getSalary() + " = ABS(emp.salary)";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"Simple Reverse Abs test failed", (boolean)comparer.compareObjects((Object)result, expectedResult));
    }

    public void simpleReverseConcatTest() {
        EntityManager em = this.createEntityManager();
        Employee expectedResult = (Employee)JUnitJPQLSimpleTestSuite.getServerSession().readAllObjects(Employee.class).elementAt(0);
        this.clearCache();
        String partOne = expectedResult.getFirstName().substring(0, 2);
        String partTwo = expectedResult.getFirstName().substring(2);
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE ";
        ejbqlString = ejbqlString + "CONCAT(\"";
        ejbqlString = ejbqlString + partOne;
        ejbqlString = ejbqlString + "\", \"";
        ejbqlString = ejbqlString + partTwo;
        ejbqlString = ejbqlString + "\")";
        ejbqlString = ejbqlString + " = emp.firstName";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"Simple Reverse Concat test failed", (boolean)comparer.compareObjects((Object)result, expectedResult));
    }

    public void simpleReverseEqualsTest() {
        EntityManager em = this.createEntityManager();
        Employee expectedResult = (Employee)JUnitJPQLSimpleTestSuite.getServerSession().readAllObjects(Employee.class).elementAt(0);
        this.clearCache();
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE ";
        ejbqlString = ejbqlString + "\"" + expectedResult.getFirstName() + "\"";
        ejbqlString = ejbqlString + " = emp.firstName";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"Simple Reverse Equals test failed", (boolean)comparer.compareObjects((Object)result, expectedResult));
    }

    public void simpleReverseLengthTest() {
        EntityManager em = this.createEntityManager();
        Employee expectedResult = (Employee)JUnitJPQLSimpleTestSuite.getServerSession().readAllObjects(Employee.class).elementAt(0);
        this.clearCache();
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE ";
        ejbqlString = ejbqlString + expectedResult.getFirstName().length();
        ejbqlString = ejbqlString + " = LENGTH(emp.firstName)";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"Simple Reverse Length test failed", (boolean)comparer.compareObjects((Object)result, expectedResult));
    }

    public void simpleReverseParameterTest() {
        EntityManager em = this.createEntityManager();
        Employee emp = (Employee)JUnitJPQLSimpleTestSuite.getServerSession().readAllObjects(Employee.class).elementAt(0);
        this.clearCache();
        String parameterName = "firstName";
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = builder.get("firstName").equal(builder.getParameter(parameterName));
        ReadAllQuery raq = new ReadAllQuery();
        raq.setReferenceClass(Employee.class);
        raq.setSelectionCriteria(whereClause);
        raq.addArgument(parameterName);
        Vector<String> parameters = new Vector<String>();
        parameters.add(emp.getFirstName());
        Vector expectedResult = (Vector)JUnitJPQLSimpleTestSuite.getServerSession().executeQuery((DatabaseQuery)raq, parameters);
        this.clearCache();
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE ";
        ejbqlString = ejbqlString + "?1 = emp.firstName ";
        List result = em.createQuery(ejbqlString).setParameter(1, parameters.get(0)).getResultList();
        Assert.assertTrue((String)"Simple Reverse Parameter test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
    }

    public void simpleReverseSqrtTest() {
        if (JUnitTestCase.getServerSession().getPlatform().isSymfoware()) {
            JUnitJPQLSimpleTestSuite.getServerSession().logMessage("Test simpleReverseSqrtTest skipped for this platform, Symfoware doesn't support SQRT, COS, SIN, TAN functions.");
            return;
        }
        EntityManager em = this.createEntityManager();
        ExpressionBuilder expbldr = new ExpressionBuilder();
        Expression whereClause = expbldr.get("firstName").equal((Object)"SquareRoot").and(expbldr.get("lastName").equal((Object)"TestCase1"));
        ReadAllQuery raq = new ReadAllQuery();
        raq.setReferenceClass(Employee.class);
        raq.setSelectionCriteria(whereClause);
        Vector expectedResult = (Vector)JUnitJPQLSimpleTestSuite.getServerSession().executeQuery((DatabaseQuery)raq);
        double salarySquareRoot = Math.sqrt(new Double(((Employee)expectedResult.firstElement()).getSalary()));
        this.clearCache();
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE ";
        ejbqlString = ejbqlString + salarySquareRoot;
        ejbqlString = ejbqlString + " = SQRT(emp.salary)";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"Simple Reverse Square Root test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
    }

    public void simpleReverseSubstringTest() {
        EntityManager em = this.createEntityManager();
        Employee expectedResult = (Employee)JUnitJPQLSimpleTestSuite.getServerSession().readAllObjects(Employee.class).elementAt(0);
        this.clearCache();
        String firstNamePart = expectedResult.getFirstName().substring(0, 2);
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE ";
        ejbqlString = ejbqlString + "\"" + firstNamePart + "\"";
        ejbqlString = ejbqlString + " = SUBSTRING(emp.firstName, 1, 2)";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"Simple Reverse SubString test failed", (boolean)comparer.compareObjects((Object)result, expectedResult));
    }

    public void simpleSqrtTest() {
        if (JUnitTestCase.getServerSession().getPlatform().isSymfoware()) {
            JUnitJPQLSimpleTestSuite.getServerSession().logMessage("Test simpleSqrtTest skipped for this platform, Symfoware doesn't support SQRT, COS, SIN, TAN functions.");
            return;
        }
        EntityManager em = this.createEntityManager();
        ExpressionBuilder expbldr = new ExpressionBuilder();
        Expression whereClause = expbldr.get("firstName").equal((Object)"SquareRoot").and(expbldr.get("lastName").equal((Object)"TestCase1"));
        ReadAllQuery raq = new ReadAllQuery();
        raq.setReferenceClass(Employee.class);
        raq.setSelectionCriteria(whereClause);
        Vector expectedResult = (Vector)JUnitJPQLSimpleTestSuite.getServerSession().executeQuery((DatabaseQuery)raq);
        double salarySquareRoot = Math.sqrt(new Double(((Employee)expectedResult.firstElement()).getSalary()));
        this.clearCache();
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE ";
        ejbqlString = ejbqlString + "SQRT(emp.salary) = ";
        ejbqlString = ejbqlString + salarySquareRoot;
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"Simple Square Root test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
    }

    public void simpleSubstringTest() {
        EntityManager em = this.createEntityManager();
        Employee expectedResult = (Employee)JUnitJPQLSimpleTestSuite.getServerSession().readAllObjects(Employee.class).elementAt(0);
        this.clearCache();
        String firstNamePart = expectedResult.getFirstName().substring(0, 2);
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE ";
        ejbqlString = ejbqlString + "SUBSTRING(emp.firstName, 1, 2) = \"";
        ejbqlString = ejbqlString + firstNamePart + "\"";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"Simple SubString test failed", (boolean)comparer.compareObjects((Object)result, expectedResult));
    }

    public void simpleNullTest() {
        EntityManager em = this.createEntityManager();
        Employee nullEmployee = new Employee();
        nullEmployee.setFirstName(null);
        nullEmployee.setLastName("Test");
        ServerSession serverSession = JUnitTestCase.getServerSession();
        ClientSession clientSession = serverSession.acquireClientSession();
        UnitOfWork uow = clientSession.acquireUnitOfWork();
        uow.registerObject((Object)nullEmployee);
        uow.commit();
        ReadAllQuery raq = new ReadAllQuery();
        raq.setReferenceClass(Employee.class);
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = builder.get("firstName").isNull();
        raq.setSelectionCriteria(whereClause);
        Vector expectedResult = (Vector)JUnitJPQLSimpleTestSuite.getServerSession().executeQuery((DatabaseQuery)raq);
        this.clearCache();
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE emp.firstName IS NULL";
        List result = em.createQuery(ejbqlString).getResultList();
        uow = clientSession.acquireUnitOfWork();
        uow.deleteObject((Object)nullEmployee);
        uow.commit();
        Assert.assertTrue((String)"Simple Null test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
    }

    public void simpleNotNullTest() {
        EntityManager em = this.createEntityManager();
        Employee nullEmployee = new Employee();
        nullEmployee.setFirstName(null);
        nullEmployee.setLastName("Test");
        ServerSession serverSession = JUnitTestCase.getServerSession();
        ClientSession clientSession = serverSession.acquireClientSession();
        UnitOfWork uow = clientSession.acquireUnitOfWork();
        uow.registerObject((Object)nullEmployee);
        uow.commit();
        ReadAllQuery raq = new ReadAllQuery();
        raq.setReferenceClass(Employee.class);
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = builder.get("firstName").isNull().not();
        raq.setSelectionCriteria(whereClause);
        Vector expectedResult = (Vector)JUnitJPQLSimpleTestSuite.getServerSession().executeQuery((DatabaseQuery)raq);
        this.clearCache();
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE emp.firstName IS NOT NULL";
        List result = em.createQuery(ejbqlString).getResultList();
        uow = clientSession.acquireUnitOfWork();
        uow.deleteObject((Object)nullEmployee);
        uow.commit();
        Assert.assertTrue((String)"Simple Not Null test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
    }

    public void distinctTest() {
        EntityManager em = this.createEntityManager();
        ReadAllQuery raq = new ReadAllQuery();
        ExpressionBuilder employee = new ExpressionBuilder();
        Expression whereClause = employee.get("lastName").equal((Object)"Smith");
        raq.setReferenceClass(Employee.class);
        raq.setSelectionCriteria(whereClause);
        raq.useDistinct();
        Vector expectedResult = (Vector)JUnitJPQLSimpleTestSuite.getServerSession().executeQuery((DatabaseQuery)raq);
        this.clearCache();
        String ejbqlString = "SELECT DISTINCT OBJECT(emp) FROM Employee emp WHERE emp.lastName = 'Smith'";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"Distinct test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
    }

    public void multipleExecutionOfNamedQueryTest() {
        EntityManager em = this.createEntityManager();
        Query query = em.createNamedQuery("findEmployeeByPostalCode");
        query.setParameter("postalCode", (Object)"K1T3B9");
        try {
            query.getResultList();
        }
        catch (RuntimeException ex) {
            JUnitJPQLSimpleTestSuite.fail((String)"Failed to execute query, exception resulted on first execution, not expected");
        }
        try {
            query.getResultList();
        }
        catch (RuntimeException ex) {
            JUnitJPQLSimpleTestSuite.fail((String)"Failed to execute query, exception resulted on second execution");
        }
        query = em.createNamedQuery("findEmployeeByPostalCode");
        query.setParameter("postalCode", (Object)"K1T3B9");
        try {
            query.getResultList();
        }
        catch (RuntimeException ex) {
            JUnitJPQLSimpleTestSuite.fail((String)"Failed to execute query, exception resulted on first execution, of second use of named query");
        }
        query.setMaxResults(100000);
        try {
            query.getResultList();
        }
        catch (RuntimeException ex) {
            JUnitJPQLSimpleTestSuite.fail((String)"Failed to execute query, exception resulted after setting max results (forcing reprepare)");
        }
    }

    public void conformResultsInUnitOfWorkTest() {
        ReadObjectQuery readObjectQuery = new ReadObjectQuery();
        readObjectQuery.setReferenceClass(Employee.class);
        readObjectQuery.setEJBQLString("SELECT OBJECT(emp) FROM Employee emp WHERE emp.id = ?1");
        readObjectQuery.conformResultsInUnitOfWork();
        readObjectQuery.addArgument("1", Integer.class);
        Server serverSession = JUnitJPQLSimpleTestSuite.getServerSession().getProject().createServerSession();
        serverSession.setSessionLog(JUnitJPQLSimpleTestSuite.getServerSession().getSessionLog());
        serverSession.login();
        UnitOfWork unitOfWork = serverSession.acquireUnitOfWork();
        Employee newEmployee = new Employee();
        newEmployee.setId(new Integer(9000));
        unitOfWork.registerObject((Object)newEmployee);
        Vector<Integer> testV = new Vector<Integer>();
        testV.addElement(new Integer(9000));
        Employee result = (Employee)unitOfWork.executeQuery((DatabaseQuery)readObjectQuery, testV);
        Assert.assertTrue((String)"Conform Results In Unit of Work using ServerSession failed", (boolean)comparer.compareObjects((Object)result, newEmployee));
        serverSession.logout();
    }

    public void simpleModTest() {
        EntityManager em = this.createEntityManager();
        ReadAllQuery raq = new ReadAllQuery();
        ExpressionBuilder employee = new ExpressionBuilder();
        Expression whereClause = ExpressionMath.mod((Expression)employee.get("salary"), (int)2).greaterThan(0);
        raq.setReferenceClass(Employee.class);
        raq.setSelectionCriteria(whereClause);
        Vector expectedResult = (Vector)JUnitJPQLSimpleTestSuite.getServerSession().executeQuery((DatabaseQuery)raq);
        this.clearCache();
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE MOD(emp.salary, 2) > 0";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"Simple Mod test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        expectedResult = JUnitJPQLSimpleTestSuite.getServerSession().readAllObjects(Employee.class);
        this.clearCache();
        ejbqlString = "SELECT emp FROM Employee emp WHERE MOD(emp.salary, emp.salary) = 0";
        result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"Simple Mod test(2) failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
    }

    public void simpleIsEmptyTest() {
        EntityManager em = this.createEntityManager();
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = builder.isEmpty("phoneNumbers");
        ReadAllQuery raq = new ReadAllQuery();
        raq.setReferenceClass(Employee.class);
        raq.setSelectionCriteria(whereClause);
        Vector expectedResult = (Vector)JUnitJPQLSimpleTestSuite.getServerSession().executeQuery((DatabaseQuery)raq);
        this.clearCache();
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE emp.phoneNumbers IS EMPTY";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"Simple Is empty test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
    }

    public void simpleIsNotEmptyTest() {
        EntityManager em = this.createEntityManager();
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = builder.notEmpty("phoneNumbers");
        ReadAllQuery raq = new ReadAllQuery();
        raq.setReferenceClass(Employee.class);
        raq.setSelectionCriteria(whereClause);
        Vector expectedResult = (Vector)JUnitJPQLSimpleTestSuite.getServerSession().executeQuery((DatabaseQuery)raq);
        this.clearCache();
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE emp.phoneNumbers IS NOT EMPTY";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"Simple is not empty test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
    }

    public void simpleApostrohpeTest() {
        EntityManager em = this.createEntityManager();
        Vector addresses = JUnitJPQLSimpleTestSuite.getServerSession().readAllObjects(Address.class);
        this.clearCache();
        Address expectedResult = new Address();
        Iterator addressesIterator = addresses.iterator();
        while (addressesIterator.hasNext() && (expectedResult = (Address)addressesIterator.next()).getStreet().indexOf("Lost") == -1) {
        }
        String ejbqlString = "SELECT OBJECT(address) FROM Address address WHERE ";
        ejbqlString = ejbqlString + "address.street = '234 I''m Lost Lane'";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"Simple apostrophe test failed", (boolean)comparer.compareObjects((Object)result, expectedResult));
    }

    public void simpleEscapeUnderscoreTest() {
        EntityManager em = this.createEntityManager();
        Address expectedResult = new Address();
        expectedResult.setCity("Perth");
        expectedResult.setCountry("Canada");
        expectedResult.setProvince("ONT");
        expectedResult.setPostalCode("Y3Q2N9");
        expectedResult.setStreet("234 Wandering _Way");
        ServerSession serverSession = JUnitTestCase.getServerSession();
        ClientSession clientSession = serverSession.acquireClientSession();
        UnitOfWork uow = clientSession.acquireUnitOfWork();
        uow.registerObject((Object)expectedResult);
        uow.commit();
        String ejbqlString = "SELECT OBJECT(address) FROM Address address WHERE ";
        ejbqlString = JUnitJPQLSimpleTestSuite.getServerSession().getPlatform().isMySQL() || JUnitJPQLSimpleTestSuite.getServerSession().getPlatform().isPostgreSQL() ? ejbqlString + "address.street LIKE '234 Wandering $_Way' ESCAPE '$'" : ejbqlString + "address.street LIKE '234 Wandering \\_Way' ESCAPE '\\'";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"Simple Escape Underscore test failed", (boolean)comparer.compareObjects((Object)result, expectedResult));
    }

    public void smallProjectMemberOfProjectsTest() {
        EntityManager em = this.createEntityManager();
        ReadAllQuery query = new ReadAllQuery();
        Expression selectionCriteria = new ExpressionBuilder().anyOf("projects").equal((Expression)new ExpressionBuilder(SmallProject.class));
        query.setSelectionCriteria(selectionCriteria);
        query.setReferenceClass(Employee.class);
        query.dontUseDistinct();
        Vector expectedResult = (Vector)JUnitJPQLSimpleTestSuite.getServerSession().executeQuery((DatabaseQuery)query);
        this.clearCache();
        String ejbqlString = "SELECT OBJECT(employee) FROM Employee employee, SmallProject sp WHERE ";
        ejbqlString = ejbqlString + "sp MEMBER OF employee.projects";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"Simple small Project Member Of Projects test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
    }

    public void smallProjectNOTMemberOfProjectsTest() {
        EntityManager em = this.createEntityManager();
        ReadObjectQuery smallProjectQuery = new ReadObjectQuery();
        smallProjectQuery.setReferenceClass(SmallProject.class);
        smallProjectQuery.setSelectionCriteria(new ExpressionBuilder().get("name").equal((Object)"Enterprise"));
        SmallProject smallProject = (SmallProject)JUnitJPQLSimpleTestSuite.getServerSession().executeQuery((DatabaseQuery)smallProjectQuery);
        ReadAllQuery query = new ReadAllQuery();
        query.addArgument("smallProject");
        Expression selectionCriteria = new ExpressionBuilder().noneOf("projects", new ExpressionBuilder().equal(new ExpressionBuilder().getParameter("smallProject")));
        query.setSelectionCriteria(selectionCriteria);
        query.setReferenceClass(Employee.class);
        Vector<SmallProject> arguments = new Vector<SmallProject>();
        arguments.add(smallProject);
        Vector expectedResult = (Vector)JUnitJPQLSimpleTestSuite.getServerSession().executeQuery((DatabaseQuery)query, arguments);
        String ejbqlString = "SELECT OBJECT(employee) FROM Employee employee WHERE ";
        ejbqlString = ejbqlString + "?1 NOT MEMBER OF employee.projects";
        List result = em.createQuery(ejbqlString).setParameter(1, (Object)smallProject).getResultList();
        Assert.assertTrue((String)"Simple small Project NOT Member Of Projects test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
    }

    public void selectCountOneToOneTest() {
        EntityManager em = this.createEntityManager();
        ReportQuery query = new ReportQuery();
        query.setReferenceClass(PhoneNumber.class);
        query.addCount("COUNT", new ExpressionBuilder().get("owner").distinct(), Long.class);
        query.returnSingleAttribute();
        query.dontRetrievePrimaryKeys();
        query.setName("selectEmployeesThatHavePhoneNumbers");
        Vector expectedResult = (Vector)JUnitJPQLSimpleTestSuite.getServerSession().executeQuery((DatabaseQuery)query);
        this.clearCache();
        String ejbqlString = "SELECT COUNT(DISTINCT phone.owner) FROM PhoneNumber phone";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"Simple Select Count One To One test failed", (boolean)expectedResult.elementAt(0).equals(result.get(0)));
    }

    public void selectOneToOneTest() {
        EntityManager em = this.createEntityManager();
        ReadAllQuery query = new ReadAllQuery();
        query.setReferenceClass(Address.class);
        query.useDistinct();
        ExpressionBuilder employeeBuilder = new ExpressionBuilder(Employee.class);
        Expression selectionCriteria = new ExpressionBuilder(Address.class).equal(employeeBuilder.get("address")).and(employeeBuilder.get("lastName").like("%Way%"));
        query.setSelectionCriteria(selectionCriteria);
        if (JUnitJPQLSimpleTestSuite.usesSOP() && JUnitJPQLSimpleTestSuite.getServerSession().getPlatform().isOracle()) {
            query.setShouldUseSerializedObjectPolicy(false);
        }
        Vector expectedResult = (Vector)JUnitJPQLSimpleTestSuite.getServerSession().executeQuery((DatabaseQuery)query);
        this.clearCache();
        String ejbqlString = "SELECT DISTINCT employee.address FROM Employee employee WHERE employee.lastName LIKE '%Way%'";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"Simple Select One To One test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
    }

    public void selectPhonenumberDeclaredInINClauseTest() {
        EntityManager em = this.createEntityManager();
        ReadAllQuery query = new ReadAllQuery();
        ExpressionBuilder employeeBuilder = new ExpressionBuilder(Employee.class);
        Expression phoneAnyOf = employeeBuilder.anyOf("phoneNumbers");
        ExpressionBuilder phoneBuilder = new ExpressionBuilder(PhoneNumber.class);
        Expression selectionCriteria = phoneBuilder.equal(employeeBuilder.anyOf("phoneNumbers")).and(phoneAnyOf.get("number").notNull());
        query.setSelectionCriteria(selectionCriteria);
        query.setReferenceClass(PhoneNumber.class);
        query.addAscendingOrdering("number");
        query.addAscendingOrdering("areaCode");
        Vector expectedResult = (Vector)JUnitJPQLSimpleTestSuite.getServerSession().executeQuery((DatabaseQuery)query);
        this.clearCache();
        String ejbqlString = "Select Distinct Object(p) from Employee emp, IN(emp.phoneNumbers) p WHERE ";
        ejbqlString = ejbqlString + "p.number IS NOT NULL ORDER BY p.number, p.areaCode";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"Simple select Phonenumber Declared In IN Clause test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
    }

    public void selectPhoneUsingALLTest() {
        EntityManager em = this.createEntityManager();
        ReadAllQuery query = new ReadAllQuery();
        ExpressionBuilder employeeBuilder = new ExpressionBuilder(Employee.class);
        ReportQuery subQuery = new ReportQuery();
        subQuery.setReferenceClass(PhoneNumber.class);
        subQuery.addMinimum("number");
        Expression selectionCriteria = employeeBuilder.anyOf("phoneNumbers").get("number").equal(employeeBuilder.all(subQuery));
        query.setSelectionCriteria(selectionCriteria);
        query.setReferenceClass(Employee.class);
        if (JUnitJPQLSimpleTestSuite.usesSOP() && JUnitJPQLSimpleTestSuite.getServerSession().getPlatform().isOracle()) {
            query.dontUseDistinct();
        }
        Vector expectedResult = (Vector)JUnitJPQLSimpleTestSuite.getServerSession().executeQuery((DatabaseQuery)query);
        this.clearCache();
        String ejbqlString = "Select Distinct Object(emp) from Employee emp, IN(emp.phoneNumbers) p WHERE ";
        ejbqlString = ejbqlString + "p.number = ALL (Select MIN(pp.number) FROM PhoneNumber pp)";
        Query jpqlQuery = em.createQuery(ejbqlString);
        jpqlQuery.setMaxResults(10);
        if (JUnitJPQLSimpleTestSuite.usesSOP() && JUnitJPQLSimpleTestSuite.getServerSession().getPlatform().isOracle()) {
            jpqlQuery.setHint("eclipselink.serialized-object", (Object)"false");
        }
        List result = jpqlQuery.getResultList();
        Assert.assertTrue((String)"Simple select Phonenumber Declared In IN Clause test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
    }

    public void selectSimpleMemberOfWithParameterTest() {
        EntityManager em = this.createEntityManager();
        Employee expectedResult = (Employee)JUnitJPQLSimpleTestSuite.getServerSession().readObject(Employee.class);
        PhoneNumber phone = new PhoneNumber();
        phone.setAreaCode("613");
        phone.setNumber("1234567");
        phone.setType("cell");
        ServerSession serverSession = JUnitTestCase.getServerSession();
        ClientSession clientSession = serverSession.acquireClientSession();
        UnitOfWork uow = clientSession.acquireUnitOfWork();
        PhoneNumber phoneClone = (PhoneNumber)uow.registerObject((Object)phone);
        Employee empClone = (Employee)uow.registerObject((Object)expectedResult);
        phoneClone.setOwner(empClone);
        empClone.addPhoneNumber(phoneClone);
        uow.registerObject((Object)phone);
        uow.commit();
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE ?1 MEMBER OF emp.phoneNumbers";
        Vector<PhoneNumber> parameters = new Vector<PhoneNumber>();
        parameters.add(phone);
        List result = em.createQuery(ejbqlString).setParameter(1, (Object)phone).getResultList();
        uow = clientSession.acquireUnitOfWork();
        uow.deleteObject((Object)phone);
        uow.commit();
        Assert.assertTrue((String)"Select simple member of with parameter test failed", (boolean)comparer.compareObjects((Object)result, expectedResult));
    }

    public void selectSimpleNotMemberOfWithParameterTest() {
        PhoneNumber phone;
        EntityManager em = this.createEntityManager();
        Vector expectedResult = JUnitJPQLSimpleTestSuite.getServerSession().readAllObjects(Employee.class);
        this.clearCache();
        Employee emp = (Employee)expectedResult.get(0);
        expectedResult.remove(0);
        boolean shouldCleanUp = false;
        if (emp.getPhoneNumbers().isEmpty()) {
            phone = new PhoneNumber();
            phone.setAreaCode("613");
            phone.setNumber("1234567");
            phone.setType("cell");
            ServerSession serverSession = JUnitTestCase.getServerSession();
            ClientSession clientSession = serverSession.acquireClientSession();
            UnitOfWork uow = clientSession.acquireUnitOfWork();
            emp = (Employee)uow.readObject((Object)emp);
            PhoneNumber phoneClone = (PhoneNumber)uow.registerObject((Object)phone);
            emp.addPhoneNumber(phoneClone);
            if (JUnitJPQLSimpleTestSuite.usesSOP()) {
                phoneClone.setId(emp.getId());
            }
            uow.commit();
            phone = (PhoneNumber)emp.getPhoneNumbers().iterator().next();
            shouldCleanUp = true;
        } else {
            phone = (PhoneNumber)emp.getPhoneNumbers().iterator().next();
        }
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE ?1 NOT MEMBER OF emp.phoneNumbers";
        Vector<PhoneNumber> parameters = new Vector<PhoneNumber>();
        parameters.add(phone);
        List result = em.createQuery(ejbqlString).setParameter(1, (Object)phone).getResultList();
        boolean ok = comparer.compareObjects(result, (Collection)expectedResult);
        if (shouldCleanUp) {
            ServerSession serverSession = JUnitTestCase.getServerSession();
            ClientSession clientSession = serverSession.acquireClientSession();
            UnitOfWork uow = clientSession.acquireUnitOfWork();
            emp = (Employee)uow.readObject((Object)emp);
            PhoneNumber phoneToRemove = (PhoneNumber)emp.getPhoneNumbers().iterator().next();
            emp.removePhoneNumber(phoneToRemove);
            uow.deleteObject((Object)phoneToRemove);
            uow.commit();
        }
        if (!ok) {
            JUnitJPQLSimpleTestSuite.fail((String)"unexpected query result");
        }
    }

    public void selectSimpleNotMemberOfWithParameterNestedTest() {
        String all;
        EntityManager em = this.createEntityManager();
        List allProjectsWithTeamLeader = em.createQuery(all = "SELECT p FROM Project p WHERE p.teamLeader IS NOT NULL").getResultList();
        Assert.assertTrue((String)"No projects with team leaders.", (!allProjectsWithTeamLeader.isEmpty() ? 1 : 0) != 0);
        PhoneNumber phone = null;
        for (Project project : allProjectsWithTeamLeader) {
            if (project.getTeamLeader().getPhoneNumbers().size() <= 0) continue;
            phone = (PhoneNumber)project.getTeamLeader().getPhoneNumbers().iterator().next();
            break;
        }
        Assert.assertTrue((String)"Not a single teamLeader has a phone!", (phone != null ? 1 : 0) != 0);
        String ejbqlString1 = "SELECT p FROM Project p WHERE p.teamLeader IS NOT NULL AND ?1 MEMBER OF p.teamLeader.phoneNumbers";
        List result1 = em.createQuery(ejbqlString1).setParameter("1", phone).getResultList();
        Assert.assertTrue((String)"MEMBER OF result is empty", (!result1.isEmpty() ? 1 : 0) != 0);
        String ejbqlString2 = "SELECT p FROM Project p WHERE p.teamLeader IS NOT NULL AND ?1 NOT MEMBER OF p.teamLeader.phoneNumbers";
        List result2 = em.createQuery(ejbqlString2).setParameter("1", (Object)phone).getResultList();
        Assert.assertTrue((String)"NOT MEMBER OF result is empty", (!result2.isEmpty() ? 1 : 0) != 0);
        ArrayList union = new ArrayList(result1);
        union.addAll(result2);
        Assert.assertTrue((String)"Union of results of MEMBER OF and NON MEMBER OF not equal to all projects with team leaders", (boolean)comparer.compareObjects(union, (Collection)allProjectsWithTeamLeader));
        for (int i = 0; i < result2.size(); ++i) {
            if (!result1.contains(result2.get(i))) continue;
            JUnitJPQLSimpleTestSuite.fail((String)"results of MEMBER OF and NON MEMBER OF intersect");
        }
    }

    public void selectDirectCollectionNotMemberTest() {
        EntityManager em = this.createEntityManager();
        Vector allEmps = JUnitJPQLSimpleTestSuite.getServerSession().readAllObjects(Employee.class);
        String ejbqlString1 = "SELECT e FROM Employee e WHERE 'Clean the kitchen.' MEMBER OF e.responsibilities";
        List result1 = em.createQuery(ejbqlString1).getResultList();
        Assert.assertTrue((String)"MEMBER OF result is empty", (!result1.isEmpty() ? 1 : 0) != 0);
        String ejbqlString2 = "SELECT e FROM Employee e WHERE 'Clean the kitchen.' NOT MEMBER OF e.responsibilities";
        List result2 = em.createQuery(ejbqlString2).getResultList();
        Assert.assertTrue((String)"NOT MEMBER OF result is empty", (!result2.isEmpty() ? 1 : 0) != 0);
        ArrayList union = new ArrayList(result1);
        union.addAll(result2);
        Assert.assertTrue((String)"Union of results of MEMBER OF and NOT MEMBER OF not equal to all employees", (boolean)comparer.compareObjects(union, (Collection)allEmps));
        for (int i = 0; i < result2.size(); ++i) {
            if (!result1.contains(result2.get(i))) continue;
            JUnitJPQLSimpleTestSuite.fail((String)"results of MEMBER OF and NOT MEMBER OF intersect");
        }
    }

    public void selectDirectCollectionNonMemberNestedTest() {
        String all;
        EntityManager em = this.createEntityManager();
        List allProjectsWithTeamLeader = em.createQuery(all = "SELECT p FROM Project p WHERE p.teamLeader IS NOT NULL").getResultList();
        Assert.assertTrue((String)"No projects with team leaders.", (!allProjectsWithTeamLeader.isEmpty() ? 1 : 0) != 0);
        String responsibility = null;
        for (Project project : allProjectsWithTeamLeader) {
            if (project.getTeamLeader().getResponsibilities().size() <= 0) continue;
            responsibility = (String)project.getTeamLeader().getResponsibilities().iterator().next();
            break;
        }
        Assert.assertTrue((String)"Not a single teamLeader has any responsibilities!", (responsibility != null ? 1 : 0) != 0);
        String ejbqlString1 = "SELECT p FROM Project p WHERE p.teamLeader IS NOT NULL AND ?1 MEMBER OF p.teamLeader.responsibilities";
        List result1 = em.createQuery(ejbqlString1).setParameter("1", responsibility).getResultList();
        Assert.assertTrue((String)"MEMBER OF result is empty", (!result1.isEmpty() ? 1 : 0) != 0);
        String ejbqlString2 = "SELECT p FROM Project p WHERE p.teamLeader IS NOT NULL AND ?1 NOT MEMBER OF p.teamLeader.responsibilities";
        List result2 = em.createQuery(ejbqlString2).setParameter("1", (Object)responsibility).getResultList();
        Assert.assertTrue((String)"NOT MEMBER OF result is empty", (!result2.isEmpty() ? 1 : 0) != 0);
        ArrayList union = new ArrayList(result1);
        union.addAll(result2);
        Assert.assertTrue((String)"Union of results of MEMBER OF and NON MEMBER OF not equal to all projects with team leaders", (boolean)comparer.compareObjects(union, (Collection)allProjectsWithTeamLeader));
        for (int i = 0; i < result2.size(); ++i) {
            if (!result1.contains(result2.get(i))) continue;
            JUnitJPQLSimpleTestSuite.fail((String)"results of MEMBER OF and NON MEMBER OF intersect");
        }
    }

    public void selectUsingLockModeQueryHintTest() {
        Exception exception = null;
        EntityManager em = this.createEntityManager();
        Vector employees = JUnitJPQLSimpleTestSuite.getServerSession().readAllObjects(Employee.class);
        Employee emp1 = (Employee)employees.lastElement();
        Employee emp2 = new Employee();
        try {
            Query query = em.createNamedQuery("findEmployeeByPK");
            query.setParameter("id", (Object)emp1.getId());
            query.setHint("lockMode", (Object)new Short(1));
            emp2 = (Employee)query.getSingleResult();
        }
        catch (Exception e) {
            exception = e;
        }
        Assert.assertNull((String)("An exception was caught: " + exception), (Object)exception);
        Assert.assertTrue((String)"The query did not return the same employee.", (emp1.getId() == emp2.getId() ? 1 : 0) != 0);
    }

    public void selectSimpleBetweenWithParameterTest() {
        EntityManager em = this.createEntityManager();
        Vector employees = JUnitJPQLSimpleTestSuite.getServerSession().readAllObjects(Employee.class);
        BigDecimal empId1 = new BigDecimal(0);
        Employee emp2 = (Employee)employees.lastElement();
        ReadAllQuery raq = new ReadAllQuery();
        raq.setReferenceClass(Employee.class);
        ExpressionBuilder eb = new ExpressionBuilder();
        Expression whereClause = eb.get("id").between((Object)empId1, (Object)emp2.getId());
        raq.setSelectionCriteria(whereClause);
        Vector expectedResult = (Vector)JUnitJPQLSimpleTestSuite.getServerSession().executeQuery((DatabaseQuery)raq);
        this.clearCache();
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE ";
        ejbqlString = ejbqlString + "emp.id BETWEEN ?1 AND ?2";
        List result = em.createQuery(ejbqlString).setParameter(1, (Object)empId1).setParameter(2, (Object)emp2.getId()).getResultList();
        Assert.assertTrue((String)"Simple select between with parameter test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
    }

    public void selectSimpleInWithParameterTest() {
        EntityManager em = this.createEntityManager();
        Vector employees = JUnitJPQLSimpleTestSuite.getServerSession().readAllObjects(Employee.class);
        BigDecimal empId1 = new BigDecimal(0);
        Employee emp2 = (Employee)employees.lastElement();
        ReadAllQuery raq = new ReadAllQuery();
        raq.setReferenceClass(Employee.class);
        ExpressionBuilder eb = new ExpressionBuilder();
        Vector<Number> vec = new Vector<Number>();
        vec.add(empId1);
        vec.add(emp2.getId());
        Expression whereClause = eb.get("id").in(vec);
        raq.setSelectionCriteria(whereClause);
        Vector expectedResult = (Vector)JUnitJPQLSimpleTestSuite.getServerSession().executeQuery((DatabaseQuery)raq);
        this.clearCache();
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE ";
        ejbqlString = ejbqlString + "emp.id IN (?1, ?2)";
        List result = em.createQuery(ejbqlString).setParameter(1, (Object)empId1).setParameter(2, (Object)emp2.getId()).getResultList();
        Assert.assertTrue((String)"Simple select between with parameter test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
    }

    public void simpleEnumTest() {
        EntityManager em = this.createEntityManager();
        String ejbqlString = "SELECT emp FROM Employee emp WHERE ";
        ejbqlString = ejbqlString + "emp.status =  org.eclipse.persistence.testing.models.jpa.advanced.Employee.EmployeeStatus.FULL_TIME";
        List result = em.createQuery(ejbqlString).getResultList();
        result.size();
    }

    public void simpleTypeTest() {
        EntityManager em = this.createEntityManager();
        Vector expectedResult = JUnitJPQLSimpleTestSuite.getServerSession().readAllObjects(LargeProject.class);
        this.clearCache();
        String ejbqlString = "SELECT OBJECT(proj) FROM Project proj WHERE TYPE(proj) = LargeProject";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"SimpleTypeTest", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
    }

    public void simpleAsOrderByTest() {
        EntityManager em = this.createEntityManager();
        ReportQuery query = new ReportQuery();
        query.setReferenceClass(Employee.class);
        query.addItem("firstName", query.getExpressionBuilder().get("firstName"));
        query.returnSingleAttribute();
        query.dontRetrievePrimaryKeys();
        query.addOrdering(query.getExpressionBuilder().get("firstName").ascending());
        Vector expectedResult = (Vector)JUnitJPQLSimpleTestSuite.getServerSession().executeQuery((DatabaseQuery)query);
        this.clearCache();
        String ejbqlString = "SELECT e.firstName as firstName FROM Employee e ORDER BY firstName";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"SimpleTypeTest", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
    }

    public void simpleLiteralDateTest() {
        EntityManager em = this.createEntityManager();
        Date date = Date.valueOf("1901-01-01");
        Expression exp = new ExpressionBuilder().get("period").get("startDate").greaterThan((Object)date);
        Vector expectedResult = JUnitJPQLSimpleTestSuite.getServerSession().readAllObjects(Employee.class, exp);
        this.clearCache();
        String ejbqlString = "SELECT e FROM Employee e where e.period.startDate > {d '1901-01-01'}";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"simpleLiteralDateTest", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
    }

    private void simpleLiteralLongTest(String numericalLiteral) {
        EntityManager em = this.createEntityManager();
        Query query = em.createQuery("SELECT e FROM Employee e WHERE e.salary = 500000" + numericalLiteral);
        List results = query.getResultList();
        JUnitJPQLSimpleTestSuite.assertFalse((boolean)results.isEmpty());
        for (Employee employee : results) {
            JUnitJPQLSimpleTestSuite.assertEquals((int)500000, (int)employee.getSalary());
        }
    }

    public void simpleLiteralLongTest_Long1() {
        this.simpleLiteralLongTest("l");
    }

    public void simpleLiteralLongTest_Long2() {
        this.simpleLiteralLongTest("L");
    }

    public void simpleLiteralLongTest_Float1() {
        this.simpleLiteralLongTest("f");
    }

    public void simpleLiteralLongTest_Float2() {
        this.simpleLiteralLongTest("F");
    }

    public void simpleLiteralLongTest_Double1() {
        this.simpleLiteralLongTest("d");
    }

    public void simpleLiteralLongTest_Double2() {
        this.simpleLiteralLongTest("D");
    }

    public void simpleSingleArgSubstringTest() {
        EntityManager em = this.createEntityManager();
        Expression exp = new ExpressionBuilder().get("firstName").equal((Object)"Bob");
        Vector expectedResult = JUnitJPQLSimpleTestSuite.getServerSession().readAllObjects(Employee.class, exp);
        expectedResult.size();
        this.clearCache();
        String ejbqlString = "SELECT e FROM Employee e where substring(e.firstName, 2) = 'ob'";
        List result = em.createQuery(ejbqlString).getResultList();
        Assert.assertTrue((String)"simpleSingleArgSubstringTest", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
    }

    public void elementCollectionIsNotEmptyTest() {
        EntityManager em = this.createEntityManager();
        Query query = em.createQuery("SELECT e FROM Employee e WHERE e.responsibilities IS NOT EMPTY");
        List results = query.getResultList();
        for (Employee emp : results) {
            JUnitJPQLSimpleTestSuite.assertTrue((emp.getResponsibilities() != null && !emp.getResponsibilities().isEmpty() ? 1 : 0) != 0);
        }
    }

    public void relationshipElementCollectionIsNotEmptyTest() {
        EntityManager em = this.createEntityManager();
        Query query = em.createQuery("SELECT distinct o FROM PhoneNumber p join p.owner o WHERE o.responsibilities IS NOT EMPTY");
        List results = query.getResultList();
        for (Employee emp : results) {
            JUnitJPQLSimpleTestSuite.assertTrue((emp.getResponsibilities() != null && !emp.getResponsibilities().isEmpty() ? 1 : 0) != 0);
        }
    }

    public void enumWithToStringTest() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Employee emp = new Employee();
        emp.setFirstName("Nick");
        emp.setPayScale(Employee.SalaryRate.SENIOR);
        em.persist((Object)emp);
        em.flush();
        em.clear();
        this.clearCache();
        Query query = em.createQuery("SELECT e from Employee e where e.payScale = org.eclipse.persistence.testing.models.jpa.advanced.Employee.SalaryRate.SENIOR");
        emp = (Employee)query.getSingleResult();
        JUnitJPQLSimpleTestSuite.assertTrue((String)"Enumeration not properly returned", (emp.getPayScale() == Employee.SalaryRate.SENIOR ? 1 : 0) != 0);
        this.rollbackTransaction(em);
    }

    public void selectFromClauseWithFullyQualifiedClassName() {
        EntityManager em = this.createEntityManager();
        Query query = em.createQuery("SELECT e FROM org.eclipse.persistence.testing.models.jpa.advanced.Employee e, org.eclipse.persistence.testing.models.jpa.advanced.Address a WHERE e.lastName = 'JPQL'");
        query.getResultList();
    }

    public void selectFromClauseWithTableName() {
        EntityManager em = this.createEntityManager();
        Query query = em.createQuery("select e from Employee e, table('CMP3_EMPLOYEE') EMP where e.lastName = EMP.L_NAME and EMP.EMP_ID = 100");
        query.getResultList();
    }

    public void selectFromClauseWithJoin() {
        EntityManager em = this.createEntityManager();
        Query query = em.createQuery("SELECT Object(c) from Employee c JOIN FETCH c.address ");
        query.getResultList();
    }

    public void testMultipleSubqueries() {
        block2: {
            EntityManager em = this.createEntityManager();
            try {
                Query query = em.createQuery(this.multipleSubqueries());
            }
            catch (Exception e) {
                if (!(e instanceof JPQLException)) break block2;
                throw (JPQLException)e;
            }
        }
    }

    private String multipleSubqueries() {
        return "select e_0 from Employee e_0 where e_0.hugeProject IN (select e_1.projects                           from PhoneNumber e_1                           where e_1.owner IN (select e_2.employees                                               from Address e_2 JOIN e_2.employees e                                              where e.department IN (select e_3.department                                                                      from Employee e_3                                                                      where lower(e_3.m_lastName) like :e_3_iStandid                                                                    )                                             )                         )";
    }

    public void testDirectCollectionComparison() {
        EntityManager em = this.createEntityManager();
        Query query = em.createQuery("select b from Buyer as b,      Employee as e join b.creditLines as logicalName where logicalName = e.firstName");
        query.getResultList();
    }

    public void simpleQueryWithFirstUnusedEntity() {
        EntityManager em = this.createEntityManager();
        Query query = em.createQuery("select b from Employee e, Buyer b");
        List resultList = query.getResultList();
        JUnitJPQLSimpleTestSuite.assertFalse((boolean)resultList.isEmpty());
        for (Object item : resultList) {
            JUnitJPQLSimpleTestSuite.assertTrue((boolean)(item instanceof Buyer));
        }
    }

    public void testSimpleGroupByOrderByClauses() {
        EntityManager em = this.createEntityManager();
        Query query = em.createQuery("select e.firstName from Employee e group  by e.firstName  order   by e.firstName");
        query.getResultList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOrderByWithParenthesesAsc() {
        EntityManager em = this.createEntityManager();
        try {
            Query query = em.createQuery("SELECT e FROM Employee e ORDER BY (e.lastName) ASC");
            List results = query.getResultList();
            JUnitJPQLSimpleTestSuite.assertFalse((boolean)results.isEmpty());
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOrderByWithParenthesesDesc() {
        EntityManager em = this.createEntityManager();
        try {
            Query query = em.createQuery("SELECT e FROM Employee e ORDER BY (e.lastName) DESC");
            List results = query.getResultList();
            JUnitJPQLSimpleTestSuite.assertFalse((boolean)results.isEmpty());
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOrderByWithParenthesesDefault() {
        EntityManager em = this.createEntityManager();
        try {
            Query query = em.createQuery("SELECT e FROM Employee e ORDER BY (e.lastName)");
            List results = query.getResultList();
            JUnitJPQLSimpleTestSuite.assertFalse((boolean)results.isEmpty());
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOrderByWithParenthesesCalculatedAsc() {
        EntityManager em = this.createEntityManager();
        try {
            Query query = em.createQuery("SELECT e FROM Employee e ORDER BY (e.salary - e.version) ASC");
            List results = query.getResultList();
            JUnitJPQLSimpleTestSuite.assertFalse((boolean)results.isEmpty());
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOrderByWithParenthesesCalculatedDesc() {
        EntityManager em = this.createEntityManager();
        try {
            Query query = em.createQuery("SELECT e FROM Employee e ORDER BY (e.salary - e.version) DESC");
            List results = query.getResultList();
            JUnitJPQLSimpleTestSuite.assertFalse((boolean)results.isEmpty());
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOrderByWithParenthesesCalculatedDefault() {
        EntityManager em = this.createEntityManager();
        try {
            Query query = em.createQuery("SELECT e FROM Employee e ORDER BY (e.salary - e.version)");
            List results = query.getResultList();
            JUnitJPQLSimpleTestSuite.assertFalse((boolean)results.isEmpty());
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOrderByWithParenthesesCalculatedAndNormalAsc() {
        EntityManager em = this.createEntityManager();
        try {
            Query query = em.createQuery("SELECT e FROM Employee e ORDER BY e.lastName ASC, (e.salary - e.version) ASC");
            List results = query.getResultList();
            JUnitJPQLSimpleTestSuite.assertFalse((boolean)results.isEmpty());
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOrderByWithParenthesesCalculatedAndNormalDesc() {
        EntityManager em = this.createEntityManager();
        try {
            Query query = em.createQuery("SELECT e FROM Employee e ORDER BY e.lastName DESC, (e.salary - e.version) DESC");
            List results = query.getResultList();
            JUnitJPQLSimpleTestSuite.assertFalse((boolean)results.isEmpty());
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOrderByWithParenthesesCalculatedAndNormalDefault() {
        EntityManager em = this.createEntityManager();
        try {
            Query query = em.createQuery("SELECT e FROM Employee e ORDER BY e.lastName, (e.salary - e.version)");
            List results = query.getResultList();
            JUnitJPQLSimpleTestSuite.assertFalse((boolean)results.isEmpty());
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOrderByWithParenthesesCalculatedAndNormalHybrid() {
        EntityManager em = this.createEntityManager();
        try {
            Query query = em.createQuery("SELECT e FROM Employee e ORDER BY e.lastName, (e.salary - e.version) DESC");
            List results = query.getResultList();
            JUnitJPQLSimpleTestSuite.assertFalse((boolean)results.isEmpty());
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOrderByWithParenthesesAllAttributes() {
        EntityManager em = this.createEntityManager();
        try {
            Query query = em.createQuery("SELECT e FROM Employee e ORDER BY (e.lastName), (e.firstName), (e.salary)");
            List results = query.getResultList();
            JUnitJPQLSimpleTestSuite.assertFalse((boolean)results.isEmpty());
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOrderByWithParenthesesAllAttributesHybrid() {
        EntityManager em = this.createEntityManager();
        try {
            Query query = em.createQuery("SELECT e FROM Employee e ORDER BY (e.lastName) ASC, (e.firstName), (e.salary) DESC");
            List results = query.getResultList();
            JUnitJPQLSimpleTestSuite.assertFalse((boolean)results.isEmpty());
        }
        finally {
            this.closeEntityManager(em);
        }
    }
}

