/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.sessions.SessionEvent;
import org.eclipse.persistence.sessions.SessionEventAdapter;
import org.eclipse.persistence.sessions.SessionEventListener;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class PessimisticLockEmptyTransactionTest
extends AutoVerifyTestCase {
    protected UnitOfWork uow = null;
    protected SessionEventAdapter eventAdapter = new SessionEventAdapter(){

        public void postCommitUnitOfWork(SessionEvent event) {
            if (((AbstractSession)event.getSession()).isInTransaction()) {
                PessimisticLockEmptyTransactionTest.this.stillInTransaction();
            }
        }
    };
    protected boolean stillInTransaction = false;

    public PessimisticLockEmptyTransactionTest() {
        this.setDescription("Test to ensure that transactions using Pessimistic Locking which do not  make modifications properly close their transactions.");
    }

    public void stillInTransaction() {
        this.stillInTransaction = true;
    }

    public void setup() {
        this.checkSelectForUpateSupported();
        if (this.getSession().getPlatform().isHANA()) {
            throw new TestWarningException("This database does not support FOR UPDATE on multiple tables");
        }
        this.getSession().getEventManager().addListener((SessionEventListener)this.eventAdapter);
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.stillInTransaction = false;
    }

    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Employee employeeObject = (Employee)uow.readObject(Employee.class);
        uow.refreshAndLockObject((Object)employeeObject);
        uow.commit();
    }

    public void verify() {
        if (this.stillInTransaction) {
            throw new TestErrorException("Unit of Work Commit did not close the transaction for empty transaction using Pessimistic Locking.");
        }
    }

    public void reset() {
        this.getSession().getEventManager().removeListener((SessionEventListener)this.eventAdapter);
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        if (this.getAbstractSession().isInTransaction()) {
            this.rollbackTransaction();
        }
    }
}

