/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.dynamic;

import junit.framework.Assert;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Project;

public class DynamicTestingHelper {
    public static final String DEFAULT_LOG_LEVEL = "OFF";
    public static String username = null;
    public static String password = null;
    public static String url = null;
    public static String driver = null;
    public static String platform = null;
    public static int logLevel = 8;

    public static DatabaseSession createEmptySession() {
        Project project = new Project(new DatabaseLogin());
        return project.createDatabaseSession();
    }

    public static DatabaseLogin createLogin() {
        DatabaseLogin login = new DatabaseLogin();
        login.setUserName(username);
        login.setPassword(password);
        login.setConnectionString(url);
        login.setDriverClassName(driver);
        login.setPlatformClassName(platform);
        return login;
    }

    public static DatabaseSession createSession() {
        if (username == null) {
            Assert.fail((String)"error retrieving database username");
        }
        if (password == null) {
            Assert.fail((String)"error retrieving database password");
        }
        if (url == null) {
            Assert.fail((String)"error retrieving database url");
        }
        Project project = new Project(DynamicTestingHelper.createLogin());
        DatabaseSession session = project.createDatabaseSession();
        if (8 == logLevel) {
            session.dontLogMessages();
        } else {
            session.setLogLevel(logLevel);
        }
        return session;
    }

    static {
        username = System.getProperty("db.user");
        password = System.getProperty("db.pwd");
        url = System.getProperty("db.url");
        driver = System.getProperty("db.driver");
        platform = System.getProperty("db.platform");
        logLevel = AbstractSessionLog.translateStringToLoggingLevel((String)System.getProperty("eclipselink.logging.level", DEFAULT_LOG_LEVEL));
    }
}

