/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.iterators;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.ArrayIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.SingleElementIterator;

public class CompositeIterator
implements Iterator {
    private final Iterator iterators;
    private Iterator currentIterator;
    private Iterator lastIteratorToReturnNext;

    public CompositeIterator(Collection iterators) {
        this(iterators.iterator());
    }

    public CompositeIterator(Iterator iterators) {
        this.iterators = iterators;
    }

    public CompositeIterator(Object object, Iterator iterator) {
        this((Iterator)new SingleElementIterator(object), iterator);
    }

    public CompositeIterator(Iterator iterator, Object object) {
        this(iterator, (Iterator)new SingleElementIterator(object));
    }

    public CompositeIterator(Iterator iterator1, Iterator iterator2) {
        this(new ArrayIterator(new Object[]{iterator1, iterator2}));
    }

    public CompositeIterator(Iterator iterator1, Iterator iterator2, Iterator iterator3) {
        this(new ArrayIterator(new Object[]{iterator1, iterator2, iterator3}));
    }

    public CompositeIterator(Iterator[] iterators) {
        this(new ArrayIterator(iterators));
    }

    @Override
    public boolean hasNext() {
        try {
            this.loadCurrentIterator();
        }
        catch (NoSuchElementException ex) {
            return false;
        }
        return this.currentIterator.hasNext();
    }

    public Object next() {
        this.loadCurrentIterator();
        Object result = this.currentIterator.next();
        this.lastIteratorToReturnNext = this.currentIterator;
        return result;
    }

    @Override
    public void remove() {
        if (this.lastIteratorToReturnNext == null) {
            throw new IllegalStateException();
        }
        this.lastIteratorToReturnNext.remove();
    }

    private void loadCurrentIterator() {
        if (this.currentIterator == null) {
            this.currentIterator = (Iterator)this.iterators.next();
        }
        while (!this.currentIterator.hasNext() && this.iterators.hasNext()) {
            this.currentIterator = (Iterator)this.iterators.next();
        }
    }

    public String toString() {
        return ClassTools.shortClassNameForObject(this) + '(' + this.iterators + ')';
    }
}

