/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.mapping;

import java.util.List;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWConverter;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWConverterMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWDefaultNullValuePolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWNullConverter;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWNullNullValuePolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWNullValuePolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWObjectTypeConverter;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWSerializedObjectConverter;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWTypeConversionConverter;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassAttribute;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public abstract class MWDirectMapping
extends MWMapping
implements MWConverterMapping {
    private volatile MWNullValuePolicy nullValuePolicy;
    public static final String USES_NULL_VALUE_PROPERTY = "usesNullValue";
    private volatile MWConverter converter;

    protected MWDirectMapping() {
    }

    protected MWDirectMapping(MWMappingDescriptor parent, MWClassAttribute attribute, String name) {
        super(parent, attribute, name);
    }

    @Override
    protected void initialize(Node parent) {
        super.initialize(parent);
        this.nullValuePolicy = new MWNullNullValuePolicy(this);
        this.converter = new MWNullConverter(this);
    }

    @Override
    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        children.add(this.converter);
        children.add(this.nullValuePolicy);
    }

    public MWNullValuePolicy getNullValuePolicy() {
        return this.nullValuePolicy;
    }

    public boolean usesNullValue() {
        return this.nullValuePolicy.usesNullValue();
    }

    public void setUseNullValue(boolean useNullValue) {
        boolean oldValue = this.usesNullValue();
        if (oldValue == useNullValue) {
            return;
        }
        this.nullValuePolicy = useNullValue ? new MWDefaultNullValuePolicy(this) : new MWNullNullValuePolicy(this);
        this.firePropertyChanged(USES_NULL_VALUE_PROPERTY, oldValue, useNullValue);
    }

    @Override
    public MWConverter getConverter() {
        return this.converter;
    }

    @Override
    public MWNullConverter setNullConverter() {
        MWNullConverter nullConverter = new MWNullConverter(this);
        this.setConverter(nullConverter);
        return nullConverter;
    }

    @Override
    public MWObjectTypeConverter setObjectTypeConverter() {
        MWObjectTypeConverter objectTypeConverter = new MWObjectTypeConverter(this);
        this.setConverter(objectTypeConverter);
        return objectTypeConverter;
    }

    @Override
    public MWSerializedObjectConverter setSerializedObjectConverter() {
        MWSerializedObjectConverter serializedObjectConverter = new MWSerializedObjectConverter(this);
        this.setConverter(serializedObjectConverter);
        return serializedObjectConverter;
    }

    @Override
    public MWTypeConversionConverter setTypeConversionConverter() {
        MWTypeConversionConverter typeConversionConverter = this.buildTypeConversionConverter();
        this.setConverter(typeConversionConverter);
        return typeConversionConverter;
    }

    protected abstract MWTypeConversionConverter buildTypeConversionConverter();

    private void setConverter(MWConverter newConverter) {
        MWConverter oldConverter = this.converter;
        this.converter = newConverter;
        newConverter.setParent(this);
        this.firePropertyChanged("converter", oldConverter, newConverter);
    }

    @Override
    protected void initializeFromMWDirectMapping(MWDirectMapping oldMapping) {
        super.initializeFromMWDirectMapping(oldMapping);
        this.setUseNullValue(oldMapping.usesNullValue());
        if (this.usesNullValue()) {
            this.getNullValuePolicy().setNullValue(oldMapping.getNullValuePolicy().getNullValue());
            this.getNullValuePolicy().setNullValueType(oldMapping.getNullValuePolicy().getNullValueType());
        }
    }

    @Override
    protected void initializeFromMWConverterMapping(MWConverterMapping converterMapping) {
        super.initializeFromMWConverterMapping(converterMapping);
        this.setConverter(converterMapping.getConverter());
    }

    @Override
    public DatabaseMapping runtimeMapping() {
        AbstractDirectMapping mapping = (AbstractDirectMapping)super.runtimeMapping();
        this.nullValuePolicy.adjustRuntimeMapping(mapping);
        mapping.setConverter(this.getConverter().runtimeConverter((DatabaseMapping)mapping));
        return mapping;
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWDirectMapping.class);
        descriptor.getInheritancePolicy().setParentClass(MWMapping.class);
        XMLCompositeObjectMapping nullValuePolicyMapping = new XMLCompositeObjectMapping();
        nullValuePolicyMapping.setReferenceClass(MWDefaultNullValuePolicy.class);
        nullValuePolicyMapping.setAttributeName("nullValuePolicy");
        nullValuePolicyMapping.setGetMethodName("getNullValuePolicyForTopLink");
        nullValuePolicyMapping.setSetMethodName("setNullValuePolicyForTopLink");
        nullValuePolicyMapping.setXPath("null-value-policy");
        descriptor.addMapping((DatabaseMapping)nullValuePolicyMapping);
        XMLCompositeObjectMapping converterMapping = new XMLCompositeObjectMapping();
        converterMapping.setReferenceClass(MWConverter.class);
        converterMapping.setAttributeName("converter");
        converterMapping.setGetMethodName("getConverterForTopLink");
        converterMapping.setSetMethodName("setConverterForTopLink");
        converterMapping.setXPath("converter");
        descriptor.addMapping((DatabaseMapping)converterMapping);
        return descriptor;
    }

    private MWNullValuePolicy getNullValuePolicyForTopLink() {
        return this.nullValuePolicy == null ? null : this.nullValuePolicy.getValueForTopLink();
    }

    private void setNullValuePolicyForTopLink(MWNullValuePolicy nullValuePolicy) {
        this.nullValuePolicy = nullValuePolicy == null ? new MWNullNullValuePolicy(this) : nullValuePolicy;
    }

    private MWConverter getConverterForTopLink() {
        return this.converter == null ? null : this.converter.getValueForTopLink();
    }

    private void setConverterForTopLink(MWConverter converter) {
        this.converter = converter == null ? new MWNullConverter(this) : converter;
    }
}

