/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.session.clustering;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JRadioButton;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.Document;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractSubjectPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.GroupBox;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.RMIRegistryNamingServiceAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.RMITransportManagerAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.ui.session.clustering.AbstractTransportManagerPane;
import org.eclipse.persistence.tools.workbench.scplugin.ui.session.clustering.JNDINamingServicePane;
import org.eclipse.persistence.tools.workbench.scplugin.ui.tools.IPAddressFormatter;
import org.eclipse.persistence.tools.workbench.uitools.ComponentEnabler;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.CheckBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.NumberSpinnerModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.RadioButtonModelAdapter;

final class RCMRMIPane
extends AbstractTransportManagerPane {
    RCMRMIPane(ValueModel subjectHolder, WorkbenchContextHolder contextHolder) {
        super(subjectHolder, contextHolder);
    }

    private PropertyValueModel buildAnnouncementDelayHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "announcementDelay"){

            @Override
            protected Object getValueFromSubject() {
                RMITransportManagerAdapter adapter = (RMITransportManagerAdapter)((Object)this.subject);
                return new Integer(adapter.getAnnouncementDelay());
            }

            @Override
            protected void setValueOnSubject(Object value) {
                RMITransportManagerAdapter adapter = (RMITransportManagerAdapter)((Object)this.subject);
                adapter.setAnnouncementDelay((Integer)value);
            }
        };
    }

    private SpinnerNumberModel buildAnnouncementDelaySpinnerAdapter() {
        return new NumberSpinnerModelAdapter(this.buildAnnouncementDelayHolder(), 0, Integer.MAX_VALUE, 1);
    }

    private void buildJNDINamingComponentEnabler(PropertyValueModel subjectHolder, JComponent pane) {
        new ComponentEnabler((ValueModel)this.buildJNDINamingEnablerHolder(subjectHolder), pane.getComponents());
    }

    private PropertyValueModel buildJNDINamingEnablerHolder(PropertyValueModel subjectHolder) {
        return new TransformationPropertyValueModel(subjectHolder){

            @Override
            protected Object transform(Object value) {
                if (value == null) {
                    return null;
                }
                return "jndiNamingService".equals(value);
            }
        };
    }

    private PropertyValueModel buildJNDINamingServiceHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "jndiNamingService"){

            @Override
            protected Object getValueFromSubject() {
                RMITransportManagerAdapter rmi = (RMITransportManagerAdapter)((Object)this.subject);
                return rmi.getJNDINamingService();
            }
        };
    }

    private Document buildMulticastGroupAddressDocumentAdapter() {
        return new DocumentAdapter(this.buildMulticastGroupAddressHolder());
    }

    private PropertyValueModel buildMulticastGroupAddressHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "multicastGroupAddress"){

            @Override
            protected Object getValueFromSubject() {
                RMITransportManagerAdapter adapter = (RMITransportManagerAdapter)((Object)this.subject);
                return adapter.getMulticastGroupAddress();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                RMITransportManagerAdapter adapter = (RMITransportManagerAdapter)((Object)this.subject);
                adapter.setMulticastGroupAddress((String)value);
            }
        };
    }

    private PropertyValueModel buildMultiCastPortHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "multicastPort"){

            @Override
            protected Object getValueFromSubject() {
                RMITransportManagerAdapter adapter = (RMITransportManagerAdapter)((Object)this.subject);
                return new Integer(adapter.getMulticastPort());
            }

            @Override
            protected void setValueOnSubject(Object value) {
                RMITransportManagerAdapter adapter = (RMITransportManagerAdapter)((Object)this.subject);
                adapter.setMulticastPort((Integer)value);
            }
        };
    }

    private SpinnerNumberModel buildMultiCastPortSpinnerAdapter() {
        return new NumberSpinnerModelAdapter(this.buildMultiCastPortHolder(), 0, 32768, 1);
    }

    private PropertyValueModel buildPacketTimeToLiveHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "packetTimeToLive"){

            @Override
            protected Object getValueFromSubject() {
                RMITransportManagerAdapter adapter = (RMITransportManagerAdapter)((Object)this.subject);
                return new Integer(adapter.getPacketTimeToLive());
            }

            @Override
            protected void setValueOnSubject(Object value) {
                RMITransportManagerAdapter adapter = (RMITransportManagerAdapter)((Object)this.subject);
                adapter.setPacketTimeToLive((Integer)value);
            }
        };
    }

    private SpinnerNumberModel buildPacketTimeToLiveSpinnerAdapter() {
        return new NumberSpinnerModelAdapter(this.buildPacketTimeToLiveHolder(), 0, 32768, 1);
    }

    private PropertyValueModel buildNamingServiceTypeHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "namingServiceType"){

            @Override
            protected Object getValueFromSubject() {
                RMITransportManagerAdapter rmi = (RMITransportManagerAdapter)((Object)this.subject);
                return rmi.getNamingServiceType();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                RMITransportManagerAdapter rmi = (RMITransportManagerAdapter)((Object)this.subject);
                if (rmi.getNamingServiceType().equals(value)) {
                    return;
                }
                if ("jndiNamingService".equals(value)) {
                    rmi.setNamingServiceToJNDINamingService();
                } else if ("rmiRegistryNamingService".equals(value)) {
                    rmi.setNamingServiceToRMIRegistryNamingService();
                }
            }
        };
    }

    private void buildRMIRegistryNamingComponentEnabler(PropertyValueModel subjectHolder, JComponent pane) {
        new ComponentEnabler((ValueModel)this.buildRMIRegistryNamingEnablerHolder(subjectHolder), pane.getComponents());
    }

    private PropertyValueModel buildRMIRegistryNamingEnablerHolder(PropertyValueModel subjectHolder) {
        return new TransformationPropertyValueModel(subjectHolder){

            @Override
            protected Object transform(Object value) {
                if (value == null) {
                    return null;
                }
                return "rmiRegistryNamingService".equals(value);
            }
        };
    }

    private PropertyValueModel buildRMIRegistryNamingServiceHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "rmiRegistryNamingService"){

            @Override
            protected Object getValueFromSubject() {
                RMITransportManagerAdapter rmi = (RMITransportManagerAdapter)((Object)this.subject);
                return rmi.getRMIRegistryNamingService();
            }
        };
    }

    private ButtonModel buildSynchronousButtonModelAdapter() {
        return new CheckBoxModelAdapter(this.buildSynchronousHolder());
    }

    private PropertyAspectAdapter buildSynchronousHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "sendMode"){

            @Override
            protected Object getValueFromSubject() {
                RMITransportManagerAdapter transport = (RMITransportManagerAdapter)((Object)this.subject);
                return transport.isSynchronous();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                RMITransportManagerAdapter transport = (RMITransportManagerAdapter)((Object)this.subject);
                transport.setSynchronous(Boolean.TRUE.equals(value));
            }
        };
    }

    @Override
    protected void initializeLayout() {
        GridBagConstraints constraints = new GridBagConstraints();
        PropertyValueModel namingServiceHolder = this.buildNamingServiceTypeHolder();
        JFormattedTextField multicastGroupAddressField = new JFormattedTextField(new IPAddressFormatter());
        multicastGroupAddressField.setDocument(this.buildMulticastGroupAddressDocumentAdapter());
        multicastGroupAddressField.setName("RMI_MULTICAST_GROUP_ADDRESS_FIELD");
        multicastGroupAddressField.setColumns(9);
        JComponent multicastGroupAddressWidgets = this.buildLabeledComponent("RMI_MULTICAST_GROUP_ADDRESS_FIELD", multicastGroupAddressField);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)multicastGroupAddressWidgets, constraints);
        this.addHelpTopicId(multicastGroupAddressWidgets, "session.clustering.rcm.rmi.multicastGroupAddress");
        JComponent multicastPortWidgets = this.buildLabeledSpinnerNumber("RMI_MULTICAST_PORT_SPINNER", this.buildMultiCastPortSpinnerAdapter());
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)multicastPortWidgets, constraints);
        this.addHelpTopicId(multicastPortWidgets, "session.clustering.rcm.rmi.multicastPort");
        JComponent packetTimeToLiveWidgets = this.buildLabeledSpinnerNumber("RMI_PACKET_TIME_TO_LIVE_SPINNER", this.buildPacketTimeToLiveSpinnerAdapter());
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)packetTimeToLiveWidgets, constraints);
        this.addHelpTopicId(packetTimeToLiveWidgets, "session.clustering.rcm.rmi.packetTimeToLive");
        JComponent announcementDelayWidgets = this.buildLabeledSpinnerNumber("RMI_ANNOUNCEMENT_DELAY_SPINNER", this.buildAnnouncementDelaySpinnerAdapter());
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)announcementDelayWidgets, constraints);
        this.addHelpTopicId(announcementDelayWidgets, "session.clustering.rcm.rmi.announcementDelay");
        JCheckBox removeConnectionOnErrorCheckBox = this.buildRemoveConnectionOnError();
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)removeConnectionOnErrorCheckBox, constraints);
        JCheckBox synchronousCheckBox = this.buildCheckBox("RMI_SYNCHRONOUS_CHECK_BOX", this.buildSynchronousButtonModelAdapter());
        constraints.gridx = 0;
        constraints.gridy = 5;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)synchronousCheckBox, constraints);
        this.addHelpTopicId(synchronousCheckBox, "session.clustering.rcm.rmi.synchronous");
        JRadioButton rmiRegistryNamingServiceRadioButton = this.buildRadioButton("RMI_REGISTRY_NAMING_SERVICE_RADIO_BUTTON", new RadioButtonModelAdapter(namingServiceHolder, "rmiRegistryNamingService"));
        this.addHelpTopicId(rmiRegistryNamingServiceRadioButton, "session.clustering.rcm.rmi.rmiURL");
        RMIRegistryNamingServicePane registryNamingServicePane = new RMIRegistryNamingServicePane();
        this.addHelpTopicId(registryNamingServicePane, "session.clustering.rcm.rmi.rmiURL");
        this.buildRMIRegistryNamingComponentEnabler(namingServiceHolder, registryNamingServicePane);
        JRadioButton jndiNamingServiceRadioButton = this.buildRadioButton("RMI_JNDI_NAMING_SERVICE_RADIO_BUTTON", new RadioButtonModelAdapter(namingServiceHolder, "jndiNamingService"));
        this.addHelpTopicId(jndiNamingServiceRadioButton, "session.clustering.rcm.jndiNamingService");
        JNDINamingServicePane jndiNamingServicePane = new JNDINamingServicePane((ValueModel)this.buildJNDINamingServiceHolder(), this.getWorkbenchContextHolder());
        jndiNamingServicePane.setBorder(BorderFactory.createEmptyBorder());
        this.buildJNDINamingComponentEnabler(namingServiceHolder, jndiNamingServicePane);
        registryNamingServicePane.addPaneForAlignment(jndiNamingServicePane);
        GroupBox groupBox = new GroupBox((AbstractButton)rmiRegistryNamingServiceRadioButton, registryNamingServicePane, (AbstractButton)jndiNamingServiceRadioButton, (JComponent)jndiNamingServicePane);
        constraints.gridx = 0;
        constraints.gridy = 6;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)groupBox, constraints);
        this.addHelpTopicId(this, "session.clustering.rcm.rmi");
    }

    private class RMIRegistryNamingServicePane
    extends AbstractSubjectPanel {
        private RMIRegistryNamingServicePane() {
            super((ValueModel)RCMRMIPane.this.buildRMIRegistryNamingServiceHolder(), RCMRMIPane.this.getApplicationContext());
        }

        public void addPaneForAlignment(JNDINamingServicePane pane) {
            super.addPaneForAlignment(pane);
        }

        private Document buildRMIURLDocumentAdapter() {
            return new DocumentAdapter(this.buildRMIURLHolder());
        }

        private PropertyValueModel buildRMIURLHolder() {
            return new PropertyAspectAdapter(this.getSubjectHolder(), "urlConfig"){

                @Override
                protected Object getValueFromSubject() {
                    RMIRegistryNamingServiceAdapter rmi = (RMIRegistryNamingServiceAdapter)((Object)this.subject);
                    return rmi.getURL();
                }

                @Override
                protected void setValueOnSubject(Object value) {
                    RMIRegistryNamingServiceAdapter rmi = (RMIRegistryNamingServiceAdapter)((Object)this.subject);
                    rmi.setURL((String)value);
                }
            };
        }

        @Override
        protected void initializeLayout() {
            GridBagConstraints constraints = new GridBagConstraints();
            JComponent rmiURLWidgets = this.buildLabeledTextField("RMI_REGISTRY_NAMING_SERVICE_URL_FIELD", this.buildRMIURLDocumentAdapter());
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 1.0;
            constraints.weighty = 0.0;
            constraints.fill = 2;
            constraints.anchor = 10;
            constraints.insets = new Insets(0, 0, 0, 0);
            this.add((Component)rmiURLWidgets, constraints);
        }
    }
}

