/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.xml.login;

import java.awt.Component;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JPasswordField;
import javax.swing.text.Document;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractSubjectPanel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassRepository;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.xml.MWEisLoginSpec;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.xml.MWEisProject;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.meta.ClassRepositoryHolder;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.CheckBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;

abstract class AbstractLoginPane
extends AbstractSubjectPanel {
    protected AbstractLoginPane(PropertyValueModel subjectHolder, WorkbenchContextHolder contextHolder) {
        super((ValueModel)subjectHolder, contextHolder);
    }

    protected final ClassRepositoryHolder buildClassRepositoryHolder() {
        return new ClassRepositoryHolder(){

            @Override
            public MWClassRepository getClassRepository() {
                return ((MWEisProject)AbstractLoginPane.this.subject()).getClassRepository();
            }
        };
    }

    private Document buildPasswordDocumentAdapter() {
        return new DocumentAdapter(this.buildPasswordHolder());
    }

    private PropertyValueModel buildPasswordHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "password"){

            @Override
            protected Object getValueFromSubject() {
                MWEisLoginSpec loginSpec = ((MWEisProject)this.subject).getEisLoginSpec();
                return loginSpec.getPassword();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                MWEisLoginSpec loginSpec = ((MWEisProject)this.subject).getEisLoginSpec();
                loginSpec.setPassword((String)value);
            }
        };
    }

    protected Component buildPasswordWidgets() {
        JPasswordField passwordField = new JPasswordField(this.buildPasswordDocumentAdapter(), null, 1);
        return this.buildLabeledComponent("CONNECTION_PASSWORD_FIELD", passwordField);
    }

    protected JCheckBox buildSavePasswordCheckBox() {
        return this.buildCheckBox("SAVE_PASSWORD_CHECK_BOX", this.buildSavePasswordCheckBoxModelAdapter());
    }

    private ButtonModel buildSavePasswordCheckBoxModelAdapter() {
        return new CheckBoxModelAdapter(this.buildSavePasswordPropertyAdapter());
    }

    private PropertyValueModel buildSavePasswordPropertyAdapter() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "savePassword"){

            @Override
            protected Object getValueFromSubject() {
                MWEisLoginSpec loginSpec = ((MWEisProject)this.subject).getEisLoginSpec();
                return loginSpec.isSavePassword();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                MWEisLoginSpec loginSpec = ((MWEisProject)this.subject).getEisLoginSpec();
                loginSpec.setSavePassword(((Boolean)value).booleanValue());
            }
        };
    }

    private Document buildUsernameAdapter() {
        return new DocumentAdapter(this.buildUsernameHolder());
    }

    private PropertyValueModel buildUsernameHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "userName"){

            @Override
            protected Object getValueFromSubject() {
                MWEisLoginSpec loginSpec = ((MWEisProject)this.subject).getEisLoginSpec();
                return loginSpec.getUserName();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                MWEisLoginSpec loginSpec = ((MWEisProject)this.subject).getEisLoginSpec();
                loginSpec.setUserName((String)value);
            }
        };
    }

    protected Component buildUserNameWidgets() {
        return this.buildLabeledTextField("CONNECTION_USER_NAME_FIELD", this.buildUsernameAdapter());
    }

    @Override
    public final void setEnabled(boolean enabled) {
        if (this.isEnabled() == enabled) {
            return;
        }
        super.setEnabled(enabled);
        this.updateEnableStateOfChildren(enabled);
    }

    protected void updateEnableStateOfChildren(boolean enabled) {
        int index = this.getComponentCount();
        while (--index >= 0) {
            this.getComponent(index).setEnabled(enabled);
        }
    }
}

