/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.app;

import java.io.Serializable;
import javax.swing.Icon;
import org.eclipse.persistence.tools.workbench.framework.app.IconBuilder;
import org.eclipse.persistence.tools.workbench.uitools.swing.CompositeIcon;
import org.eclipse.persistence.tools.workbench.uitools.swing.EmptyIcon;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class CompositeIconBuilder
implements IconBuilder,
Cloneable,
Serializable {
    private IconBuilder original;
    private boolean combine;
    private Icon icon;
    private int gap;
    private int orientation;
    private int alignment;
    private String description;
    private Icon emptyIcon;
    private static final long serialVersionUID = 1L;

    public CompositeIconBuilder(IconBuilder original, boolean combine, Icon icon, int gap, int orientation, int alignment, String description) {
        if (original == null) {
            throw new NullPointerException();
        }
        this.original = original;
        this.combine = combine;
        this.icon = icon;
        this.gap = gap;
        this.orientation = orientation;
        this.alignment = alignment;
        this.description = description;
    }

    public CompositeIconBuilder(IconBuilder original, boolean combine, Icon icon) {
        this(original, combine, icon, 0, 0, 0, null);
    }

    @Override
    public Icon buildIcon() {
        Icon icon1 = this.original.buildIcon();
        Icon icon2 = this.combine ? this.icon : this.getEmptyIcon();
        return this.buildCompositeIcon(icon1, icon2);
    }

    protected Icon buildCompositeIcon(Icon icon1, Icon icon2) {
        CompositeIcon compositeIcon = new CompositeIcon(icon1, this.gap, icon2);
        compositeIcon.setOrientation(this.orientation);
        compositeIcon.setAlignment(this.alignment);
        compositeIcon.setDescription(this.description);
        return compositeIcon;
    }

    protected Icon getEmptyIcon() {
        if (this.emptyIcon == null) {
            this.emptyIcon = this.buildEmptyIcon();
        }
        return this.emptyIcon;
    }

    protected Icon buildEmptyIcon() {
        return new EmptyIcon(this.icon.getIconWidth(), this.icon.getIconHeight());
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof CompositeIconBuilder) {
            return this.equals((CompositeIconBuilder)o);
        }
        return false;
    }

    public boolean equals(CompositeIconBuilder other) {
        return this.original.equals(other.original) && this.combine == other.combine && (this.icon == null ? other.icon == null : this.icon.equals(other.icon)) && this.gap == other.gap && this.orientation == other.orientation && this.alignment == other.alignment && (this.description == null ? other.description == null : this.description.equals(other.description));
    }

    @Override
    public int hashCode() {
        return this.original.hashCode() ^ Boolean.valueOf(this.combine).hashCode() ^ (this.icon == null ? 0 : this.icon.hashCode()) ^ this.gap ^ this.orientation ^ this.alignment ^ (this.description == null ? 0 : this.description.hashCode());
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)this.original);
    }
}

