/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.collections.map;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.mappings.Association;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.queries.ReportQueryResult;
import org.eclipse.persistence.testing.models.collections.map.DirectEntity1MMapHolder;
import org.eclipse.persistence.testing.tests.queries.report.ReportQueryTestCase;

public class MapEntryDirectEntity1MReportQueryTest
extends ReportQueryTestCase {
    @Override
    protected void buildExpectedResults() {
        Vector holders = this.getSession().readAllObjects(DirectEntity1MMapHolder.class);
        Enumeration e = holders.elements();
        while (e.hasMoreElements()) {
            DirectEntity1MMapHolder holder = (DirectEntity1MMapHolder)e.nextElement();
            Iterator i = holder.getDirectToEntityMap().entrySet().iterator();
            while (i.hasNext()) {
                Object[] result = new Object[1];
                Map.Entry entry = i.next();
                result[0] = new Association(entry.getKey(), entry.getValue());
                this.addResult(result, null);
            }
        }
    }

    @Override
    protected void removeFromResult(ReportQueryResult result, Vector expected) {
        Enumeration e = expected.elements();
        while (e.hasMoreElements()) {
            ReportQueryResult expectedResult = (ReportQueryResult)e.nextElement();
            Association expectedAssocication = (Association)expectedResult.getByIndex(0);
            Association resultAssocication = (Association)result.getByIndex(0);
            if (!expectedAssocication.getKey().equals(resultAssocication.getKey()) || !expectedAssocication.getValue().equals(resultAssocication.getValue())) continue;
            expected.removeElement(expectedResult);
            return;
        }
        this.getSession().logMessage("missing element: " + result);
    }

    @Override
    protected void setup() throws Exception {
        super.setup();
        this.reportQuery = new ReportQuery(new ExpressionBuilder());
        this.reportQuery.setReferenceClass(DirectEntity1MMapHolder.class);
        this.reportQuery.addAttribute("entry", this.reportQuery.getExpressionBuilder().anyOf("directToEntityMap").mapEntry());
    }
}

