/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.transparentindirection;

import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.internal.identitymaps.FullIdentityMap;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectCollectionMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.ManyToManyMapping;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.testing.models.transparentindirection.Order;
import org.eclipse.persistence.testing.models.transparentindirection.OrderLine;
import org.eclipse.persistence.testing.models.transparentindirection.SalesRep;
import org.eclipse.persistence.testing.tests.transparentindirection.IndirectListTestDatabase;

public class GeneratedIndirectContainerProject
extends Project {
    public GeneratedIndirectContainerProject() {
        this.applyPROJECT();
        this.applyLOGIN();
        this.buildOrderDescriptor();
        this.buildOrderLineDescriptor();
        this.buildSalesRepDescriptor();
    }

    protected void applyLOGIN() {
    }

    protected void applyPROJECT() {
        this.setName("TransparentIndirection");
    }

    protected void buildOrderDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Order.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("ORD");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("ORD.ID");
        descriptor.setIdentityMapClass(FullIdentityMap.class);
        descriptor.setSequenceNumberName("order_seq");
        descriptor.setSequenceNumberFieldName("ID");
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        descriptor.createCopyPolicy("constructor");
        descriptor.createInstantiationPolicy("constructor");
        DirectCollectionMapping directcollectionmapping = new DirectCollectionMapping();
        directcollectionmapping.setAttributeName("contacts");
        directcollectionmapping.setIsReadOnly(false);
        directcollectionmapping.setUsesIndirection(false);
        directcollectionmapping.setIsPrivateOwned(true);
        directcollectionmapping.useCollectionClass(Vector.class);
        directcollectionmapping.setDirectFieldName("CONTACT.NAME");
        directcollectionmapping.setReferenceTableName("CONTACT");
        directcollectionmapping.addReferenceKeyFieldName("CONTACT.ORDER_ID", "ORD.ID");
        descriptor.addMapping((DatabaseMapping)directcollectionmapping);
        DirectToFieldMapping directtofieldmapping = new DirectToFieldMapping();
        directtofieldmapping.setAttributeName("customerName");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setFieldName("ORD.CUSTNAME");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping);
        DirectToFieldMapping directtofieldmapping1 = new DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("id");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setFieldName("ORD.ID");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping1);
        ManyToManyMapping manytomanymapping = new ManyToManyMapping();
        manytomanymapping.setAttributeName("salesReps");
        manytomanymapping.setIsReadOnly(false);
        manytomanymapping.setUsesIndirection(false);
        manytomanymapping.setReferenceClass(SalesRep.class);
        manytomanymapping.setIsPrivateOwned(false);
        manytomanymapping.useCollectionClass(Vector.class);
        manytomanymapping.setRelationTableName("ORDREP");
        manytomanymapping.addSourceRelationKeyFieldName("ORDREP.ORDER_ID", "ORD.ID");
        manytomanymapping.addTargetRelationKeyFieldName("ORDREP.SALEREP_ID", "SALEREP.ID");
        descriptor.addMapping((DatabaseMapping)manytomanymapping);
        OneToManyMapping onetomanymapping = new OneToManyMapping();
        onetomanymapping.setAttributeName("lines");
        onetomanymapping.setIsReadOnly(false);
        onetomanymapping.setUsesIndirection(false);
        onetomanymapping.setReferenceClass(OrderLine.class);
        onetomanymapping.setIsPrivateOwned(true);
        onetomanymapping.useCollectionClass(Vector.class);
        onetomanymapping.addTargetForeignKeyFieldName("ORDLINE.ORDER_ID", "ORD.ID");
        descriptor.addMapping((DatabaseMapping)onetomanymapping);
        IndirectListTestDatabase.modifyOrderDescriptor(descriptor);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildOrderLineDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(OrderLine.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("ORDLINE");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("ORDLINE.ID");
        descriptor.setIdentityMapClass(FullIdentityMap.class);
        descriptor.setSequenceNumberName("orderline");
        descriptor.setSequenceNumberFieldName("ID");
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        descriptor.createCopyPolicy("constructor");
        descriptor.createInstantiationPolicy("constructor");
        DirectToFieldMapping directtofieldmapping = new DirectToFieldMapping();
        directtofieldmapping.setAttributeName("id");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setFieldName("ORDLINE.ID");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping);
        DirectToFieldMapping directtofieldmapping1 = new DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("itemName");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setFieldName("ORDLINE.ITEM_NAME");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping1);
        DirectToFieldMapping directtofieldmapping2 = new DirectToFieldMapping();
        directtofieldmapping2.setAttributeName("quantity");
        directtofieldmapping2.setIsReadOnly(false);
        directtofieldmapping2.setFieldName("ORDLINE.QUANTITY");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping2);
        OneToOneMapping onetoonemapping = new OneToOneMapping();
        onetoonemapping.setAttributeName("order");
        onetoonemapping.setIsReadOnly(false);
        onetoonemapping.setUsesIndirection(false);
        onetoonemapping.setReferenceClass(Order.class);
        onetoonemapping.setIsPrivateOwned(false);
        onetoonemapping.addForeignKeyFieldName("ORDLINE.ORDER_ID", "ORD.ID");
        descriptor.addMapping((DatabaseMapping)onetoonemapping);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildSalesRepDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(SalesRep.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("SALEREP");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("SALEREP.ID");
        descriptor.setIdentityMapClass(FullIdentityMap.class);
        descriptor.setSequenceNumberName("salesrep");
        descriptor.setSequenceNumberFieldName("ID");
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        descriptor.createCopyPolicy("constructor");
        descriptor.createInstantiationPolicy("constructor");
        DirectToFieldMapping directtofieldmapping = new DirectToFieldMapping();
        directtofieldmapping.setAttributeName("id");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setFieldName("SALEREP.ID");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping);
        DirectToFieldMapping directtofieldmapping1 = new DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("name");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setFieldName("SALEREP.NAME");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping1);
        ManyToManyMapping manytomanymapping = new ManyToManyMapping();
        manytomanymapping.setAttributeName("orders");
        manytomanymapping.setIsReadOnly(true);
        manytomanymapping.setUsesIndirection(false);
        manytomanymapping.setReferenceClass(Order.class);
        manytomanymapping.setIsPrivateOwned(false);
        manytomanymapping.useCollectionClass(Vector.class);
        manytomanymapping.setRelationTableName("ORDREP");
        manytomanymapping.addSourceRelationKeyFieldName("ORDREP.SALEREP_ID", "SALEREP.ID");
        manytomanymapping.addTargetRelationKeyFieldName("ORDREP.ORDER_ID", "ORD.ID");
        descriptor.addMapping((DatabaseMapping)manytomanymapping);
        this.addDescriptor((ClassDescriptor)descriptor);
    }
}

