/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.aggregate;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.mappings.AggregateObjectMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.testing.models.aggregate.Switch;
import org.eclipse.persistence.testing.models.aggregate.SwitchState;
import org.eclipse.persistence.testing.models.aggregate.SwitchStateOFF;
import org.eclipse.persistence.testing.models.aggregate.SwitchStateON;

public class SwitchProject
extends Project {
    public SwitchProject() {
        this.setName("Switch");
        this.applyLogin();
        this.addDescriptor((ClassDescriptor)this.buildSwitchDescriptor());
        this.addDescriptor((ClassDescriptor)this.buildSwitchStateDescriptor());
        this.addDescriptor((ClassDescriptor)this.buildSwitchStateOFFDescriptor());
        this.addDescriptor((ClassDescriptor)this.buildSwitchStateONDescriptor());
    }

    public void applyLogin() {
        DatabaseLogin login = new DatabaseLogin();
        this.setLogin(login);
    }

    public RelationalDescriptor buildSwitchDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Switch.class);
        descriptor.addTableName("SWITCH");
        descriptor.addPrimaryKeyFieldName("SWITCH.ID");
        descriptor.useFullIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.setSequenceNumberFieldName("SWITCH.ID");
        descriptor.setSequenceNumberName("SEQ_SWITCH");
        descriptor.getDescriptorQueryManager().checkCacheForDoesExist();
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("SWITCH.ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        AggregateObjectMapping stateMapping = new AggregateObjectMapping();
        stateMapping.setAttributeName("state");
        stateMapping.setReferenceClass(SwitchState.class);
        stateMapping.setIsNullAllowed(false);
        stateMapping.addFieldNameTranslation("SWITCH.STATE", "STATE");
        descriptor.addMapping((DatabaseMapping)stateMapping);
        return descriptor;
    }

    public RelationalDescriptor buildSwitchStateDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.descriptorIsAggregate();
        descriptor.setJavaClass(SwitchState.class);
        descriptor.getDescriptorInheritancePolicy().setClassIndicatorFieldName("STATE");
        descriptor.getDescriptorInheritancePolicy().addClassIndicator(SwitchStateOFF.class, (Object)"OFF");
        descriptor.getDescriptorInheritancePolicy().addClassIndicator(SwitchStateON.class, (Object)"ON");
        return descriptor;
    }

    public RelationalDescriptor buildSwitchStateOFFDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.descriptorIsAggregate();
        descriptor.setJavaClass(SwitchStateOFF.class);
        descriptor.getDescriptorInheritancePolicy().setParentClass(SwitchState.class);
        return descriptor;
    }

    public RelationalDescriptor buildSwitchStateONDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.descriptorIsAggregate();
        descriptor.setJavaClass(SwitchStateON.class);
        descriptor.getDescriptorInheritancePolicy().setParentClass(SwitchState.class);
        return descriptor;
    }
}

