/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.optimization;

import java.util.Vector;
import org.eclipse.persistence.annotations.BatchFetchType;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class BatchReadingUnitOfWorkTest
extends TestCase {
    BatchFetchType batchType;

    public BatchReadingUnitOfWorkTest(BatchFetchType batchType) {
        this.setDescription("This test verifies that batch reading works correctly in a unit of work.");
        this.batchType = batchType;
        this.setName(this.getName() + batchType);
    }

    public void test() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        ReadAllQuery query = new ReadAllQuery();
        query.setBatchFetchType(this.batchType);
        query.setReferenceClass(Employee.class);
        query.addBatchReadAttribute("address");
        Vector employees = (Vector)uow.executeQuery((DatabaseQuery)query);
        ((Employee)employees.firstElement()).getAddress().getCity();
        uow.commit();
    }
}

