/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.inherited;

import java.util.Calendar;
import java.util.Date;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.jpa.inherited.Alpine;
import org.eclipse.persistence.testing.models.jpa.inherited.BeerConsumer;
import org.eclipse.persistence.testing.models.jpa.inherited.Canadian;
import org.eclipse.persistence.testing.models.jpa.inherited.SerialNumber;
import org.eclipse.persistence.testing.tests.jpa.EntityContainerTestBase;

public class InheritedCRUDTest
extends EntityContainerTestBase {
    protected boolean m_reset = false;
    protected Exception m_exception;
    private BeerConsumer beerConsumer1;
    private BeerConsumer beerConsumer2;
    private Alpine alpine1;
    private Alpine alpine2;
    private Alpine alpine3;
    private Canadian canadian1;
    private Canadian canadian2;

    public InheritedCRUDTest() {
        this.setDescription("Tests the creation of an inheritance subclass that uses multiple tables with a different pk column than its parent");
    }

    @Override
    public void setup() {
        super.setup();
        this.m_reset = true;
        this.m_exception = null;
        ((EntityManagerImpl)this.getEntityManager()).getActiveSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void test() throws Exception {
        try {
            this.beginTransaction();
            this.beerConsumer1 = new BeerConsumer();
            this.beerConsumer1.setName("Guy Pelletier");
            this.getEntityManager().persist((Object)this.beerConsumer1);
            this.beerConsumer2 = new BeerConsumer();
            this.beerConsumer2.setName("Tom Ware");
            this.getEntityManager().persist((Object)this.beerConsumer2);
            SerialNumber serialNumber1 = new SerialNumber();
            this.getEntityManager().persist((Object)serialNumber1);
            this.alpine1 = new Alpine(serialNumber1);
            this.alpine1.setBestBeforeDate(new Date(2005, 8, 17));
            this.alpine1.setAlcoholContent((Object)5.0);
            this.alpine1.setBeerConsumer(this.beerConsumer2);
            this.getEntityManager().persist((Object)this.alpine1);
            SerialNumber serialNumber2 = new SerialNumber();
            this.getEntityManager().persist((Object)serialNumber2);
            this.alpine2 = new Alpine(serialNumber2);
            this.alpine2.setBestBeforeDate(new Date(2005, 8, 21));
            this.alpine2.setAlcoholContent((Object)5.0);
            this.alpine2.setBeerConsumer(this.beerConsumer2);
            this.getEntityManager().persist((Object)this.alpine2);
            SerialNumber serialNumber3 = new SerialNumber();
            this.getEntityManager().persist((Object)serialNumber3);
            this.alpine3 = new Alpine(serialNumber3);
            this.alpine3.setBestBeforeDate(new Date(2005, 8, 22));
            this.alpine3.setAlcoholContent((Object)5.0);
            this.alpine3.setBeerConsumer(this.beerConsumer2);
            this.getEntityManager().persist((Object)this.alpine3);
            this.canadian1 = new Canadian();
            this.canadian1.setBornOnDate(Calendar.getInstance().getTime());
            this.canadian1.setAlcoholContent((Object)5.0);
            this.canadian1.setBeerConsumer(this.beerConsumer1);
            this.getEntityManager().persist((Object)this.canadian1);
            this.canadian2 = new Canadian();
            this.canadian2.setBornOnDate(Calendar.getInstance().getTime());
            this.canadian2.setAlcoholContent((Object)5.0);
            this.canadian2.setBeerConsumer(this.beerConsumer1);
            this.getEntityManager().persist((Object)this.canadian2);
            this.commitTransaction();
        }
        catch (Exception e) {
            this.m_exception = e;
        }
    }

    @Override
    public void reset() {
        if (this.m_reset) {
            this.m_reset = false;
        }
    }

    public void verify() {
        if (this.m_exception != null) {
            throw new TestErrorException("Exception was thrown when creating a bus: " + this.m_exception.getMessage());
        }
    }
}

