/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.diff;

import java.io.StringWriter;
import org.eclipse.persistence.tools.workbench.utility.diff.Diff;
import org.eclipse.persistence.tools.workbench.utility.diff.Differentiator;
import org.eclipse.persistence.tools.workbench.utility.io.IndentingPrintWriter;

public class SimpleDiff
implements Diff {
    private final Object object1;
    private final Object object2;
    private final String descriptionTitle;
    private final Differentiator differentiator;

    public SimpleDiff(Object object1, Object object2, String descriptionTitle, Differentiator differentiator) {
        this.object1 = object1;
        this.object2 = object2;
        this.descriptionTitle = descriptionTitle;
        this.differentiator = differentiator;
    }

    @Override
    public Object getObject1() {
        return this.object1;
    }

    @Override
    public Object getObject2() {
        return this.object2;
    }

    @Override
    public boolean identical() {
        return false;
    }

    @Override
    public boolean different() {
        return true;
    }

    @Override
    public Differentiator getDifferentiator() {
        return this.differentiator;
    }

    @Override
    public String getDescription() {
        StringWriter sw = new StringWriter();
        IndentingPrintWriter pw = new IndentingPrintWriter(sw);
        this.appendDescription(pw);
        return sw.toString();
    }

    @Override
    public void appendDescription(IndentingPrintWriter pw) {
        pw.print(this.descriptionTitle);
        pw.println(':');
        pw.print("object 1: ");
        pw.println(this.object1);
        pw.print("object 2: ");
        pw.println(this.object2);
    }

    public String getDescriptionTitle() {
        return this.descriptionTitle;
    }

    public String toString() {
        return this.getDescription();
    }
}

