/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational;

import java.util.Iterator;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQueryable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWAttributeItem;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWRelationalReadAllQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.Ordering;
import org.eclipse.persistence.tools.workbench.utility.node.Node;
import org.eclipse.persistence.tools.workbench.utility.node.Problem;

public final class MWOrderingItem
extends MWAttributeItem
implements Ordering {
    private volatile boolean ascending;

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWOrderingItem.class);
        descriptor.getInheritancePolicy().setParentClass(MWAttributeItem.class);
        ((AbstractDirectMapping)descriptor.addDirectMapping("ascending", "ascending/text()")).setNullValue((Object)Boolean.TRUE);
        return descriptor;
    }

    private MWOrderingItem() {
    }

    MWOrderingItem(MWRelationalReadAllQuery parent, MWQueryable queryable) {
        super((MWQuery)parent, queryable);
    }

    MWOrderingItem(MWRelationalReadAllQuery parent, Iterator queryables) {
        super((MWQuery)parent, queryables);
    }

    MWOrderingItem(MWRelationalReadAllQuery parent, Iterator queryables, Iterator allowsNull) {
        super(parent, queryables, allowsNull);
    }

    @Override
    protected void initialize(Node parentNode) {
        super.initialize(parentNode);
        this.ascending = true;
    }

    @Override
    public boolean isAscending() {
        return this.ascending;
    }

    public boolean isDesending() {
        return !this.isAscending();
    }

    @Override
    public void setAscending(boolean ascending) {
        boolean old = this.ascending;
        this.ascending = ascending;
        this.firePropertyChanged("ascending", old, this.ascending);
    }

    @Override
    public void removeSelfFromParent() {
        ((MWRelationalReadAllQuery)this.getParentQuery()).removeOrderingItem(this);
    }

    @Override
    public Problem queryableNullProblem() {
        return this.buildProblem("0252", this.getParentQuery().signature(), new Integer(((MWRelationalReadAllQuery)this.getParentQuery()).indexOfOrderingItem(this) + 1));
    }

    @Override
    public Problem queryableInvalidProblem(MWQueryable queryable) {
        return this.buildProblem("0253", queryable.displayString(), this.getParentQuery().signature());
    }

    @Override
    public boolean isQueryableValid(MWQueryable queryable) {
        return queryable.isValidForReadAllQueryOrderable();
    }

    @Override
    protected void adjustRuntimeQuery(ObjectLevelReadQuery readQuery) {
        Expression expression = this.getQueryableArgument().runtimeExpression(readQuery.getExpressionBuilder());
        if (this.isAscending()) {
            ((ReadAllQuery)readQuery).addOrdering(expression.ascending());
        } else {
            ((ReadAllQuery)readQuery).addOrdering(expression.descending());
        }
    }

    @Override
    public String displayString() {
        String displayString = super.displayString() + " (";
        displayString = this.isAscending() ? displayString + "Ascending" : displayString + "Descending";
        return displayString + ")";
    }
}

