/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.handles;

import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWClassHandle
extends MWHandle {
    private volatile MWClass type;
    private volatile String typeName;

    private MWClassHandle() {
    }

    public MWClassHandle(MWModel parent, MWHandle.NodeReferenceScrubber scrubber) {
        super(parent, scrubber);
    }

    public MWClassHandle(MWModel parent, MWClass type, MWHandle.NodeReferenceScrubber scrubber) {
        super(parent, scrubber);
        this.type = type;
    }

    public MWClass getType() {
        return this.type;
    }

    public void setType(MWClass type) {
        this.type = type;
    }

    @Override
    protected Node node() {
        return this.getType();
    }

    public MWClassHandle setScrubber(MWHandle.NodeReferenceScrubber scrubber) {
        this.setScrubberInternal(scrubber);
        return this;
    }

    @Override
    public void resolveClassHandles() {
        super.resolveClassHandles();
        if (this.typeName != null) {
            this.type = this.typeNamed(this.typeName);
            this.typeName = null;
        }
    }

    public int compareTo(Object o) {
        return this.type.compareTo(((MWClassHandle)o).type);
    }

    @Override
    public void toString(StringBuffer sb) {
        if (this.type == null) {
            sb.append("null");
        } else {
            this.type.toString(sb);
        }
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWClassHandle.class);
        descriptor.addDirectMapping("typeName", "getTypeNameForTopLink", "setTypeNameForTopLink", "type-name/text()");
        return descriptor;
    }

    private String getTypeNameForTopLink() {
        return this.type == null ? null : this.type.getName();
    }

    private void setTypeNameForTopLink(String typeName) {
        this.typeName = typeName;
    }

    public static XMLDescriptor legacy60BuildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWClassHandle.class);
        descriptor.addDirectMapping("typeName", "legacyGetTypeNameForTopLink", "legacySetTypeNameForTopLink", "type-name/text()");
        return descriptor;
    }

    public String legacyGetTypeNameForTopLink() {
        return this.getType().getName();
    }

    public void legacySetTypeNameForTopLink(String typeName) {
        this.typeName = MWModel.legacyReplaceToplinkDeprecatedClassReferences(typeName);
    }
}

