/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.descriptors.changetracking.AttributeChangeTrackingPolicy;
import org.eclipse.persistence.descriptors.changetracking.ObjectChangePolicy;
import org.eclipse.persistence.descriptors.changetracking.ObjectChangeTrackingPolicy;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.ColumnStringHolder;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWAdvancedPropertyAdditionException;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWAdvancedPropertyRemovalException;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWClassIndicatorFieldPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWClassIndicatorPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWClassIndicatorValue;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorInheritancePolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorInterfaceAliasPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWInheritancePolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWInterfaceAliasDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWNullDescriptorPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWRefreshCachePolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWReturningPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWTransactionalDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWTransactionalPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWDescriptorMultiTableInfoPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalClassDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalClassIndicatorFieldPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalPrimaryKeyPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalReturningPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalTransactionalPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWUserDefinedQueryKey;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWColumnHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWTableHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MappingStringHolder;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWRelationalDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassAttribute;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProjectDefaultsPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.relational.MWRelationalProject;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQueryable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWRelationalQueryManager;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.filters.Filter;
import org.eclipse.persistence.tools.workbench.utility.iterators.CompositeIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;
import org.eclipse.persistence.tools.workbench.utility.string.PartialStringComparatorEngine;
import org.eclipse.persistence.tools.workbench.utility.string.StringHolder;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public final class MWTableDescriptor
extends MWRelationalClassDescriptor
implements MWTransactionalDescriptor,
MWInterfaceAliasDescriptor {
    private MWTableHandle primaryTableHandle;
    public static final String PRIMARY_TABLE_PROPERTY = "primaryTable";
    private volatile boolean usesSequencing;
    public static final String USES_SEQUENCING_PROPERTY = "usesSequencing";
    private volatile String sequenceNumberName;
    public static final String SEQUENCE_NUMBER_NAME_PROPERTY = "sequenceNumberName";
    private MWTableHandle sequenceNumberTableHandle;
    public static final String SEQUENCE_NUMBER_TABLE_PROPERTY = "sequenceNumberTable";
    private MWColumnHandle sequenceNumberColumnHandle;
    public static final String SEQUENCE_NUMBER_COLUMN_PROPERTY = "sequenceNumberColumn";
    private volatile MWDescriptorPolicy multiTableInfoPolicy;
    public static final String MULTI_TABLE_INFO_POLICY_PROPERTY = "multiTableInfoPolicy";
    private volatile MWDescriptorPolicy interfaceAliasPolicy;
    public static final String INTERFACE_ALIAS_POLICY_PROPERTY = "interfaceAliasPolicy";
    private volatile MWDescriptorPolicy returningPolicy;
    private volatile String changeTrackingType;
    public static final String CHANGE_TRACKING_TYPE_PROPERTY = "changeTrackingType";
    public static final String OBJECT_LEVEL_CHANGE_TRACKING = "objectLevelChangeTracking";
    public static final String ATTRIBUTE_LEVEL_CHANGE_TRACKING = "attributeLevelChangeTracking";

    private MWTableDescriptor() {
    }

    public MWTableDescriptor(MWRelationalProject parent, MWClass type, String name) {
        super(parent, type, name);
    }

    @Override
    protected void initialize(Node parent) {
        super.initialize(parent);
        this.primaryTableHandle = new MWTableHandle(this, this.buildPrimaryTableScrubber());
        this.sequenceNumberColumnHandle = new MWColumnHandle(this, this.buildSequenceNumberColumnScrubber());
        this.sequenceNumberTableHandle = new MWTableHandle(this, this.buildSequenceNumberTableScrubber());
        this.sequenceNumberName = "";
        this.interfaceAliasPolicy = new MWNullDescriptorPolicy(this);
        this.multiTableInfoPolicy = new MWNullDescriptorPolicy(this);
        this.returningPolicy = new MWNullDescriptorPolicy(this);
    }

    @Override
    public MWTable getPrimaryTable() {
        return this.primaryTableHandle.getTable();
    }

    public void setPrimaryTable(MWTable newValue) {
        MWTable oldValue = this.getPrimaryTable();
        this.primaryTableHandle.setTable(newValue);
        this.firePropertyChanged(PRIMARY_TABLE_PROPERTY, oldValue, newValue);
        this.primaryKeyPolicy().descriptorPrimaryTableChanged(newValue);
    }

    @Override
    public void notifyExpressionsToRecalculateQueryables() {
        this.getRelationalQueryManager().notifyExpressionsToRecalculateQueryables();
    }

    @Override
    protected MWTransactionalPolicy buildDefaultTransactionalPolicy() {
        return new MWRelationalTransactionalPolicy(this);
    }

    public MWRelationalTransactionalPolicy getRelationalTransactionalPolicy() {
        return (MWRelationalTransactionalPolicy)this.getTransactionalPolicy();
    }

    public MWRelationalPrimaryKeyPolicy primaryKeyPolicy() {
        return this.getRelationalTransactionalPolicy().getPrimaryKeyPolicy();
    }

    public Iterator primaryKeyChoices() {
        return this.primaryKeyPolicy().primaryKeyChoices();
    }

    @Override
    public Iterator primaryKeyAttributes() {
        Vector<MWClassAttribute> pkAttributes = new Vector<MWClassAttribute>();
        Iterator it = this.primaryKeyMappings();
        while (it.hasNext()) {
            pkAttributes.add(((MWMapping)it.next()).getInstanceVariable());
        }
        return pkAttributes.iterator();
    }

    @Override
    public Iterator primaryKeyMappings() {
        Vector pkMappings = new Vector();
        Iterator pkFieldIt = this.primaryKeyPolicy().primaryKeys();
        while (pkFieldIt.hasNext()) {
            pkMappings.addAll(this.allWritableMappingsForField((MWColumn)pkFieldIt.next()));
        }
        return pkMappings.iterator();
    }

    public Iterator primaryKeyNames() {
        return new TransformationIterator(this.primaryKeys()){

            @Override
            protected Object transform(Object next) {
                return ((MWColumn)next).getName();
            }
        };
    }

    public Iterator primaryKeys() {
        return this.primaryKeyPolicy().primaryKeys();
    }

    public int primaryKeysSize() {
        return this.primaryKeyPolicy().primaryKeysSize();
    }

    public boolean usesSequencing() {
        return this.usesSequencing;
    }

    public void setUsesSequencing(boolean usesSequencing) {
        boolean old = this.usesSequencing;
        this.usesSequencing = usesSequencing;
        if (old != usesSequencing) {
            if (!usesSequencing) {
                this.setSequenceNumberName("");
                this.setSequenceNumberTable(null);
            } else {
                this.initializeDefaultSequenceTableInfo();
            }
            this.firePropertyChanged(USES_SEQUENCING_PROPERTY, old, usesSequencing);
        }
    }

    private void initializeDefaultSequenceTableInfo() {
        this.setSequenceNumberName("SEQ");
        if (this.getPrimaryTable() != null) {
            this.setSequenceNumberTable(this.getPrimaryTable());
            if (this.getPrimaryTable().primaryKeyColumnsSize() > 0) {
                this.setSequenceNumberColumn((MWColumn)this.getPrimaryTable().primaryKeyColumns().next());
            }
        }
    }

    @Override
    public boolean usesSequencingInDescriptorHierarchy() {
        if (this.usesSequencing()) {
            return true;
        }
        MWDescriptor parent = this.getInheritancePolicy().getParentDescriptor();
        return parent == null ? false : parent.usesSequencingInDescriptorHierarchy();
    }

    public String getSequenceNumberName() {
        return this.sequenceNumberName;
    }

    public void setSequenceNumberName(String sequenceNumberName) {
        if (!this.usesSequencing() && !sequenceNumberName.equals("")) {
            throw new IllegalStateException("Must have useSequencing set to true to set the sequence number name");
        }
        String old = this.sequenceNumberName;
        this.sequenceNumberName = sequenceNumberName;
        this.firePropertyChanged(SEQUENCE_NUMBER_NAME_PROPERTY, old, sequenceNumberName);
    }

    public MWColumn getSequenceNumberColumn() {
        return this.sequenceNumberColumnHandle.getColumn();
    }

    public void setSequenceNumberColumn(MWColumn sequenceNumberColumn) {
        if (!this.usesSequencing() && sequenceNumberColumn != null) {
            throw new IllegalStateException("Must have useSequencing set to true to set the sequence column");
        }
        if (this.getSequenceNumberTable() == null && sequenceNumberColumn != null) {
            throw new IllegalStateException("Must have the sequence table set to set the sequence column");
        }
        if (sequenceNumberColumn != null && this.getSequenceNumberTable() != sequenceNumberColumn.getTable()) {
            throw new IllegalArgumentException("The column must be in the current sequence number table");
        }
        MWColumn old = this.sequenceNumberColumnHandle.getColumn();
        this.sequenceNumberColumnHandle.setColumn(sequenceNumberColumn);
        this.firePropertyChanged(SEQUENCE_NUMBER_COLUMN_PROPERTY, old, sequenceNumberColumn);
    }

    public MWTable getSequenceNumberTable() {
        return this.sequenceNumberTableHandle.getTable();
    }

    public void setSequenceNumberTable(MWTable sequenceNumberTable) {
        if (!this.usesSequencing() && sequenceNumberTable != null) {
            throw new IllegalStateException("Must have useSequencing set to true to set the sequence table");
        }
        MWTable old = this.getSequenceNumberTable();
        this.sequenceNumberTableHandle.setTable(sequenceNumberTable);
        this.setSequenceNumberColumn(null);
        this.firePropertyChanged(SEQUENCE_NUMBER_TABLE_PROPERTY, old, sequenceNumberTable);
    }

    public MWRefreshCachePolicy getRefreshCachePolicy() {
        return this.getRelationalTransactionalPolicy().getRefreshCachePolicy();
    }

    public MWRelationalQueryManager getRelationalQueryManager() {
        return (MWRelationalQueryManager)this.getRelationalTransactionalPolicy().getQueryManager();
    }

    public MWQueryable firstQueryable() {
        for (MWQueryable queryable : this.getQueryables(Filter.NULL_INSTANCE)) {
            if (!queryable.isLeaf(Filter.NULL_INSTANCE)) continue;
            return queryable;
        }
        return null;
    }

    private MWDescriptorMultiTableInfoPolicy getMultiTableInfoPolicyForTopLink() {
        return (MWDescriptorMultiTableInfoPolicy)this.multiTableInfoPolicy.getPersistedPolicy();
    }

    private void setMultiTableInfoPolicyForTopLink(MWDescriptorMultiTableInfoPolicy multiTableInfoPolicy) {
        this.multiTableInfoPolicy = multiTableInfoPolicy == null ? new MWNullDescriptorPolicy(this) : multiTableInfoPolicy;
    }

    private void setMultiTableInfoPolicy(MWDescriptorPolicy multiTableInfoPolicy) {
        MWDescriptorPolicy old = this.multiTableInfoPolicy;
        this.multiTableInfoPolicy = multiTableInfoPolicy;
        this.firePropertyChanged(MULTI_TABLE_INFO_POLICY_PROPERTY, old, this.multiTableInfoPolicy);
    }

    public MWDescriptorPolicy getMultiTableInfoPolicy() {
        return this.multiTableInfoPolicy;
    }

    public void addMultiTableInfoPolicy() throws MWAdvancedPropertyAdditionException {
        if (this.multiTableInfoPolicy.isActive()) {
            throw new MWAdvancedPropertyAdditionException(MULTI_TABLE_INFO_POLICY_PROPERTY, "policy already exists on descriptor");
        }
        this.setMultiTableInfoPolicy(new MWDescriptorMultiTableInfoPolicy(this));
    }

    public void removeMultiTableInfoPolicy() {
        if (!this.multiTableInfoPolicy.isActive()) {
            throw new MWAdvancedPropertyRemovalException(MULTI_TABLE_INFO_POLICY_PROPERTY, "policy does not exist on the descriptor");
        }
        this.getMultiTableInfoPolicy().dispose();
        this.setMultiTableInfoPolicy(new MWNullDescriptorPolicy(this));
    }

    private void setInterfaceAliasPolicyForTopLink(MWDescriptorInterfaceAliasPolicy interfaceAliasPolicy) {
        this.interfaceAliasPolicy = interfaceAliasPolicy == null ? new MWNullDescriptorPolicy(this) : interfaceAliasPolicy;
    }

    private MWDescriptorInterfaceAliasPolicy getInterfaceAliasPolicyForTopLink() {
        return (MWDescriptorInterfaceAliasPolicy)this.interfaceAliasPolicy.getPersistedPolicy();
    }

    protected void setInterfaceAliasPolicy(MWDescriptorPolicy interfaceAliasPolicy) {
        MWDescriptorPolicy old = this.interfaceAliasPolicy;
        this.interfaceAliasPolicy = interfaceAliasPolicy;
        this.firePropertyChanged(INTERFACE_ALIAS_POLICY_PROPERTY, old, this.interfaceAliasPolicy);
    }

    @Override
    public MWDescriptorPolicy getInterfaceAliasPolicy() {
        return this.interfaceAliasPolicy;
    }

    @Override
    public void removeInterfaceAliasPolicy() {
        if (!this.interfaceAliasPolicy.isActive()) {
            throw new MWAdvancedPropertyRemovalException(INTERFACE_ALIAS_POLICY_PROPERTY, "policy does not exist on the descriptor");
        }
        this.setInterfaceAliasPolicy(new MWNullDescriptorPolicy(this));
    }

    @Override
    public void addInterfaceAliasPolicy() throws MWAdvancedPropertyAdditionException {
        if (this.interfaceAliasPolicy.isActive()) {
            throw new MWAdvancedPropertyAdditionException(INTERFACE_ALIAS_POLICY_PROPERTY, "policy already exists on descriptor");
        }
        this.setInterfaceAliasPolicy(new MWDescriptorInterfaceAliasPolicy(this));
    }

    @Override
    public boolean supportsInterfaceAliasPolicy() {
        return true;
    }

    @Override
    public boolean supportsMultitablePolicy() {
        return true;
    }

    public void addAssociatedTable(MWTable table) {
        if (!this.getMultiTableInfoPolicy().isActive()) {
            throw new IllegalStateException("Cannot add associated tables unless the descriptor has the Multitable info policy");
        }
        ((MWDescriptorMultiTableInfoPolicy)this.getMultiTableInfoPolicy()).addSecondaryTable(table);
    }

    public void removeAssociatedTable(MWTable table) {
        ((MWDescriptorMultiTableInfoPolicy)this.getMultiTableInfoPolicy()).removeSecondaryTable(table);
    }

    public MWTable getAssociatedTableNamed(String tableName) {
        Iterator stream = this.associatedTables();
        while (stream.hasNext()) {
            MWTable table = (MWTable)stream.next();
            if (!table.getName().equals(tableName)) continue;
            return table;
        }
        return null;
    }

    public boolean hasAssociatedTable(MWTable table) {
        Iterator stream = this.associatedTables();
        while (stream.hasNext()) {
            MWTable currTable = (MWTable)stream.next();
            if (currTable != table) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator associatedTables() {
        if (this.getPrimaryTable() != null && !CollectionTools.contains(this.secondaryTables(), (Object)this.getPrimaryTable())) {
            return new CompositeIterator(this.getPrimaryTable(), this.secondaryTables());
        }
        return this.secondaryTables();
    }

    @Override
    public int associatedTablesSize() {
        return CollectionTools.size(this.associatedTables());
    }

    public Iterator secondaryTables() {
        if (this.getMultiTableInfoPolicy().isActive()) {
            return ((MWDescriptorMultiTableInfoPolicy)this.getMultiTableInfoPolicy()).secondaryTables();
        }
        return NullIterator.instance();
    }

    public String getChangeTrackingType() {
        return this.changeTrackingType;
    }

    public void setChangeTrackingType(String changeTrackingType) {
        String oldChangeTrackingType = this.changeTrackingType;
        this.changeTrackingType = changeTrackingType;
        this.firePropertyChanged(CHANGE_TRACKING_TYPE_PROPERTY, oldChangeTrackingType, changeTrackingType);
    }

    @Override
    public MWDescriptorPolicy getReturningPolicy() {
        return this.returningPolicy;
    }

    private MWReturningPolicy getReturningPolicyForTopLink() {
        return (MWReturningPolicy)this.returningPolicy.getPersistedPolicy();
    }

    private void setReturningPolicyForTopLink(MWReturningPolicy returningPolicy) {
        this.returningPolicy = returningPolicy == null ? new MWNullDescriptorPolicy(this) : returningPolicy;
    }

    private void setReturningPolicy(MWDescriptorPolicy returningPolicy) {
        MWDescriptorPolicy old = this.returningPolicy;
        this.returningPolicy = returningPolicy;
        this.firePropertyChanged("returningPolicy", old, returningPolicy);
    }

    @Override
    public void addReturningPolicy() throws MWAdvancedPropertyAdditionException {
        if (this.returningPolicy.isActive()) {
            throw new MWAdvancedPropertyAdditionException("returningPolicy", "policy already exists on descriptor");
        }
        this.setReturningPolicy(new MWRelationalReturningPolicy(this));
    }

    @Override
    public void removeReturningPolicy() {
        if (!this.returningPolicy.isActive()) {
            throw new MWAdvancedPropertyRemovalException("returningPolicy", "policy does not exist on the descriptor");
        }
        this.getReturningPolicy().dispose();
        this.setReturningPolicy(new MWNullDescriptorPolicy(this));
    }

    @Override
    public boolean supportsReturningPolicy() {
        return true;
    }

    @Override
    public boolean supportsCachingPolicy() {
        return true;
    }

    @Override
    public MWTableDescriptor asMWTableDescriptor() {
        return this;
    }

    @Override
    public void initializeOn(MWDescriptor newDescriptor) {
        ((MWRelationalDescriptor)((Object)newDescriptor)).initializeFromMWTableDescriptor(this);
    }

    @Override
    public boolean isRootDescriptor() {
        return true;
    }

    @Override
    public boolean isTableDescriptor() {
        return true;
    }

    @Override
    public void applyAdvancedPolicyDefaults(MWProjectDefaultsPolicy defaultsPolicy) {
        defaultsPolicy.applyAdvancedPolicyDefaults(this);
    }

    @Override
    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        children.add(this.sequenceNumberColumnHandle);
        children.add(this.sequenceNumberTableHandle);
        children.add(this.primaryTableHandle);
        children.add(this.interfaceAliasPolicy);
        children.add(this.multiTableInfoPolicy);
        children.add(this.returningPolicy);
    }

    private MWHandle.NodeReferenceScrubber buildSequenceNumberColumnScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            @Override
            public void nodeReferenceRemoved(Node node, MWHandle handle) {
                MWTableDescriptor.this.setSequenceNumberColumn(null);
            }

            public String toString() {
                return "MWTableDescriptor.buildSequenceNumberColumnScrubber()";
            }
        };
    }

    private MWHandle.NodeReferenceScrubber buildSequenceNumberTableScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            @Override
            public void nodeReferenceRemoved(Node node, MWHandle handle) {
                MWTableDescriptor.this.setSequenceNumberTable(null);
            }

            public String toString() {
                return "MWTableDescriptor.buildSequenceNumberTableScrubber()";
            }
        };
    }

    private MWHandle.NodeReferenceScrubber buildPrimaryTableScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            @Override
            public void nodeReferenceRemoved(Node node, MWHandle handle) {
                MWTableDescriptor.this.setPrimaryTable(null);
            }

            public String toString() {
                return "MWTableDescriptor.buildPrimaryTableScrubber()";
            }
        };
    }

    @Override
    protected void automapInheritanceHierarchyInternal(Collection automapDescriptors) {
        super.automapInheritanceHierarchyInternal(automapDescriptors);
        MWRelationalClassDescriptor parentDescriptor = this.automapFindParentDescriptor();
        if (parentDescriptor == null) {
            return;
        }
        if (automapDescriptors.contains(parentDescriptor)) {
            parentDescriptor.automapSuperDescriptorInheritance(automapDescriptors);
        }
        this.automapDescriptorInheritance(parentDescriptor);
        if (parentDescriptor.isAggregateDescriptor()) {
            this.asMWAggregateDescriptor();
        }
    }

    private MWRelationalClassDescriptor automapFindParentDescriptor() {
        for (MWClass javaClass = this.getMWClass().getSuperclass(); javaClass != null; javaClass = javaClass.getSuperclass()) {
            if (javaClass.isInterface()) {
                return null;
            }
            MWDescriptor parentDescriptor = this.getProject().descriptorForType(javaClass);
            if (parentDescriptor == null || !parentDescriptor.isActive()) continue;
            return (MWRelationalClassDescriptor)parentDescriptor;
        }
        return null;
    }

    private void automapDescriptorInheritance(MWRelationalClassDescriptor parentDescriptor) {
        MWInheritancePolicy rootIP;
        MWInheritancePolicy ip = this.getInheritancePolicy();
        if (!ip.isActive()) {
            this.addInheritancePolicy();
            ip = this.getInheritancePolicy();
        }
        ((MWDescriptorInheritancePolicy)ip).setIsRoot(false);
        ((MWDescriptorInheritancePolicy)ip).setParentDescriptor(parentDescriptor);
        if (!this.getMWClass().isAbstract() && (rootIP = ip.getRootDescriptor().getInheritancePolicy()).isActive()) {
            MWClassIndicatorFieldPolicy fieldPolicy = (MWClassIndicatorFieldPolicy)rootIP.getClassIndicatorPolicy();
            MWClassIndicatorValue indicatorValue = fieldPolicy.getClassIndicatorValueForDescriptor(this);
            if (indicatorValue == null) {
                indicatorValue = fieldPolicy.addIndicator(this.getName(), this);
            } else {
                indicatorValue.setIndicatorValue(this.getName());
            }
            indicatorValue.setInclude(true);
        }
    }

    @Override
    protected boolean autoMapRequiresMetaDataInternal() {
        return this.getPrimaryTable() == null;
    }

    @Override
    protected void automapDirectMappingColumns() {
        StringHolder[] mappingStringHolders = this.buildColumnlessDirectMappingStringHolders();
        StringHolder[] columnStringHolders = this.buildAllUnmappedColumnStringHolders();
        PartialStringComparatorEngine.StringHolderPair[] pairs = PARTIAL_STRING_COMPARATOR_ENGINE.match(mappingStringHolders, columnStringHolders);
        int i = pairs.length;
        while (i-- > 0) {
            PartialStringComparatorEngine.StringHolderPair pair = pairs[i];
            MappingStringHolder mappingHolder = (MappingStringHolder)pair.getStringHolder1();
            ColumnStringHolder columnHolder = (ColumnStringHolder)pair.getStringHolder2();
            if (mappingHolder == null || columnHolder == null || !(pair.getScore() > 0.5)) continue;
            MWRelationalDirectMapping mapping = (MWRelationalDirectMapping)mappingHolder.getMapping();
            mapping.setColumn(columnHolder.getColumn());
        }
    }

    private MappingStringHolder[] buildColumnlessDirectMappingStringHolders() {
        ArrayList columnlessDirectMappings = new ArrayList();
        Iterator stream = this.mappings();
        while (stream.hasNext()) {
            ((MWMapping)stream.next()).addColumnlessDirectMappingTo(columnlessDirectMappings);
        }
        return MappingStringHolder.buildHolders(columnlessDirectMappings);
    }

    private ColumnStringHolder[] buildAllUnmappedColumnStringHolders() {
        ArrayList unmappedColumns = new ArrayList();
        Iterator stream = this.associatedTables();
        while (stream.hasNext()) {
            CollectionTools.addAll(unmappedColumns, ((MWTable)stream.next()).columns());
        }
        stream = this.mappings();
        while (stream.hasNext()) {
            MWMapping mapping = (MWMapping)stream.next();
            ArrayList writtenFields = new ArrayList();
            mapping.addWrittenFieldsTo(writtenFields);
            unmappedColumns.removeAll(writtenFields);
        }
        return ColumnStringHolder.buildHolders(unmappedColumns);
    }

    @Override
    protected void addProblemsTo(List newProblems) {
        super.addProblemsTo(newProblems);
        this.checkPrimaryTable(newProblems);
        this.checkPrimaryKeys(newProblems);
        this.checkPrimaryKeysMapped(newProblems);
        this.checkPrimaryKeysMatchParent(newProblems);
        this.checkPrimaryKeyMappingsNotReadOnly(newProblems);
        this.checkSequencing(newProblems);
        this.checkClassIndicatorFieldMapping(newProblems);
        this.checkQueries(newProblems);
    }

    private void checkPrimaryTable(List newProblems) {
        if (this.getPrimaryTable() == null) {
            newProblems.add(this.buildProblem("0230"));
        }
    }

    private void checkPrimaryKeys(List newProblems) {
        boolean hasParent;
        boolean bl = hasParent = this.getInheritancePolicy().getParentDescriptor() != null;
        if (!hasParent && this.getPrimaryTable() != null && this.primaryKeyPolicy().primaryKeysSize() == 0) {
            newProblems.add(this.buildProblem("0231"));
        }
    }

    private void checkPrimaryKeysMapped(List newProblems) {
        boolean noTable;
        boolean hasParent = this.getInheritancePolicy().getParentDescriptor() != null;
        boolean bl = noTable = this.getPrimaryTable() == null;
        if (hasParent || noTable) {
            return;
        }
        Iterator stream = this.primaryKeyPolicy().primaryKeys();
        while (stream.hasNext()) {
            MWColumn primaryKey = (MWColumn)stream.next();
            Collection mappingsForField = this.allWritableMappingsForField(primaryKey);
            if (mappingsForField.size() != 0) continue;
            newProblems.add(this.buildProblem("0232", primaryKey.getName()));
        }
    }

    private void checkPrimaryKeysMatchParent(List newProblems) {
        boolean noPrimaryTable;
        boolean noParent = !this.getInheritancePolicy().isActive() || this.getInheritancePolicy().getParentDescriptor() == null;
        boolean bl = noPrimaryTable = this.getPrimaryTable() == null;
        if (noParent || noPrimaryTable) {
            return;
        }
        if (this.getMultiTableInfoPolicy().isActive() && ((MWDescriptorMultiTableInfoPolicy)this.getMultiTableInfoPolicy()).pksAcrossMultipleTablesTest(true)) {
            return;
        }
        if (this.getInheritancePolicy().getParentDescriptor() instanceof MWTableDescriptor) {
            Collection parentKeyNamesCollection = CollectionTools.collection(((MWTableDescriptor)this.getInheritancePolicy().getParentDescriptor()).primaryKeyNames());
            if (this.primaryKeysSize() != parentKeyNamesCollection.size()) {
                newProblems.add(this.buildProblem("0233"));
            }
            Iterator stream = this.primaryKeys();
            while (stream.hasNext()) {
                MWColumn column = (MWColumn)stream.next();
                if (parentKeyNamesCollection.contains(column.getName())) continue;
                newProblems.add(this.buildProblem("0234"));
            }
            MWTableDescriptor parentDescriptor = (MWTableDescriptor)this.getInheritancePolicy().getParentDescriptor();
            Iterator stream2 = parentDescriptor.primaryKeyMappings();
            while (stream2.hasNext()) {
                MWMapping parentPkMapping = (MWMapping)stream2.next();
                MWMapping childMapping = this.mappingNamed(parentPkMapping.getInstanceVariable().getName());
                if (childMapping == null || !CollectionTools.collection(this.primaryKeyMappings()).contains(childMapping) || ((MWRelationalDirectMapping)parentPkMapping).getColumn() != ((MWRelationalDirectMapping)childMapping).getColumn()) continue;
                newProblems.add(this.buildProblem("0226", childMapping));
            }
        }
    }

    private void checkSequencing(List newProblems) {
        if (!this.usesSequencing()) {
            return;
        }
        if (StringTools.stringIsEmpty(this.getSequenceNumberName())) {
            newProblems.add(this.buildProblem("0237"));
        }
        if (this.getSequenceNumberTable() == null) {
            newProblems.add(this.buildProblem("0238"));
            return;
        }
        if (this.getSequenceNumberColumn() == null) {
            newProblems.add(this.buildProblem("0236"));
        }
        if (!CollectionTools.contains(this.associatedTables(), (Object)this.getSequenceNumberTable())) {
            newProblems.add(this.buildProblem("0239"));
        }
    }

    private void checkQueries(List newProblems) {
        Iterator queriesOuter = this.getRelationalQueryManager().queries();
        while (queriesOuter.hasNext()) {
            String queryOneSignature = ((MWQuery)queriesOuter.next()).signature();
            boolean firstMatch = true;
            Iterator queriesInner = this.getRelationalQueryManager().queries();
            while (queriesInner.hasNext()) {
                MWQuery query = (MWQuery)queriesInner.next();
                if (!query.signature().equals(queryOneSignature)) continue;
                if (!firstMatch) {
                    String queryName = query.getName();
                    newProblems.add(this.buildProblem("0240", queryName));
                    continue;
                }
                firstMatch = false;
            }
        }
    }

    private void checkPrimaryKeyMappingsNotReadOnly(List newProblems) {
        boolean noPrimaryKeyFields;
        MWInheritancePolicy policy = this.getInheritancePolicy();
        boolean hasParent = policy.getParentDescriptor() != null;
        boolean noTable = this.getPrimaryTable() == null;
        boolean bl = noPrimaryKeyFields = this.getRelationalTransactionalPolicy().getPrimaryKeyPolicy().primaryKeysSize() == 0;
        if (hasParent || noTable || noPrimaryKeyFields) {
            return;
        }
        Iterator stream = this.getRelationalTransactionalPolicy().getPrimaryKeyPolicy().primaryKeys();
        while (stream.hasNext()) {
            MWColumn primaryKey = (MWColumn)stream.next();
            if (this.allWritableMappingsForField(primaryKey).size() != 0) continue;
            newProblems.add(this.buildProblem("0235", primaryKey.getName()));
        }
    }

    @Override
    protected String multipleMappingsWriteFieldProblemResourceStringKey() {
        return "0106";
    }

    private void checkClassIndicatorFieldMapping(List newProblems) {
        MWInheritancePolicy inheritPolicy = this.getInheritancePolicy();
        if (!inheritPolicy.isRoot()) {
            return;
        }
        MWClassIndicatorPolicy indicatorPolicy = inheritPolicy.getClassIndicatorPolicy();
        if (indicatorPolicy.getType() == "classExtractionMethodClassIndicatorPolicy" || indicatorPolicy.getType() == "nullPolicy") {
            return;
        }
        MWColumn indicatorField = ((MWRelationalClassIndicatorFieldPolicy)indicatorPolicy).getColumn();
        if (indicatorField == null || indicatorField.isPrimaryKey()) {
            return;
        }
        if (this.allWritableMappingsForField(indicatorField).size() != 0) {
            newProblems.add(this.buildProblem("0126", indicatorField.getName()));
        }
    }

    @Override
    protected ClassDescriptor buildBasicRuntimeDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClassName(this.getMWClass().getName());
        return descriptor;
    }

    @Override
    public ClassDescriptor buildRuntimeDescriptor() {
        String ctt;
        ClassDescriptor runtimeDescriptor = super.buildRuntimeDescriptor();
        if (this.getPrimaryTable() != null) {
            runtimeDescriptor.setTableName(this.getPrimaryTable().getName());
        }
        if (this.usesSequencing() && this.getSequenceNumberColumn() != null) {
            runtimeDescriptor.setSequenceNumberField(new DatabaseField(this.getSequenceNumberColumn().qualifiedName()));
            runtimeDescriptor.setSequenceNumberName(this.getSequenceNumberName());
        }
        if (ATTRIBUTE_LEVEL_CHANGE_TRACKING.equals(ctt = this.getChangeTrackingType())) {
            runtimeDescriptor.setObjectChangePolicy((ObjectChangePolicy)new AttributeChangeTrackingPolicy());
        } else if (OBJECT_LEVEL_CHANGE_TRACKING.equals(ctt)) {
            runtimeDescriptor.setObjectChangePolicy((ObjectChangePolicy)new ObjectChangeTrackingPolicy());
        }
        this.interfaceAliasPolicy.adjustRuntimeDescriptor(runtimeDescriptor);
        this.multiTableInfoPolicy.adjustRuntimeDescriptor(runtimeDescriptor);
        this.returningPolicy.adjustRuntimeDescriptor(runtimeDescriptor);
        return runtimeDescriptor;
    }

    @Override
    protected void adjustUserDefinedQueryKeys(ClassDescriptor runtimeDescriptor) {
        Iterator queryKeys = this.userDefinedQueryKeys();
        while (queryKeys.hasNext()) {
            MWUserDefinedQueryKey queryKey = (MWUserDefinedQueryKey)queryKeys.next();
            if (queryKey.getColumn() == null) continue;
            runtimeDescriptor.addDirectQueryKey(queryKey.getName(), queryKey.getColumn().qualifiedName());
        }
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWTableDescriptor.class);
        descriptor.getInheritancePolicy().setParentClass(MWRelationalClassDescriptor.class);
        XMLCompositeObjectMapping primaryTableMapping = new XMLCompositeObjectMapping();
        primaryTableMapping.setAttributeName("primaryTableHandle");
        primaryTableMapping.setGetMethodName("getPrimaryTableHandleForTopLink");
        primaryTableMapping.setSetMethodName("setPrimaryTableHandleForTopLink");
        primaryTableMapping.setReferenceClass(MWTableHandle.class);
        primaryTableMapping.setXPath("primary-table-handle");
        descriptor.addMapping((DatabaseMapping)primaryTableMapping);
        XMLDirectMapping usesSequencingMapping = (XMLDirectMapping)descriptor.addDirectMapping(USES_SEQUENCING_PROPERTY, "uses-sequencing/text()");
        usesSequencingMapping.setNullValue((Object)Boolean.FALSE);
        XMLDirectMapping sequenceNumberNameMapping = (XMLDirectMapping)descriptor.addDirectMapping(SEQUENCE_NUMBER_NAME_PROPERTY, "sequence-number-name/text()");
        sequenceNumberNameMapping.setNullValue((Object)"");
        XMLCompositeObjectMapping sequenceNumberTableHandleMapping = new XMLCompositeObjectMapping();
        sequenceNumberTableHandleMapping.setAttributeName("sequenceNumberTableHandle");
        sequenceNumberTableHandleMapping.setGetMethodName("getSequenceNumberTableHandleForTopLink");
        sequenceNumberTableHandleMapping.setSetMethodName("setSequenceNumberTableHandleForTopLink");
        sequenceNumberTableHandleMapping.setReferenceClass(MWTableHandle.class);
        sequenceNumberTableHandleMapping.setXPath("sequence-number-table-handle");
        descriptor.addMapping((DatabaseMapping)sequenceNumberTableHandleMapping);
        XMLCompositeObjectMapping sequenceNumberColumnHandleMapping = new XMLCompositeObjectMapping();
        sequenceNumberColumnHandleMapping.setAttributeName("sequenceNumberColumnHandle");
        sequenceNumberColumnHandleMapping.setGetMethodName("getSequenceNumberColumnHandleForTopLink");
        sequenceNumberColumnHandleMapping.setSetMethodName("setSequenceNumberColumnHandleForTopLink");
        sequenceNumberColumnHandleMapping.setReferenceClass(MWColumnHandle.class);
        sequenceNumberColumnHandleMapping.setXPath("sequence-number-column-handle");
        descriptor.addMapping((DatabaseMapping)sequenceNumberColumnHandleMapping);
        descriptor.addDirectMapping(CHANGE_TRACKING_TYPE_PROPERTY, "change-tracking-type/text()");
        XMLCompositeObjectMapping interfaceAliasPolicyMapping = new XMLCompositeObjectMapping();
        interfaceAliasPolicyMapping.setAttributeName(INTERFACE_ALIAS_POLICY_PROPERTY);
        interfaceAliasPolicyMapping.setReferenceClass(MWDescriptorInterfaceAliasPolicy.class);
        interfaceAliasPolicyMapping.setSetMethodName("setInterfaceAliasPolicyForTopLink");
        interfaceAliasPolicyMapping.setGetMethodName("getInterfaceAliasPolicyForTopLink");
        interfaceAliasPolicyMapping.setXPath("interface-alias-policy");
        descriptor.addMapping((DatabaseMapping)interfaceAliasPolicyMapping);
        XMLCompositeObjectMapping multiTableInfoPolicyMapping = new XMLCompositeObjectMapping();
        multiTableInfoPolicyMapping.setAttributeName(MULTI_TABLE_INFO_POLICY_PROPERTY);
        multiTableInfoPolicyMapping.setReferenceClass(MWDescriptorMultiTableInfoPolicy.class);
        multiTableInfoPolicyMapping.setSetMethodName("setMultiTableInfoPolicyForTopLink");
        multiTableInfoPolicyMapping.setGetMethodName("getMultiTableInfoPolicyForTopLink");
        multiTableInfoPolicyMapping.setXPath("multi-table-info-policy");
        descriptor.addMapping((DatabaseMapping)multiTableInfoPolicyMapping);
        XMLCompositeObjectMapping returningPolicyMapping = new XMLCompositeObjectMapping();
        returningPolicyMapping.setAttributeName("returningPolicy");
        returningPolicyMapping.setReferenceClass(MWRelationalReturningPolicy.class);
        returningPolicyMapping.setSetMethodName("setReturningPolicyForTopLink");
        returningPolicyMapping.setGetMethodName("getReturningPolicyForTopLink");
        returningPolicyMapping.setXPath("returning-policy");
        descriptor.addMapping((DatabaseMapping)returningPolicyMapping);
        return descriptor;
    }

    private MWTableHandle getPrimaryTableHandleForTopLink() {
        return this.primaryTableHandle.getTable() == null ? null : this.primaryTableHandle;
    }

    private void setPrimaryTableHandleForTopLink(MWTableHandle handle) {
        MWHandle.NodeReferenceScrubber scrubber = this.buildPrimaryTableScrubber();
        this.primaryTableHandle = handle == null ? new MWTableHandle(this, scrubber) : handle.setScrubber(scrubber);
    }

    private MWTableHandle getSequenceNumberTableHandleForTopLink() {
        return this.sequenceNumberTableHandle.getTable() == null ? null : this.sequenceNumberTableHandle;
    }

    private void setSequenceNumberTableHandleForTopLink(MWTableHandle handle) {
        MWHandle.NodeReferenceScrubber scrubber = this.buildSequenceNumberTableScrubber();
        this.sequenceNumberTableHandle = handle == null ? new MWTableHandle(this, scrubber) : handle.setScrubber(scrubber);
    }

    private MWColumnHandle getSequenceNumberColumnHandleForTopLink() {
        return this.sequenceNumberColumnHandle.getColumn() == null ? null : this.sequenceNumberColumnHandle;
    }

    private void setSequenceNumberColumnHandleForTopLink(MWColumnHandle handle) {
        MWHandle.NodeReferenceScrubber scrubber = this.buildSequenceNumberColumnScrubber();
        this.sequenceNumberColumnHandle = handle == null ? new MWColumnHandle(this, scrubber) : handle.setScrubber(scrubber);
    }
}

