/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app.swing;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeListener;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class NumberSpinnerModelAdapter
extends SpinnerNumberModel {
    private Number defaultValue;
    protected PropertyValueModel numberHolder;
    private PropertyChangeListener numberChangeListener;

    public NumberSpinnerModelAdapter(PropertyValueModel numberHolder) {
        this(numberHolder, 0);
    }

    public NumberSpinnerModelAdapter(PropertyValueModel numberHolder, int defaultValue) {
        this(numberHolder, null, null, new Integer(1), new Integer(defaultValue));
    }

    public NumberSpinnerModelAdapter(PropertyValueModel numberHolder, int minimum, int maximum, int stepSize) {
        this(numberHolder, minimum, maximum, stepSize, minimum);
    }

    public NumberSpinnerModelAdapter(PropertyValueModel numberHolder, int minimum, int maximum, int stepSize, int defaultValue) {
        this(numberHolder, new Integer(minimum), new Integer(maximum), new Integer(stepSize), new Integer(defaultValue));
    }

    public NumberSpinnerModelAdapter(PropertyValueModel numberHolder, double value, double minimum, double maximum, double stepSize) {
        this(numberHolder, value, minimum, maximum, stepSize, minimum);
    }

    public NumberSpinnerModelAdapter(PropertyValueModel numberHolder, double value, double minimum, double maximum, double stepSize, double defaultValue) {
        this(numberHolder, new Double(minimum), new Double(maximum), new Double(stepSize), new Double(defaultValue));
    }

    public NumberSpinnerModelAdapter(PropertyValueModel numberHolder, Comparable minimum, Comparable maximum, Number stepSize, Number defaultValue) {
        super(numberHolder.getValue() == null ? (Number)defaultValue : (Number)((Number)numberHolder.getValue()), minimum, maximum, stepSize);
        this.numberHolder = numberHolder;
        this.numberChangeListener = this.buildNumberChangeListener();
        this.defaultValue = defaultValue;
    }

    private PropertyChangeListener buildNumberChangeListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                NumberSpinnerModelAdapter.this.synchronize(e.getNewValue());
            }

            public String toString() {
                return "number listener";
            }
        };
    }

    @Override
    public Object getValue() {
        if (this.getChangeListeners().length == 0) {
            super.setValue(this.spinnerValueOf(this.numberHolder.getValue()));
        }
        return super.getValue();
    }

    protected final Number getSuperValue() {
        return super.getNumber();
    }

    @Override
    public void setValue(Object value) {
        super.setValue(value);
        this.numberHolder.setValue(value);
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        if (this.getChangeListeners().length == 0) {
            this.numberHolder.addPropertyChangeListener("value", this.numberChangeListener);
            this.synchronize(this.numberHolder.getValue());
        }
        super.addChangeListener(listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        super.removeChangeListener(listener);
        if (this.getChangeListeners().length == 0) {
            this.numberHolder.removePropertyChangeListener("value", this.numberChangeListener);
        }
    }

    protected Number getDefaultValue() {
        return this.defaultValue;
    }

    protected void setDefaultValue(Number defaultValue) {
        this.defaultValue = defaultValue;
    }

    protected Object spinnerValueOf(Object value) {
        return value == null ? this.getDefaultValue() : value;
    }

    protected void synchronize(Object value) {
        Object newValue = this.spinnerValueOf(value);
        if (!this.getValue().equals(newValue)) {
            this.setValue(newValue);
        }
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)this.numberHolder);
    }
}

