/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemoveListPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemovePanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.DoubleClickMouseListener;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWAttributeItem;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWQueryFormat;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWQueryItem;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWRelationalQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWRelationalSpecificQueryOptions;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.AttributeItemDialog;
import org.eclipse.persistence.tools.workbench.uitools.ComponentEnabler;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleListCellRenderer;

abstract class AbstractAttributeItemsPanel
extends AbstractPanel {
    private PropertyValueModel queryHolder;
    private AddRemovePanel attributesPanel;

    AbstractAttributeItemsPanel(PropertyValueModel queryHolder, WorkbenchContextHolder contextHolder) {
        super(contextHolder);
        this.queryHolder = this.buildQueryHolder(queryHolder);
        this.initializeLayout();
    }

    protected PropertyValueModel buildQueryHolder(PropertyValueModel queryHolder) {
        return queryHolder;
    }

    protected abstract String helpTopicId();

    private void initializeLayout() {
        GridBagConstraints constraints = new GridBagConstraints();
        this.attributesPanel = this.buildAddRemovePanel();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.attributesPanel, constraints);
        ArrayList<JComponent> components = new ArrayList<JComponent>();
        components.add(this.attributesPanel.getComponent());
        components.add(this.attributesPanel);
        new ComponentEnabler(this.buildAttributesEnabler(), components);
    }

    private ValueModel buildAttributesEnabler() {
        return new PropertyAspectAdapter(this.buildRelationalSpecificOptionsHolder(), "queryFormatType"){

            @Override
            protected Object getValueFromSubject() {
                return AbstractAttributeItemsPanel.this.panelEnabled(((MWRelationalSpecificQueryOptions)this.subject).getQueryFormat());
            }
        };
    }

    private PropertyValueModel buildRelationalSpecificOptionsHolder() {
        return new PropertyAspectAdapter(this.queryHolder){

            @Override
            protected Object getValueFromSubject() {
                return ((MWRelationalQuery)this.subject).getRelationalOptions();
            }
        };
    }

    protected abstract boolean panelEnabled(MWQueryFormat var1);

    protected AddRemovePanel buildAddRemovePanel() {
        AddRemoveListPanel panel = new AddRemoveListPanel(this.getApplicationContext(), (AddRemovePanel.Adapter)this.buildAttributesPanelAdapter(), this.buildAttributesHolder(), 3, this.resourceRepository().getString(this.listTitleKey()));
        panel.setBorder(this.buildTitledBorder(this.listTitleKey()));
        panel.setCellRenderer(this.buildQueryItemCellRenderer());
        SwingComponentFactory.addDoubleClickMouseListener(panel.getComponent(), new DoubleClickMouseListener(){

            @Override
            public void mouseDoubleClicked(MouseEvent e) {
                AbstractAttributeItemsPanel.this.editSelectedAttribute((MWAttributeItem)AbstractAttributeItemsPanel.this.attributesPanel.getSelectionModel().getSelectedValue());
            }
        });
        this.addHelpTopicId(panel, this.helpTopicId());
        return panel;
    }

    void editSelectedAttribute(MWAttributeItem item) {
        AttributeItemDialog dialog = this.buildAttributeItemDialog(item);
        dialog.show();
    }

    abstract AttributeItemDialog buildAttributeItemDialog(MWAttributeItem var1);

    abstract String listTitleKey();

    abstract AddRemovePanel.UpDownOptionAdapter buildAttributesPanelAdapter();

    protected abstract ListValueModel buildAttributesHolder();

    private ListCellRenderer buildQueryItemCellRenderer() {
        return new SimpleListCellRenderer(){

            @Override
            protected String buildText(Object value) {
                return ((MWAttributeItem)value).displayString();
            }
        };
    }

    protected PropertyValueModel getQueryHolder() {
        return this.queryHolder;
    }

    protected MWQuery getQuery() {
        return (MWQuery)this.queryHolder.getValue();
    }

    protected void select(MWQueryItem queryItem) {
        this.attributesPanel.setSelectedValue(queryItem, true);
    }
}

