/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.AccessibleTitledBorder;
import org.eclipse.persistence.tools.workbench.framework.uitools.AccessibleTitledPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingTools;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWClassIndicatorExtractionMethodPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWClassIndicatorFieldPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorInheritancePolicy;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.ClassExtractionMethodPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.ExtractionMethodListener;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.IndicatorDictionaryListener;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.IndicatorFieldListener;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.RootListener;
import org.eclipse.persistence.tools.workbench.uitools.app.FilteringPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.RadioButtonModelAdapter;

public abstract class ClassIndicatorPolicySubPanel
extends AbstractPanel
implements RootListener,
IndicatorFieldListener {
    private ValueModel descriptorHolder;
    private ValueModel inheritancePolicyHolder;
    private PropertyValueModel classIndicatorPolicyHolder;
    private PropertyValueModel classIndicatorFieldPolicyHolder;
    private PropertyValueModel useNameModel;
    private boolean isRoot;
    private boolean isIndicatorField;
    private PropertyValueModel policyTypeModel;
    private JRadioButton useClassExtractionMethodRadioButton;
    protected JRadioButton useClassIndicatorFieldRadioButton;
    protected JRadioButton useClassNameAsIndicatorRadioButton;
    protected JRadioButton useClassIndicatorDictionaryRadioButton;

    protected ClassIndicatorPolicySubPanel(PropertyValueModel descriptorHolder, PropertyValueModel inheritancePolicyHolder, WorkbenchContextHolder contextHolder, Collection isRootListeners) {
        super(contextHolder);
        this.initialize(descriptorHolder, inheritancePolicyHolder, isRootListeners);
    }

    protected void initialize(PropertyValueModel descHolder, PropertyValueModel inheritancePolicyHolder, Collection isRootListeners) {
        this.descriptorHolder = descHolder;
        this.inheritancePolicyHolder = inheritancePolicyHolder;
        this.classIndicatorPolicyHolder = this.buildClassIndicatorPolicyHolder();
        this.classIndicatorFieldPolicyHolder = this.buildClassIndicatorFieldPolicyHolder();
        this.useNameModel = this.buildUseClassNameAsIndicatorHolder();
        this.policyTypeModel = this.buildClassIndicatorPolicyTypeAdapter();
        this.initializeLayout(isRootListeners);
    }

    protected abstract void initializeLayout(Collection var1);

    @Override
    public void updateRootStatus(boolean newValue) {
        this.isRoot = newValue;
        this.updateEnablementStatus();
    }

    @Override
    public void updateIndicatorFieldStatus(boolean newValue) {
        this.isIndicatorField = newValue;
        this.updateEnablementStatus();
    }

    protected void addExtractionMethodListener(final ExtractionMethodListener listener) {
        this.getPolicyTypeModel().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                boolean enabled = evt.getNewValue() == "classExtractionMethodClassIndicatorPolicy";
                listener.updateExtractionMethodStatus(enabled);
            }
        });
        listener.updateExtractionMethodStatus(this.getPolicyTypeModel().getValue() == "classExtractionMethodClassIndicatorPolicy");
    }

    protected void addIndicatorFieldListener(final IndicatorFieldListener listener) {
        this.getPolicyTypeModel().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                boolean enabled = evt.getNewValue() == "fieldClassIndicatorPolicy";
                listener.updateIndicatorFieldStatus(enabled);
            }
        });
        listener.updateIndicatorFieldStatus(this.getPolicyTypeModel().getValue() == "fieldClassIndicatorPolicy");
    }

    protected void addIndicatorDictionaryListener(final IndicatorDictionaryListener listener) {
        this.getUseNameModel().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                boolean enabled = evt.getNewValue() == Boolean.FALSE;
                listener.updateIndicatorDictionaryStatus(enabled);
            }
        });
    }

    protected void updateEnablementStatus() {
        this.useClassIndicatorFieldRadioButton.setEnabled(this.isRoot());
        this.useClassExtractionMethodRadioButton.setEnabled(this.isRoot());
        this.useClassNameAsIndicatorRadioButton.setEnabled(this.isRoot() && this.isIndicatorType());
        this.useClassIndicatorDictionaryRadioButton.setEnabled(this.isRoot() && this.isIndicatorType());
    }

    protected PropertyValueModel buildClassIndicatorPolicyHolder() {
        return new PropertyAspectAdapter(this.inheritancePolicyHolder, "classIndicatorPolicy"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWDescriptorInheritancePolicy)this.subject).getClassIndicatorPolicy();
            }
        };
    }

    private PropertyValueModel buildClassIndicatorPolicyTypeAdapter() {
        return new PropertyAspectAdapter(this.inheritancePolicyHolder, "classIndicatorPolicy"){

            @Override
            protected Object getValueFromSubject() {
                if (((MWDescriptorInheritancePolicy)this.subject).getClassIndicatorPolicy() == null) {
                    return null;
                }
                return ((MWDescriptorInheritancePolicy)this.subject).getClassIndicatorPolicy().getType();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                if ((String)value == "classExtractionMethodClassIndicatorPolicy") {
                    ((MWDescriptorInheritancePolicy)this.subject).useClassExtractionMethodIndicatorPolicy();
                } else if ((String)value == "fieldClassIndicatorPolicy") {
                    ((MWDescriptorInheritancePolicy)this.subject).useClassIndicatorFieldPolicy();
                }
            }
        };
    }

    private PropertyValueModel buildUseClassNameAsIndicatorHolder() {
        return new PropertyAspectAdapter(this.getClassIndicatorFieldPolicyHolder(), "classNameIsIndicator"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWClassIndicatorFieldPolicy)this.subject).classNameIsIndicator();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((MWClassIndicatorFieldPolicy)this.subject).setClassNameIsIndicator(((Boolean)value).booleanValue());
            }
        };
    }

    protected RadioButtonModelAdapter buildClassNameAsIndicatorRadioButtonModel(PropertyValueModel useNameHolder) {
        return new RadioButtonModelAdapter(useNameHolder, Boolean.TRUE);
    }

    protected RadioButtonModelAdapter buildClassIndicatorDictionaryRadioButtonModel(PropertyValueModel useNameHolder) {
        return new RadioButtonModelAdapter(useNameHolder, Boolean.FALSE);
    }

    protected RadioButtonModelAdapter buildClassIndicatorPolicyRadioButtonModel(String classIndicatorPolicyType) {
        return new RadioButtonModelAdapter(this.policyTypeModel, classIndicatorPolicyType);
    }

    protected JPanel buildUseClassExtractionMethodPanel(Collection isRootListeners) {
        GridBagConstraints constraints = new GridBagConstraints();
        AccessibleTitledPanel useClassExtractionMethodPanel = new AccessibleTitledPanel(new GridBagLayout());
        this.useClassExtractionMethodRadioButton = this.buildRadioButton("USE_CLASS_EXTRACTION_METHOD", this.buildClassIndicatorPolicyRadioButtonModel("classExtractionMethodClassIndicatorPolicy"));
        useClassExtractionMethodPanel.setEnabled(this.isRoot());
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        useClassExtractionMethodPanel.add((Component)this.useClassExtractionMethodRadioButton, constraints);
        ClassExtractionMethodPanel extractionMethodPanel = new ClassExtractionMethodPanel(this.getApplicationContext(), this.buildClassExtractionMethodIndirectionPolicyHolder());
        isRootListeners.add(extractionMethodPanel);
        this.addExtractionMethodListener(extractionMethodPanel);
        extractionMethodPanel.setBorder(new AccessibleTitledBorder(this.useClassExtractionMethodRadioButton.getText()));
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, SwingTools.checkBoxIconWidth(), 0, 0);
        useClassExtractionMethodPanel.add((Component)extractionMethodPanel, constraints);
        this.addHelpTopicId(useClassExtractionMethodPanel, this.helpTopicId() + ".useClassExtraction");
        return useClassExtractionMethodPanel;
    }

    private PropertyValueModel buildClassExtractionMethodIndirectionPolicyHolder() {
        return new FilteringPropertyValueModel(this.classIndicatorPolicyHolder){

            @Override
            protected boolean accept(Object value) {
                return value instanceof MWClassIndicatorExtractionMethodPolicy;
            }
        };
    }

    private PropertyValueModel buildClassIndicatorFieldPolicyHolder() {
        return new FilteringPropertyValueModel(this.classIndicatorPolicyHolder){

            @Override
            protected boolean accept(Object value) {
                return value instanceof MWClassIndicatorFieldPolicy;
            }
        };
    }

    protected String helpTopicId() {
        return "descriptor.inheritance.classIndicator";
    }

    protected PropertyValueModel getUseNameModel() {
        return this.useNameModel;
    }

    protected PropertyValueModel getPolicyTypeModel() {
        return this.policyTypeModel;
    }

    protected PropertyValueModel getClassIndicatorPolicyHolder() {
        return this.classIndicatorPolicyHolder;
    }

    protected PropertyValueModel getClassIndicatorFieldPolicyHolder() {
        return this.classIndicatorFieldPolicyHolder;
    }

    protected ValueModel getDescriptorHolder() {
        return this.descriptorHolder;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public boolean isIndicatorType() {
        return this.isIndicatorField;
    }
}

