/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.ui.chooser;

import java.text.CollationKey;
import java.util.Collection;
import javax.swing.Icon;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassDescriptionAdapter;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassDescriptionNodeContainer;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassDescriptionPackageNode;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassDescriptionPackagePoolNode;
import org.eclipse.persistence.tools.workbench.uitools.Displayable;
import org.eclipse.persistence.tools.workbench.uitools.app.AbstractTreeNodeValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.NullListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TreeNodeValueModel;

public final class ClassDescriptionNode
extends AbstractTreeNodeValueModel
implements Displayable,
ClassDescriptionNodeContainer {
    private ClassDescriptionPackageNode packageNode;
    private Object userClassDescription;
    private String packageName;
    private String shortClassName;
    private String additionalInfo;
    private CollationKey collationKey;

    ClassDescriptionNode(Object userClassDescription, ClassDescriptionAdapter adapter) {
        this.userClassDescription = userClassDescription;
        this.packageName = adapter.packageName(userClassDescription);
        this.shortClassName = adapter.shortClassName(userClassDescription).replace('$', '.');
        this.additionalInfo = adapter.additionalInfo(userClassDescription);
    }

    ClassDescriptionPackageNode getPackageNode() {
        return this.packageNode;
    }

    void setPackageNode(ClassDescriptionPackageNode packageNode) {
        if (this.packageNode == null) {
            this.collationKey = packageNode.collator().getCollationKey(this.shortClassName);
        }
        this.packageNode = packageNode;
    }

    public Object getUserClassDescription() {
        return this.userClassDescription;
    }

    String getPackageName() {
        return this.packageName;
    }

    String getShortClassName() {
        return this.shortClassName;
    }

    String getAdditionalInfo() {
        return this.additionalInfo;
    }

    boolean belongsInPackageNode(ClassDescriptionPackageNode pkgNode) {
        if (!this.packageName.equals(pkgNode.getName())) {
            return false;
        }
        return this.valuesAreEqual(this.additionalInfo, pkgNode.getAdditionalInfo());
    }

    ClassDescriptionPackageNode buildPackageNode(ClassDescriptionPackagePoolNode projectNode) {
        ClassDescriptionPackageNode pkgNode = new ClassDescriptionPackageNode(projectNode, this.packageName, this.additionalInfo);
        if (this.packageNode != null) {
            pkgNode.setDisplaysAdditionalInfo(this.packageNode.displaysAdditionalInfo());
        }
        return pkgNode;
    }

    @Override
    public Object getValue() {
        return this.userClassDescription;
    }

    @Override
    public TreeNodeValueModel getParent() {
        return this.packageNode;
    }

    @Override
    public ListValueModel getChildrenModel() {
        return NullListValueModel.instance();
    }

    @Override
    protected void engageValue() {
    }

    @Override
    protected void disengageValue() {
    }

    @Override
    public void addClassDescriptionNodesTo(Collection classDescriptionNodes) {
        classDescriptionNodes.add(this);
    }

    public int compareTo(Object o) {
        return this.collationKey.compareTo(((ClassDescriptionNode)o).collationKey);
    }

    @Override
    public String displayString() {
        return this.shortClassName;
    }

    @Override
    public Icon icon() {
        return this.packageNode.classIcon();
    }

    @Override
    public void toString(StringBuffer sb) {
        sb.append(this.shortClassName);
    }
}

