/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.internal;

import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileSystemView;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.internal.FrameworkNodeManager;

final class OpenAction
extends AbstractFrameworkAction {
    private static final String MOST_RECENT_OPEN_LOCATION_PREFERENCE = "recent open location";
    private static final String MOST_RECENT_OPEN_LOCATION_PREFERENCE_DEFAULT = FileSystemView.getFileSystemView().getDefaultDirectory().getAbsolutePath();
    private FrameworkNodeManager nodeManager;

    OpenAction(WorkbenchContext context, FrameworkNodeManager nodeManager) {
        super(context);
        this.nodeManager = nodeManager;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.initializeTextAndMnemonic("file.open");
        this.initializeIcon("file.open");
        this.initializeToolTipText("file.open.toolTipText");
        this.initializeAccelerator("file.open.ACCELERATOR");
    }

    @Override
    protected void execute() {
        File file = this.promptUserForFile();
        if (file != null) {
            this.preferences().node("general").put(MOST_RECENT_OPEN_LOCATION_PREFERENCE, file.getAbsolutePath());
            this.nodeManager.open(file, this.getWorkbenchContext());
        }
    }

    private File promptUserForFile() {
        String mostRecentOpenFile = this.preferences().node("general").get(MOST_RECENT_OPEN_LOCATION_PREFERENCE, MOST_RECENT_OPEN_LOCATION_PREFERENCE_DEFAULT);
        JFileChooser fileChooser = new JFileChooser(new File(mostRecentOpenFile));
        int status = fileChooser.showOpenDialog(this.currentWindow());
        if (status == 0) {
            return fileChooser.getSelectedFile();
        }
        return null;
    }
}

