/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.framework;

import java.lang.reflect.Field;
import sun.misc.Unsafe;

public class ReflectionHelper {
    private static final Unsafe unsafe;

    public static final void setPrivateStatic(Class c, String name, Object newValue) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Field field = c.getDeclaredField(name);
        boolean accessible = field.isAccessible();
        field.setAccessible(true);
        field.set(null, newValue);
        field.setAccessible(accessible);
    }

    public static final void setPrivateStaticFinal(Class c, String name, Object newValue) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Field field = c.getDeclaredField(name);
        Object base = unsafe.staticFieldBase(field);
        long offset = unsafe.staticFieldOffset(field);
        unsafe.putObject(base, offset, newValue);
    }

    public static final Object getPrivateStatic(Class c, String name) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Field field = c.getDeclaredField(name);
        boolean accessible = field.isAccessible();
        field.setAccessible(true);
        Object value = field.get(null);
        field.setAccessible(accessible);
        return value;
    }

    static {
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            unsafe = (Unsafe)field.get(null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

