/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.simultaneous;

import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.DescriptorQueryManager;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.simultaneous.MultithreadTestCase;

public class DescriptorQueryManagerMultithreadedTest
extends MultithreadTestCase {
    protected Vector queries = null;
    public static final String QUERY_STRING = "TestQuery";

    public DescriptorQueryManagerMultithreadedTest() {
        this.setDescription("Tests adding queris to a DescriptorQueryManager with multiple simultaneous threads");
        Vector<DescriptorQueryManagerAddQueryTest> tests = new Vector<DescriptorQueryManagerAddQueryTest>();
        tests.add(new DescriptorQueryManagerAddQueryTest());
        tests.add(new DescriptorQueryManagerAddQueryTest());
        tests.add(new DescriptorQueryManagerAddQueryTest());
        tests.add(new DescriptorQueryManagerAddQueryTest());
        tests.add(new DescriptorQueryManagerAddQueryTest());
        tests.add(new DescriptorQueryManagerAddQueryTest());
        tests.add(new DescriptorQueryManagerAddQueryTest());
        tests.add(new DescriptorQueryManagerAddQueryTest());
        tests.add(new DescriptorQueryManagerAddQueryTest());
        tests.add(new DescriptorQueryManagerAddQueryTest());
        this.setTests(tests);
    }

    @Override
    public void setup() {
        super.setup();
        ClassDescriptor descriptor = this.getSession().getClassDescriptor(Employee.class);
        Map queryTable = descriptor.getQueryManager().getQueries();
        if (queryTable != null) {
            this.queries = (Vector)queryTable.get(QUERY_STRING);
        }
    }

    @Override
    public void reset() {
        super.reset();
        DescriptorQueryManager queryManager = this.getSession().getDescriptor(Employee.class).getQueryManager();
        queryManager.removeQuery(QUERY_STRING);
        if (this.queries != null) {
            Enumeration enumtr = this.queries.elements();
            while (enumtr.hasMoreElements()) {
                queryManager.addQuery((DatabaseQuery)enumtr.nextElement());
            }
        }
    }

    public class DescriptorQueryManagerAddQueryTest
    extends AutoVerifyTestCase {
        protected DescriptorQueryManager queryManager = null;

        public DescriptorQueryManagerAddQueryTest() {
            this.setDescription("Ensure DescriptorQueryManager works well with concurrent getQuery() and addQuery()");
        }

        public void test() {
            this.queryManager = this.getSession().getDescriptor(Employee.class).getQueryManager();
            ReadObjectQuery query = (ReadObjectQuery)this.queryManager.getQuery(DescriptorQueryManagerMultithreadedTest.QUERY_STRING);
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (query == null) {
                ExpressionBuilder bld = new ExpressionBuilder();
                Expression exp = bld.get("firstName").equal(bld.getParameter("myFirstName"));
                query = new ReadObjectQuery(Employee.class, exp);
                query.addArgument("myFirstName");
                this.queryManager.addQuery(DescriptorQueryManagerMultithreadedTest.QUERY_STRING, (DatabaseQuery)query);
            }
        }

        public void verify() {
            if (this.queryManager.getQuery(DescriptorQueryManagerMultithreadedTest.QUERY_STRING) == null) {
                throw new TestErrorException("QueryManager.addQuery() is having concurrency problems.");
            }
        }
    }
}

