/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.inheritance;

import java.io.CharArrayWriter;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.InheritancePolicy;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.inheritance.Vehicle;

public class SingleInheritanceTest
extends TestCase {
    protected InheritancePolicy originalInheritancePolicy;
    protected DatabaseMapping originalDbMapping;
    protected Map originalDescriptors;
    protected ClassDescriptor vehicleDescriptor;
    protected Writer originalLogWriter;

    public SingleInheritanceTest() {
        this.setDescription("The test uses inheritance on a single class w/ no subclasses and calls printIdentityMaps on the session");
    }

    public void reset() {
        this.getSession().getProject().setDescriptors(this.originalDescriptors);
        this.getAbstractSession().clearDescriptors();
        this.vehicleDescriptor.setInheritancePolicy(this.originalInheritancePolicy);
        this.vehicleDescriptor.addMapping(this.originalDbMapping);
        this.getSession().setLog(this.originalLogWriter);
    }

    protected void setup() {
        this.originalLogWriter = this.getSession().getLog();
        this.getSession().setLog((Writer)new CharArrayWriter());
        this.vehicleDescriptor = this.getSession().getDescriptor(Vehicle.class);
        this.originalDescriptors = this.getSession().getProject().getDescriptors();
        this.originalInheritancePolicy = this.vehicleDescriptor.getInheritancePolicy();
        this.originalDbMapping = this.vehicleDescriptor.getMappingForAttributeName("owner");
        this.vehicleDescriptor.getMappings().remove(this.originalDbMapping);
        InheritancePolicy newInheritancePolicy = (InheritancePolicy)this.originalInheritancePolicy.clone();
        newInheritancePolicy.addClassIndicator(Vehicle.class, (Object)new Long(8L));
        newInheritancePolicy.setChildDescriptors(new Vector());
        newInheritancePolicy.setClassIndicatorMapping(new Hashtable(3));
        this.vehicleDescriptor.setInheritancePolicy(newInheritancePolicy);
        this.getSession().getProject().setDescriptors(new Hashtable(3));
        this.getSession().getProject().addDescriptor(this.vehicleDescriptor);
    }

    public void test() {
    }

    protected void verify() {
        try {
            ((AbstractSession)this.getSession()).getIdentityMapAccessorInstance().printIdentityMaps();
            return;
        }
        catch (NoSuchElementException e) {
            throw new TestErrorException("Single class inheritance (no subclasses) caused a java.util.NoSuchElementException when printIdentityMaps() was called on the session");
        }
    }
}

