/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.advanced;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.testing.framework.QuerySQLTracker;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.advanced.Address;
import org.eclipse.persistence.testing.models.jpa.advanced.AdvancedTableCreator;
import org.eclipse.persistence.testing.models.jpa.advanced.EmployeePopulator;

public class OptimisticLockForceIncrementTestSuite
extends JUnitTestCase {
    public OptimisticLockForceIncrementTestSuite() {
    }

    public OptimisticLockForceIncrementTestSuite(String name) {
        super(name);
    }

    public static TestSuite suite() {
        TestSuite suite = new TestSuite("OptimisticLockForceIncrementTestSuite");
        suite.addTest((Test)new OptimisticLockForceIncrementTestSuite("testSetup"));
        suite.addTest((Test)new OptimisticLockForceIncrementTestSuite("testVersionIncrementNoChanges"));
        suite.addTest((Test)new OptimisticLockForceIncrementTestSuite("testVersionIncrementPreFlushChanges"));
        suite.addTest((Test)new OptimisticLockForceIncrementTestSuite("testVersionIncrementPostFlushChanges"));
        suite.addTest((Test)new OptimisticLockForceIncrementTestSuite("testVersionIncrementPreAndPostFlushChanges"));
        suite.addTest((Test)new OptimisticLockForceIncrementTestSuite("testVersionIncrementCommitNoChanges"));
        suite.addTest((Test)new OptimisticLockForceIncrementTestSuite("testVersionIncrementPreCommitChanges"));
        suite.addTest((Test)new OptimisticLockForceIncrementTestSuite("testVersionIncrementFlushCommitNoChanges"));
        suite.addTest((Test)new OptimisticLockForceIncrementTestSuite("testVersionIncrementMultipleEntities"));
        suite.addTest((Test)new OptimisticLockForceIncrementTestSuite("testVersionIncrementBasicPromoteLock"));
        suite.addTest((Test)new OptimisticLockForceIncrementTestSuite("testVersionIncrementPromoteLock"));
        return suite;
    }

    public void testSetup() {
        new AdvancedTableCreator().replaceTables((DatabaseSession)JUnitTestCase.getServerSession());
        EmployeePopulator employeePopulator = new EmployeePopulator();
        employeePopulator.buildExamples();
        employeePopulator.persistExample((Session)JUnitTestCase.getServerSession());
        this.clearCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testVersionIncrementNoChanges() {
        if (OptimisticLockForceIncrementTestSuite.usesSOP()) {
            return;
        }
        QuerySQLTracker counter = null;
        try {
            counter = new QuerySQLTracker((Session)OptimisticLockForceIncrementTestSuite.getServerSession());
            EntityManager em = this.getEntityManagerFactory().createEntityManager();
            em.getTransaction().begin();
            List addresses = em.createQuery("select a from Address a").getResultList();
            OptimisticLockForceIncrementTestSuite.assertNotNull((String)"Null query results returned", (Object)addresses);
            OptimisticLockForceIncrementTestSuite.assertNotSame((String)"No query results returned", (Object)addresses.size(), (Object)0);
            Address entity = (Address)addresses.get(0);
            OptimisticLockForceIncrementTestSuite.assertNotNull((String)"Entity: Address cannot be null", (Object)entity);
            counter.getSqlStatements().clear();
            int startVersion = entity.getVersion();
            em.lock((Object)entity, LockModeType.OPTIMISTIC_FORCE_INCREMENT);
            em.flush();
            em.getTransaction().commit();
            int expectedVersion = startVersion + 1;
            int actualVersion = entity.getVersion();
            em.close();
            OptimisticLockForceIncrementTestSuite.assertEquals((String)"Version number incremented incorrectly: ", (int)expectedVersion, (int)actualVersion);
            OptimisticLockForceIncrementTestSuite.assertEquals((String)"1 SQL update statement execution(s)", (int)1, (int)this.countNumberOfUpdateStatements(counter));
        }
        finally {
            if (counter != null) {
                counter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testVersionIncrementPreFlushChanges() {
        if (OptimisticLockForceIncrementTestSuite.usesSOP()) {
            return;
        }
        QuerySQLTracker counter = null;
        try {
            counter = new QuerySQLTracker((Session)OptimisticLockForceIncrementTestSuite.getServerSession());
            EntityManager em = this.getEntityManagerFactory().createEntityManager();
            em.getTransaction().begin();
            List addresses = em.createQuery("select a from Address a").getResultList();
            counter.getSqlStatements().clear();
            OptimisticLockForceIncrementTestSuite.assertNotNull((String)"Null query results returned", (Object)addresses);
            OptimisticLockForceIncrementTestSuite.assertNotSame((String)"No query results returned", (Object)addresses.size(), (Object)0);
            Address entity = (Address)addresses.get(0);
            OptimisticLockForceIncrementTestSuite.assertNotNull((String)"Entity: Address cannot be null", (Object)entity);
            int startVersion = entity.getVersion();
            em.lock((Object)entity, LockModeType.OPTIMISTIC_FORCE_INCREMENT);
            entity.setCity("Vancouver");
            entity.setProvince("BC");
            entity.setCountry("Canada");
            em.flush();
            em.getTransaction().commit();
            int expectedVersion = startVersion + 1;
            int actualVersion = entity.getVersion();
            em.close();
            OptimisticLockForceIncrementTestSuite.assertEquals((String)"Version number incremented incorrectly: ", (int)expectedVersion, (int)actualVersion);
            OptimisticLockForceIncrementTestSuite.assertEquals((String)"Entity's name should be changed", (String)"Vancouver", (String)entity.getCity());
            OptimisticLockForceIncrementTestSuite.assertEquals((String)"1 SQL update statement execution(s)", (int)1, (int)this.countNumberOfUpdateStatements(counter));
        }
        finally {
            if (counter != null) {
                counter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testVersionIncrementPostFlushChanges() {
        QuerySQLTracker counter = null;
        try {
            counter = new QuerySQLTracker((Session)OptimisticLockForceIncrementTestSuite.getServerSession());
            EntityManager em = this.getEntityManagerFactory().createEntityManager();
            em.getTransaction().begin();
            List addresses = em.createQuery("select a from Address a").getResultList();
            counter.getSqlStatements().clear();
            OptimisticLockForceIncrementTestSuite.assertNotNull((String)"Null query results returned", (Object)addresses);
            OptimisticLockForceIncrementTestSuite.assertNotSame((String)"No query results returned", (Object)addresses.size(), (Object)0);
            Address entity = (Address)addresses.get(0);
            OptimisticLockForceIncrementTestSuite.assertNotNull((String)"Entity: Address cannot be null", (Object)entity);
            int startVersion = entity.getVersion();
            em.lock((Object)entity, LockModeType.OPTIMISTIC_FORCE_INCREMENT);
            em.flush();
            entity.setCity("Toronto");
            entity.setProvince("ON");
            entity.setCountry("Canada");
            em.getTransaction().commit();
            int expectedVersion = startVersion + 1;
            int actualVersion = entity.getVersion();
            em.close();
            OptimisticLockForceIncrementTestSuite.assertEquals((String)"Version number incremented incorrectly: ", (int)expectedVersion, (int)actualVersion);
            OptimisticLockForceIncrementTestSuite.assertEquals((String)"Entity's name should be changed", (String)"Toronto", (String)entity.getCity());
            OptimisticLockForceIncrementTestSuite.assertEquals((String)"2 SQL update statement execution(s)", (int)2, (int)this.countNumberOfUpdateStatements(counter));
        }
        finally {
            if (counter != null) {
                counter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testVersionIncrementPreAndPostFlushChanges() {
        QuerySQLTracker counter = null;
        try {
            counter = new QuerySQLTracker((Session)OptimisticLockForceIncrementTestSuite.getServerSession());
            EntityManager em = this.getEntityManagerFactory().createEntityManager();
            em.getTransaction().begin();
            List addresses = em.createQuery("select a from Address a").getResultList();
            counter.getSqlStatements().clear();
            OptimisticLockForceIncrementTestSuite.assertNotNull((String)"Null query results returned", (Object)addresses);
            OptimisticLockForceIncrementTestSuite.assertNotSame((String)"No query results returned", (Object)addresses.size(), (Object)0);
            Address entity = (Address)addresses.get(0);
            OptimisticLockForceIncrementTestSuite.assertNotNull((String)"Entity: Address cannot be null", (Object)entity);
            int startVersion = entity.getVersion();
            em.lock((Object)entity, LockModeType.OPTIMISTIC_FORCE_INCREMENT);
            entity.setCity("Moncton");
            entity.setProvince("NB");
            entity.setCountry("Canada");
            em.flush();
            entity.setCity("Halifax");
            entity.setProvince("NS");
            entity.setCountry("Canada");
            em.getTransaction().commit();
            int expectedVersion = startVersion + 1;
            int actualVersion = entity.getVersion();
            em.close();
            OptimisticLockForceIncrementTestSuite.assertEquals((String)"Version number incremented incorrectly: ", (int)expectedVersion, (int)actualVersion);
            OptimisticLockForceIncrementTestSuite.assertEquals((String)"Entity's name should be changed", (String)"Halifax", (String)entity.getCity());
            OptimisticLockForceIncrementTestSuite.assertEquals((String)"2 SQL update statement execution(s)", (int)2, (int)this.countNumberOfUpdateStatements(counter));
        }
        finally {
            if (counter != null) {
                counter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testVersionIncrementCommitNoChanges() {
        QuerySQLTracker counter = null;
        try {
            counter = new QuerySQLTracker((Session)OptimisticLockForceIncrementTestSuite.getServerSession());
            EntityManager em = this.getEntityManagerFactory().createEntityManager();
            em.getTransaction().begin();
            List addresses = em.createQuery("select a from Address a").getResultList();
            counter.getSqlStatements().clear();
            OptimisticLockForceIncrementTestSuite.assertNotNull((String)"Null query results returned", (Object)addresses);
            OptimisticLockForceIncrementTestSuite.assertNotSame((String)"No query results returned", (Object)addresses.size(), (Object)0);
            Address entity = (Address)addresses.get(0);
            OptimisticLockForceIncrementTestSuite.assertNotNull((String)"Entity: Address cannot be null", (Object)entity);
            int startVersion = entity.getVersion();
            em.lock((Object)entity, LockModeType.OPTIMISTIC_FORCE_INCREMENT);
            em.getTransaction().commit();
            int expectedVersion = startVersion + 1;
            int actualVersion = entity.getVersion();
            em.close();
            OptimisticLockForceIncrementTestSuite.assertEquals((String)"Version number incremented incorrectly: ", (int)expectedVersion, (int)actualVersion);
            OptimisticLockForceIncrementTestSuite.assertEquals((String)"1 SQL update statement execution(s)", (int)1, (int)this.countNumberOfUpdateStatements(counter));
        }
        finally {
            if (counter != null) {
                counter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testVersionIncrementPreCommitChanges() {
        QuerySQLTracker counter = null;
        try {
            counter = new QuerySQLTracker((Session)OptimisticLockForceIncrementTestSuite.getServerSession());
            EntityManager em = this.getEntityManagerFactory().createEntityManager();
            em.getTransaction().begin();
            List addresses = em.createQuery("select a from Address a").getResultList();
            counter.getSqlStatements().clear();
            OptimisticLockForceIncrementTestSuite.assertNotNull((String)"Null query results returned", (Object)addresses);
            OptimisticLockForceIncrementTestSuite.assertNotSame((String)"No query results returned", (Object)addresses.size(), (Object)0);
            Address entity = (Address)addresses.get(0);
            OptimisticLockForceIncrementTestSuite.assertNotNull((String)"Entity: Address cannot be null", (Object)entity);
            int startVersion = entity.getVersion();
            em.lock((Object)entity, LockModeType.OPTIMISTIC_FORCE_INCREMENT);
            entity.setCity("Calgary");
            entity.setProvince("AB");
            entity.setCountry("Canada");
            em.getTransaction().commit();
            int expectedVersion = startVersion + 1;
            int actualVersion = entity.getVersion();
            em.close();
            OptimisticLockForceIncrementTestSuite.assertEquals((String)"Version number incremented incorrectly: ", (int)expectedVersion, (int)actualVersion);
            OptimisticLockForceIncrementTestSuite.assertEquals((String)"Entity's name should be changed", (String)"Calgary", (String)entity.getCity());
            OptimisticLockForceIncrementTestSuite.assertEquals((String)"1 SQL update statement execution(s)", (int)1, (int)this.countNumberOfUpdateStatements(counter));
        }
        finally {
            if (counter != null) {
                counter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testVersionIncrementFlushCommitNoChanges() {
        if (OptimisticLockForceIncrementTestSuite.usesSOP()) {
            return;
        }
        QuerySQLTracker counter = null;
        try {
            counter = new QuerySQLTracker((Session)OptimisticLockForceIncrementTestSuite.getServerSession());
            EntityManager em = this.getEntityManagerFactory().createEntityManager();
            em.getTransaction().begin();
            List addresses = em.createQuery("select a from Address a").getResultList();
            counter.getSqlStatements().clear();
            OptimisticLockForceIncrementTestSuite.assertNotNull((String)"Null query results returned", (Object)addresses);
            OptimisticLockForceIncrementTestSuite.assertNotSame((String)"No query results returned", (Object)addresses.size(), (Object)0);
            Address entity = (Address)addresses.get(0);
            OptimisticLockForceIncrementTestSuite.assertNotNull((String)"Entity: Address cannot be null", (Object)entity);
            int startVersion = entity.getVersion();
            em.lock((Object)entity, LockModeType.OPTIMISTIC_FORCE_INCREMENT);
            em.flush();
            em.getTransaction().commit();
            int expectedVersion = startVersion + 1;
            int actualVersion = entity.getVersion();
            em.close();
            OptimisticLockForceIncrementTestSuite.assertEquals((String)"Version number incremented incorrectly: ", (int)expectedVersion, (int)actualVersion);
            OptimisticLockForceIncrementTestSuite.assertEquals((String)"1 SQL update statement execution(s)", (int)1, (int)this.countNumberOfUpdateStatements(counter));
        }
        finally {
            if (counter != null) {
                counter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testVersionIncrementMultipleEntities() {
        QuerySQLTracker counter = null;
        try {
            counter = new QuerySQLTracker((Session)OptimisticLockForceIncrementTestSuite.getServerSession());
            EntityManager em = this.getEntityManagerFactory().createEntityManager();
            em.getTransaction().begin();
            List addresses = em.createQuery("select a from Address a").getResultList();
            counter.getSqlStatements().clear();
            OptimisticLockForceIncrementTestSuite.assertNotNull((String)"Null query results returned", (Object)addresses);
            OptimisticLockForceIncrementTestSuite.assertNotSame((String)"No query results returned", (Object)addresses.size(), (Object)0);
            Address entity1 = (Address)addresses.get(0);
            Address entity2 = (Address)addresses.get(1);
            OptimisticLockForceIncrementTestSuite.assertNotNull((String)"Entity 1: Address cannot be null", (Object)entity1);
            OptimisticLockForceIncrementTestSuite.assertNotNull((String)"Entity 2: Address cannot be null", (Object)entity2);
            int startVersion1 = entity1.getVersion();
            int startVersion2 = entity2.getVersion();
            em.lock((Object)entity1, LockModeType.OPTIMISTIC_FORCE_INCREMENT);
            entity2.setCity("Kamloops");
            entity2.setProvince("BC");
            entity2.setCountry("Canada");
            em.flush();
            entity1.setCity("New Glasgow");
            entity1.setProvince("NS");
            entity1.setCountry("Canada");
            em.flush();
            int expectedVersion1 = startVersion1 + 1;
            int actualVersion1 = entity1.getVersion();
            int expectedVersion2 = startVersion2 + 1;
            int actualVersion2 = entity2.getVersion();
            em.getTransaction().rollback();
            em.close();
            OptimisticLockForceIncrementTestSuite.assertEquals((String)"Entity 1: Version number incremented incorrectly: ", (int)expectedVersion1, (int)actualVersion1);
            OptimisticLockForceIncrementTestSuite.assertEquals((String)"Entity 2: Version number incremented incorrectly: ", (int)expectedVersion2, (int)actualVersion2);
            OptimisticLockForceIncrementTestSuite.assertEquals((String)"3 SQL update statement execution(s)", (int)3, (int)this.countNumberOfUpdateStatements(counter));
        }
        finally {
            if (counter != null) {
                counter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testVersionIncrementBasicPromoteLock() {
        if (OptimisticLockForceIncrementTestSuite.usesSOP()) {
            return;
        }
        QuerySQLTracker counter = null;
        try {
            counter = new QuerySQLTracker((Session)OptimisticLockForceIncrementTestSuite.getServerSession());
            EntityManager em = this.getEntityManagerFactory().createEntityManager();
            em.getTransaction().begin();
            List addresses = em.createQuery("select a from Address a").getResultList();
            counter.getSqlStatements().clear();
            OptimisticLockForceIncrementTestSuite.assertNotNull((String)"Null query results returned", (Object)addresses);
            OptimisticLockForceIncrementTestSuite.assertNotSame((String)"No query results returned", (Object)addresses.size(), (Object)0);
            Address entity = (Address)addresses.get(0);
            OptimisticLockForceIncrementTestSuite.assertNotNull((String)"Entity: Address cannot be null", (Object)entity);
            int startVersion = entity.getVersion();
            em.lock((Object)entity, LockModeType.OPTIMISTIC);
            entity.setCity("Churchill");
            entity.setProvince("MB");
            entity.setCountry("Canada");
            em.flush();
            em.getTransaction().commit();
            int expectedVersion = startVersion + 1;
            int actualVersion = entity.getVersion();
            em.close();
            OptimisticLockForceIncrementTestSuite.assertEquals((String)"Version number incremented incorrectly: ", (int)expectedVersion, (int)actualVersion);
            OptimisticLockForceIncrementTestSuite.assertEquals((String)"1 SQL update statement execution(s)", (int)1, (int)this.countNumberOfUpdateStatements(counter));
        }
        finally {
            if (counter != null) {
                counter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testVersionIncrementPromoteLock() {
        QuerySQLTracker counter = null;
        try {
            counter = new QuerySQLTracker((Session)OptimisticLockForceIncrementTestSuite.getServerSession());
            EntityManager em = this.getEntityManagerFactory().createEntityManager();
            em.getTransaction().begin();
            List addresses = em.createQuery("select a from Address a").getResultList();
            counter.getSqlStatements().clear();
            OptimisticLockForceIncrementTestSuite.assertNotNull((String)"Null query results returned", (Object)addresses);
            OptimisticLockForceIncrementTestSuite.assertNotSame((String)"No query results returned", (Object)addresses.size(), (Object)0);
            Address entity = (Address)addresses.get(0);
            OptimisticLockForceIncrementTestSuite.assertNotNull((String)"Entity: Address cannot be null", (Object)entity);
            int startVersion = entity.getVersion();
            em.lock((Object)entity, LockModeType.OPTIMISTIC);
            entity.setCity("Banff");
            entity.setProvince("AB");
            entity.setCountry("Canada");
            em.flush();
            em.lock((Object)entity, LockModeType.OPTIMISTIC_FORCE_INCREMENT);
            entity.setCity("London");
            entity.setProvince("ON");
            entity.setCountry("Canada");
            em.getTransaction().commit();
            int expectedVersion = startVersion + 1;
            int actualVersion = entity.getVersion();
            em.close();
            OptimisticLockForceIncrementTestSuite.assertEquals((String)"Version number incremented incorrectly: ", (int)expectedVersion, (int)actualVersion);
            OptimisticLockForceIncrementTestSuite.assertEquals((String)"2 SQL update statement execution(s)", (int)2, (int)this.countNumberOfUpdateStatements(counter));
        }
        finally {
            if (counter != null) {
                counter.remove();
            }
        }
    }

    protected int countNumberOfUpdateStatements(QuerySQLTracker counter) {
        if (counter == null || counter.getSqlStatements().size() == 0) {
            return 0;
        }
        int numberOfStatements = 0;
        List statements = counter.getSqlStatements();
        for (String statement : statements) {
            if (statement == null || !statement.trim().toUpperCase().startsWith("UPDATE")) continue;
            ++numberOfStatements;
        }
        return numberOfStatements;
    }
}

