/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.jpql;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.jpa.JPAQuery;
import org.eclipse.persistence.internal.jpa.jpql.ConstructorQueryMappings;
import org.eclipse.persistence.internal.jpa.jpql.JPQLQueryHelper;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.advanced.Address;
import org.eclipse.persistence.testing.models.jpa.advanced.Employee;

public class JUnitJPQLQueryHelperTestSuite
extends JUnitTestCase {
    public JUnitJPQLQueryHelperTestSuite() {
    }

    public JUnitJPQLQueryHelperTestSuite(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(JUnitJPQLQueryHelperTestSuite.class.getSimpleName());
        for (Method method : JUnitJPQLQueryHelperTestSuite.class.getMethods()) {
            String name = method.getName();
            if (!name.startsWith("test_")) continue;
            suite.addTest((Test)new JUnitJPQLQueryHelperTestSuite(name));
        }
        return suite;
    }

    private int size(Iterable<DatabaseMapping> mappings) {
        int count = 0;
        for (DatabaseMapping mapping : mappings) {
            ++count;
        }
        return count;
    }

    public void tearDown() {
        super.tearDown();
        this.clearCache();
    }

    public void test_getClassDescriptors_01() {
        String jpqlQuery = "SELECT e FROM Employee e";
        ArrayList<String> entityNames = new ArrayList<String>();
        entityNames.add("Employee");
        this.testGetClassDescriptors(jpqlQuery, entityNames);
    }

    public void test_getClassDescriptors_02() {
        String jpqlQuery = "SELECT e FROM Employee e, Address a";
        ArrayList<String> entityNames = new ArrayList<String>();
        entityNames.add("Employee");
        entityNames.add("Address");
        this.testGetClassDescriptors(jpqlQuery, entityNames);
    }

    public void test_getClassDescriptors_03() {
        String jpqlQuery = "SELECT e FROM Employee e JOIN e.projects p JOIN e.phoneNumbers pn";
        ArrayList<String> entityNames = new ArrayList<String>();
        entityNames.add("Employee");
        entityNames.add("Project");
        entityNames.add("PhoneNumber");
        this.testGetClassDescriptors(jpqlQuery, entityNames);
    }

    public void test_getClassDescriptors_04() {
        String jpqlQuery = "SELECT e FROM Employee e, IN(e.dealers) d";
        ArrayList<String> entityNames = new ArrayList<String>();
        entityNames.add("Employee");
        entityNames.add("Dealer");
        this.testGetClassDescriptors(jpqlQuery, entityNames);
    }

    public void test_getClassDescriptors_05() {
        String jpqlQuery = "SELECT e FROM Employee e, IN(e.dealers) d WHERE e.name = (SELECT a.version FROM e.address a)";
        ArrayList<String> entityNames = new ArrayList<String>();
        entityNames.add("Employee");
        entityNames.add("Dealer");
        entityNames.add("Address");
        this.testGetClassDescriptors(jpqlQuery, entityNames);
    }

    public void test_getClassDescriptors_06() {
        String jpqlQuery = "UPDATE Employee e SET e.name = 'JPQL'";
        ArrayList<String> entityNames = new ArrayList<String>();
        entityNames.add("Employee");
        this.testGetClassDescriptors(jpqlQuery, entityNames);
    }

    public void test_getClassDescriptors_07() {
        String jpqlQuery = "UPDATE Employee e SET e.name = 'JPQL' WHERE NOT EXIST (SELECT e FROM Project p)";
        ArrayList<String> entityNames = new ArrayList<String>();
        entityNames.add("Employee");
        entityNames.add("Project");
        this.testGetClassDescriptors(jpqlQuery, entityNames);
    }

    public void test_getClassDescriptors_08() {
        String jpqlQuery = "DELETE FROM Employee e WHERE e.name = 'JPQL'";
        ArrayList<String> entityNames = new ArrayList<String>();
        entityNames.add("Employee");
        this.testGetClassDescriptors(jpqlQuery, entityNames);
    }

    public void test_getClassDescriptors_09() {
        String jpqlQuery = "DELETE FROM Employee e WHERE     (SELECT e.id FROM Project p) > 2       AND           NOT EXIST (SELECT b FROM Buyer b)";
        ArrayList<String> entityNames = new ArrayList<String>();
        entityNames.add("Employee");
        entityNames.add("Project");
        entityNames.add("Buyer");
        this.testGetClassDescriptors(jpqlQuery, entityNames);
    }

    public void test_getConstructorQueryMappings_01() {
        String jpqlQuery = "SELECT e FROM Employee e";
        JPAQuery query = new JPAQuery(jpqlQuery);
        query.setSession((AbstractSession)this.getDatabaseSession());
        JPQLQueryHelper helper = new JPQLQueryHelper();
        ConstructorQueryMappings constructorQuery = helper.getConstructorQueryMappings(query.getSession(), (DatabaseQuery)query);
        JUnitJPQLQueryHelperTestSuite.assertNotNull((String)"ConstructorQueryMappings should not be null", (Object)constructorQuery);
        JUnitJPQLQueryHelperTestSuite.assertSame((String)"The query was not cached correctly", (Object)query, (Object)constructorQuery.getQuery());
        JUnitJPQLQueryHelperTestSuite.assertFalse((String)"The query is not a constructor query", (boolean)constructorQuery.isConstructorQuery());
        JUnitJPQLQueryHelperTestSuite.assertNull((String)"The class name should be null", (Object)constructorQuery.getClassName());
        JUnitJPQLQueryHelperTestSuite.assertNotNull((String)"The list of mappings cannot be null", (Object)constructorQuery.mappings());
        JUnitJPQLQueryHelperTestSuite.assertFalse((String)"The list of mappings should be empty", (boolean)constructorQuery.mappings().iterator().hasNext());
    }

    public void test_getConstructorQueryMappings_02() {
        String jpqlQuery = "SELECT NEW org.eclipse.persistence.testing.tests.jpa.jpql.JUnitJPQLQueryHelperTestSuite.MyConstructorClass(   e.lastName, e.id, e.address, e.payScale) FROM Employee e";
        JPAQuery query = new JPAQuery(jpqlQuery);
        query.setSession((AbstractSession)this.getDatabaseSession());
        JPQLQueryHelper helper = new JPQLQueryHelper();
        ConstructorQueryMappings constructorQuery = helper.getConstructorQueryMappings(query.getSession(), (DatabaseQuery)query);
        JUnitJPQLQueryHelperTestSuite.assertNotNull((String)"ConstructorQueryMappings should not be null", (Object)constructorQuery);
        JUnitJPQLQueryHelperTestSuite.assertSame((String)"The query was not cached correctly", (Object)query, (Object)constructorQuery.getQuery());
        JUnitJPQLQueryHelperTestSuite.assertTrue((String)"The query is a constructor query", (boolean)constructorQuery.isConstructorQuery());
        String expectedClassName = MyConstructorClass.class.getName().replace('$', '.');
        JUnitJPQLQueryHelperTestSuite.assertEquals((String)"The class name should be null", (String)expectedClassName, (String)constructorQuery.getClassName());
        Iterable mappings = constructorQuery.mappings();
        JUnitJPQLQueryHelperTestSuite.assertNotNull((String)"The list of mappings cannot be null", (Object)mappings);
        JUnitJPQLQueryHelperTestSuite.assertTrue((String)"The list of mappings should be empty", (boolean)mappings.iterator().hasNext());
        JUnitJPQLQueryHelperTestSuite.assertEquals((String)"The count of mappings should be 4", (int)4, (int)this.size(mappings));
        int index = 0;
        for (DatabaseMapping mapping : mappings) {
            switch (index++) {
                case 0: {
                    JUnitJPQLQueryHelperTestSuite.assertEquals((String)"lastName", (String)mapping.getAttributeName());
                    break;
                }
                case 1: {
                    JUnitJPQLQueryHelperTestSuite.assertEquals((String)"id", (String)mapping.getAttributeName());
                    break;
                }
                case 2: {
                    JUnitJPQLQueryHelperTestSuite.assertEquals((String)"address", (String)mapping.getAttributeName());
                    break;
                }
                case 3: {
                    JUnitJPQLQueryHelperTestSuite.assertEquals((String)"payScale", (String)mapping.getAttributeName());
                }
            }
        }
    }

    private void testGetClassDescriptors(String jpqlQuery, Collection<String> entityNames) {
        JPQLQueryHelper helper = new JPQLQueryHelper();
        List descriptors = helper.getClassDescriptors((CharSequence)jpqlQuery, (AbstractSession)this.getDatabaseSession());
        JUnitJPQLQueryHelperTestSuite.assertNotNull((String)"The list of ClassDescriptors cannot be null", (Object)descriptors);
        JUnitJPQLQueryHelperTestSuite.assertEquals((int)entityNames.size(), (int)descriptors.size());
        for (ClassDescriptor descriptor : descriptors) {
            String alias = descriptor.getAlias();
            JUnitJPQLQueryHelperTestSuite.assertTrue((String)(alias + " is not expected"), (boolean)entityNames.remove(alias));
        }
        JUnitJPQLQueryHelperTestSuite.assertTrue((String)(entityNames + " are expected"), (boolean)entityNames.isEmpty());
    }

    private static final class MyConstructorClass {
        private MyConstructorClass(String name, Integer id, Address address, Employee.SalaryRate payScale) {
        }
    }
}

