/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.optimization;

import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class QueryValidationTest
extends AutoVerifyTestCase {
    public QueryValidationTest() {
        this.setDescription("Verify that the correct exceptions are thrown for invalid join expressions.");
    }

    public void test() {
        ReadAllQuery query;
        boolean exceptionOccured = false;
        try {
            query = new ReadAllQuery();
            query.setReferenceClass(Employee.class);
            query.addJoinedAttribute(query.getExpressionBuilder().get("id"));
            this.getSession().executeQuery((DatabaseQuery)query);
        }
        catch (QueryException exception) {
            exceptionOccured = true;
        }
        if (!exceptionOccured) {
            throw new TestErrorException("Invalid join expression not validated.");
        }
        try {
            query = new ReadAllQuery();
            query.setReferenceClass(Employee.class);
            query.addJoinedAttribute(query.getExpressionBuilder().get("id").maximum());
            this.getSession().executeQuery((DatabaseQuery)query);
        }
        catch (QueryException exception) {
            exceptionOccured = true;
        }
        if (!exceptionOccured) {
            throw new TestErrorException("Invalid join expression not validated.");
        }
    }
}

