/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.performance.reading;

import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.PerformanceComparisonTestCase;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.models.performance.toplink.Employee;

public class ReadAllvsConformTest
extends PerformanceComparisonTestCase {
    protected UnitOfWork uow;

    public ReadAllvsConformTest() {
        this.setDescription("This test compares the performance of read all in unit of work vs conform read all.");
        this.addReadAllConformTest();
    }

    public void setup() {
        this.uow = this.getSession().acquireUnitOfWork();
        Vector employees = this.uow.readAllObjects(Employee.class);
        this.uow.deleteObject(employees.get(5));
        this.uow.registerNewObject((Object)new Employee());
        Employee changedEmployee = (Employee)employees.get(10);
        changedEmployee.setSalary(0);
    }

    public void test() throws Exception {
        ReadAllQuery query = new ReadAllQuery(Employee.class);
        ExpressionBuilder builder = new ExpressionBuilder();
        query.setSelectionCriteria(builder.get("salary").greaterThan(0));
        List results = (List)this.uow.executeQuery((DatabaseQuery)query);
    }

    public void addReadAllConformTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            public void test() {
                ReadAllQuery query = new ReadAllQuery(Employee.class);
                ExpressionBuilder builder = new ExpressionBuilder();
                query.setSelectionCriteria(builder.get("salary").greaterThan(0));
                query.conformResultsInUnitOfWork();
                List results = (List)ReadAllvsConformTest.this.uow.executeQuery((DatabaseQuery)query);
            }
        };
        test.setName("ReadAllConformTest");
        test.setAllowableDecrease(-120.0);
        this.addTest((TestCase)test);
    }
}

