/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.failover;

import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Address;
import org.eclipse.persistence.testing.tests.failover.emulateddriver.EmulatedConnection;
import org.eclipse.persistence.testing.tests.failover.emulateddriver.EmulatedDriver;

public class SingleConnectionFailureTest
extends TestCase {
    protected DatabaseSession databaseSession;

    protected void setup() {
        if (this.getSession().getPlatform().isSymfoware()) {
            this.throwWarning("Test SingleConnectionFailureTest is not supported on Symfoware, failover has not been implemented on this platform. (bug 304908)");
        }
        Project project = this.getSession().getProject().clone();
        DatabaseLogin login = (DatabaseLogin)project.getLogin().clone();
        login.useDirectDriverConnect();
        login.setDriverClass(EmulatedDriver.class);
        login.setConnectionString("jdbc:emulateddriver");
        project.setLogin(login);
        this.databaseSession = project.createDatabaseSession();
        this.databaseSession.setSessionLog(this.getSession().getSessionLog());
        this.databaseSession.login();
        String sql = this.getSession().getPlatform().getPingSQL();
        Vector rows = this.getSession().executeSQL(sql);
        ((EmulatedConnection)((DatabaseSessionImpl)this.databaseSession).getAccessor().getConnection()).putRows(sql, rows);
        ReadObjectQuery query = new ReadObjectQuery(Address.class);
        this.getSession().executeQuery((DatabaseQuery)query);
        sql = query.getSQLString();
        rows = this.getSession().executeSQL(sql);
        ((EmulatedConnection)((DatabaseSessionImpl)this.databaseSession).getAccessor().getConnection()).putRows(sql, rows);
        ((EmulatedConnection)((DatabaseSessionImpl)this.databaseSession).getAccessor().getConnection()).causeCommError();
    }

    protected void test() {
        try {
            this.databaseSession.readObject(Address.class);
        }
        catch (DatabaseException ex) {
            throw new TestErrorException("Should have reconnected and not thrown exception.");
        }
    }

    public void reset() {
        if (this.databaseSession != null) {
            if (this.databaseSession.isConnected()) {
                this.databaseSession.logout();
            }
            this.databaseSession = null;
        }
    }
}

