/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.distributedservers.rcm.broadcast;

import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.sessions.coordination.CommandProcessor;
import org.eclipse.persistence.sessions.coordination.RemoteCommandManager;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestCollection;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestProblemException;
import org.eclipse.persistence.testing.framework.TestWrapper;
import org.eclipse.persistence.testing.tests.distributedservers.rcm.broadcast.BroadcastEventLock;

public abstract class BroadcastSetupHelper {
    public static final String TEST_CONTEXT_FACTORY = "org.eclipse.persistence.testing.framework.naming.InitialContextFactoryImpl";
    public static Properties CONTEXT_PROPERTIES = new Properties();
    public static final String LOCAL = "local";
    public static final String EXTERNAL = "external";
    public static final String ALL = "all";
    protected static BroadcastEventLock eventLock;
    protected boolean isCreated = false;
    protected boolean isStarted = false;
    protected String factoryJndiName;
    protected String topicJndiName;
    protected IdentityHashMap sessions = new IdentityHashMap(2);

    public static Context getContext() throws NamingException {
        return new InitialContext(CONTEXT_PROPERTIES);
    }

    public static BroadcastEventLock getEventLock() {
        return eventLock;
    }

    public boolean shouldIgnoreTargetListenerInReconnectionTest() {
        return false;
    }

    public abstract boolean isLocalConnectionRemovedOnListeningError();

    public abstract int getRcmExceptionErrorCodeOnFailureToCreateLocalConnection();

    public abstract boolean isLocalConnectionAlsoExternalConnection();

    public boolean isCreated() {
        return this.isCreated;
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    String getFactoryJndiName() {
        return this.factoryJndiName;
    }

    String getTopicJndiName() {
        return this.topicJndiName;
    }

    public Iterator getSessionsIterator() {
        return this.sessions.keySet().iterator();
    }

    protected BroadcastSetupHelper() {
    }

    public void createFactory() throws Exception {
        if (!this.isCreated) {
            Object[] factoryAndTopic = this.internalCreateFactory();
            Context context = BroadcastSetupHelper.getContext();
            if (factoryAndTopic[0] != null) {
                context.bind(this.factoryJndiName, factoryAndTopic[0]);
            }
            if (factoryAndTopic[1] != null) {
                context.bind(this.topicJndiName, factoryAndTopic[1]);
            }
            this.isCreated = true;
            this.isStarted = false;
        }
    }

    public void startFactory() throws Exception {
        if (this.isCreated && !this.isStarted) {
            this.internalStartFactory();
            this.isStarted = true;
        }
    }

    public void stopFactory() throws Exception {
        if (this.isCreated && this.isStarted) {
            this.internalStopFactory();
            this.isStarted = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyFactory() throws Exception {
        if (this.isCreated) {
            try {
                Object topic;
                Object factory;
                Context context = BroadcastSetupHelper.getContext();
                if (this.factoryJndiName != null && (factory = context.lookup(this.factoryJndiName)) != null) {
                    context.unbind(this.factoryJndiName);
                }
                if (this.topicJndiName != null && (topic = context.lookup(this.topicJndiName)) != null) {
                    context.unbind(this.topicJndiName);
                }
                this.internalDestroyFactory();
            }
            finally {
                this.isCreated = false;
                this.isStarted = false;
            }
        }
    }

    protected abstract Object[] internalCreateFactory() throws Exception;

    protected abstract void internalStartFactory() throws Exception;

    protected abstract void internalStopFactory() throws Exception;

    protected abstract void internalDestroyFactory() throws Exception;

    protected abstract void createTransportManager(RemoteCommandManager var1);

    public void startCacheSynchronization(AbstractSession session, boolean isSource) {
        try {
            this.sessions.put(session, new Boolean(isSource));
            if (this.sessions.size() == 1) {
                this.createFactory();
                this.startFactory();
            }
            RemoteCommandManager rcm = new RemoteCommandManager((CommandProcessor)session);
            this.createTransportManager(rcm);
            session.setShouldPropagateChanges(true);
            rcm.initialize();
            BroadcastSetupHelper.getEventLock().attach(session, isSource);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new TestProblemException("exception in startCacheSynchronization ", (Throwable)ex);
        }
    }

    public static Object wrapAllTestCases(Object test, long timeToWait) {
        if (test instanceof TestCase) {
            return new TestWrapperWithEventLock((TestCase)test, timeToWait, eventLock);
        }
        if (test instanceof TestCollection) {
            Vector tests = ((TestCollection)test).getTests();
            Vector<Object> wrappedTests = new Vector<Object>(tests.size());
            for (int i = 0; i < tests.size(); ++i) {
                Object wrappedTest = BroadcastSetupHelper.wrapAllTestCases(tests.elementAt(i), timeToWait);
                if (wrappedTest != null) {
                    wrappedTests.add(wrappedTest);
                    continue;
                }
                wrappedTests.add(tests.elementAt(i));
            }
            tests.clear();
            ((TestCollection)test).addTests(wrappedTests);
            return null;
        }
        return null;
    }

    public static TestCase getTestCase(Object test, String testShortClassName, boolean shouldLookUnderWrapper) {
        if (test instanceof TestCase) {
            TestCase testToLookAt = (TestCase)test;
            if (shouldLookUnderWrapper) {
                while (testToLookAt instanceof TestWrapper) {
                    testToLookAt = ((TestWrapper)testToLookAt).getWrappedTest();
                }
            }
            if (Helper.getShortClassName((Object)testToLookAt).equals(testShortClassName)) {
                return (TestCase)test;
            }
        } else if (test instanceof TestCollection) {
            Iterator it = ((TestCollection)test).getTests().iterator();
            while (it.hasNext()) {
                TestCase currentTest = BroadcastSetupHelper.getTestCase(it.next(), testShortClassName, shouldLookUnderWrapper);
                if (currentTest == null) continue;
                return currentTest;
            }
        }
        return null;
    }

    public void stopCacheSynchronization(AbstractSession session) {
        try {
            this.sessions.remove(session);
            BroadcastSetupHelper.getEventLock().detach(session);
            session.setShouldPropagateChanges(false);
            session.getCommandManager().shutdown();
            session.setCommandManager(null);
            if (this.sessions.size() == 0) {
                this.destroyFactory();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new TestProblemException("exception in stopCacheSynchronization ", (Throwable)ex);
        }
    }

    public void removeConnectionsForAllSessions(String connectionType) throws Exception {
        this.removeConnectionsForAllSessionsExcept(null, connectionType);
    }

    public void removeConnectionsForAllSessionsExcept(AbstractSession sessionToIgnore, String connectionType) throws Exception {
        for (AbstractSession session : this.sessions.keySet()) {
            if (session == sessionToIgnore) continue;
            this.removeConnections(session, connectionType);
        }
    }

    protected void removeConnections(AbstractSession session, String connectionType) {
        if (connectionType.equalsIgnoreCase(LOCAL)) {
            session.getCommandManager().getTransportManager().removeLocalConnection();
        } else if (connectionType.equals(EXTERNAL)) {
            session.getCommandManager().getTransportManager().removeAllConnectionsToExternalServices();
        } else if (connectionType.equals(ALL)) {
            session.getCommandManager().getTransportManager().discardConnections();
        } else {
            throw new TestProblemException("invalid connection type: " + connectionType + ". Valid types are: " + LOCAL + "; " + EXTERNAL + "; " + ALL);
        }
    }

    protected void sendMessageToStopListenerThreads() throws Exception {
    }

    public void createConnectionsForAllSessions(String connectionType) {
        this.createConnectionsForAllSessionsExcept(null, connectionType);
    }

    public void createConnectionsForAllSessionsExcept(AbstractSession sessionToIgnore, String connectionType) {
        for (AbstractSession session : this.sessions.keySet()) {
            if (session == sessionToIgnore) continue;
            this.createConnections(session, connectionType);
        }
    }

    protected void createConnections(AbstractSession session, String connectionType) {
        if (connectionType.equalsIgnoreCase(LOCAL)) {
            session.getCommandManager().getTransportManager().createLocalConnection();
        } else if (connectionType.equals(EXTERNAL)) {
            this.createExternalConnection(session);
        } else if (connectionType.equals(ALL)) {
            session.getCommandManager().getTransportManager().createConnections();
        } else {
            throw new TestProblemException("invalid connection type: " + connectionType + ". Valid types are: " + LOCAL + "; " + EXTERNAL + "; " + ALL);
        }
    }

    protected abstract void createExternalConnection(AbstractSession var1);

    static {
        CONTEXT_PROPERTIES.setProperty("java.naming.factory.initial", TEST_CONTEXT_FACTORY);
        eventLock = new BroadcastEventLock();
    }

    public static class TestWrapperWithEventLock
    extends TestWrapper {
        long timeToWaitBeforeVerify;
        BroadcastEventLock eventLock;

        TestWrapperWithEventLock(TestCase test, long timeToWaitBeforeVerify, BroadcastEventLock eventLock) {
            super(test);
            this.timeToWaitBeforeVerify = timeToWaitBeforeVerify;
            this.eventLock = eventLock;
        }

        public long getTimeToWaitBeforeVerify() {
            return this.timeToWaitBeforeVerify;
        }

        public void setTimeToWaitBeforeVerify(long timeToWaitBeforeVerify) {
            this.timeToWaitBeforeVerify = timeToWaitBeforeVerify;
        }

        public BroadcastEventLock getEventLock() {
            return this.eventLock;
        }

        protected void test() throws Throwable {
            this.eventLock.initialize();
            super.test();
            this.eventLock.waitUntilUnlocked(this.timeToWaitBeforeVerify);
        }

        protected void verify() throws Throwable {
            try {
                super.verify();
            }
            catch (Exception verifyException) {
                if (this.eventLock.getState() == 2) {
                    throw new TestErrorException("Target hasn't processed remote command. Consider insreasing timeToWaitBeforeVerify.", (Throwable)verifyException);
                }
                if (this.eventLock.getState() == 4) {
                    throw new TestErrorException("Source has thrown an exception on attempt to propagate command. Note that the internal exception is NOT the one thrown by source.", (Throwable)verifyException);
                }
                if (this.eventLock.getState() == 5) {
                    throw new TestErrorException("Source has removed the remote connection. Note that the internal exception is NOT the one thrown by source.", (Throwable)verifyException);
                }
                throw verifyException;
            }
        }
    }
}

