/*******************************************************************************
 * Copyright (c) 2012, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility.tests.io;

import junit.framework.Test;
import junit.framework.TestSuite;

public class CommonUtilityIOTests {

	public static Test suite() {
		TestSuite suite = new TestSuite(CommonUtilityIOTests.class.getPackage().getName());

		suite.addTestSuite(FileToolsTests.class);
		suite.addTestSuite(IndentingPrintWriterTests.class);
		suite.addTestSuite(InvalidInputStreamTests.class);
		suite.addTestSuite(InvalidOutputStreamTests.class);
		suite.addTestSuite(InvalidReaderTests.class);
		suite.addTestSuite(InvalidWriterTests.class);
		suite.addTestSuite(NullInputStreamTests.class);
		suite.addTestSuite(NullOutputStreamTests.class);
		suite.addTestSuite(NullReaderTests.class);
		suite.addTestSuite(NullWriterTests.class);
		suite.addTestSuite(PipeTests.class);
		suite.addTestSuite(StringBufferWriterTests.class);
		suite.addTestSuite(StringBuilderWriterTests.class);
		suite.addTestSuite(CompositeOutputStreamTests.class);
		suite.addTestSuite(CompositeWriterTests.class);
		suite.addTestSuite(WriterToolsTests.class);

		return suite;
	}

	private CommonUtilityIOTests() {
		super();
		throw new UnsupportedOperationException();
	}
}