/*******************************************************************************
 * Copyright (c) 2007, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility.model.value;

import org.eclipse.persistence.tools.utility.model.Model;
import org.eclipse.persistence.tools.utility.model.event.StateChangeEvent;
import org.eclipse.persistence.tools.utility.model.listener.StateChangeListener;

/**
 * Extend {@link ValueAspectAdapter} to listen to the
 * "state" of the value in the wrapped value model.
 */
@SuppressWarnings("nls")
public class ValueStateAdapter<V extends Model>
	extends ValueAspectAdapter<V>
{
	/** Listener that listens to value. */
	protected final StateChangeListener valueStateListener;


	// ********** constructors **********

	/**
	 * Construct an adapter for the value state.
	 */
	public ValueStateAdapter(ModifiablePropertyValueModel<V> valueHolder) {
		super(valueHolder);
		this.valueStateListener = this.buildValueStateListener();
	}


	// ********** initialization **********

	protected StateChangeListener buildValueStateListener() {
		return new StateChangeListener() {
			@Override
			public void stateChanged(StateChangeEvent event) {
				ValueStateAdapter.this.stateChanged(event);
			}
			@Override
			public String toString() {
				return "value state listener";
			}
		};
	}


	// ********** ValueAspectAdapter implementation **********

	@Override
	protected void engageValue_() {
		this.value.addStateChangeListener(this.valueStateListener);
	}

	@Override
	protected void disengageValue_() {
		this.value.removeStateChangeListener(this.valueStateListener);
	}


	// ********** change events **********

	protected void stateChanged(@SuppressWarnings("unused") StateChangeEvent event) {
		this.valueAspectChanged();
	}
}