/*******************************************************************************
 * Copyright (c) 2009, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility.iterable;

import java.util.Iterator;
import org.eclipse.persistence.tools.utility.iterator.ReadOnlyIterator;

/**
 * A <code>ReadOnlyIterable</code> wraps another {@link Iterable}
 * and returns a read-only {@link Iterator}.
 *
 * @param <E> the type of elements returned by the iterable's iterator
 *
 * @see ReadOnlyIterator
 * @see ReadOnlyListIterable
 */
public class ReadOnlyIterable<E>
	implements Iterable<E>
{
	private final Iterable<? extends E> iterable;


	/**
	 * Construct an iterable the returns a read-only iterator on the elements
	 * in the specified iterable.
	 */
	public ReadOnlyIterable(Iterable<? extends E> iterable) {
		super();
		if (iterable == null) {
			throw new NullPointerException();
		}
		this.iterable = iterable;
	}

	@Override
	public Iterator<E> iterator() {
		return new ReadOnlyIterator<E>(this.iterable);
	}

	@Override
	public String toString() {
		return this.iterable.toString();
	}
}