/*******************************************************************************
 * Copyright (c) 2005, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility.io;

import java.io.IOException;
import java.io.Reader;
import org.eclipse.persistence.tools.utility.ObjectTools;

/**
 * This reader will throw an exception
 * any time it is read from. Closing the reader
 * will <em>not</em> trigger an exception.
 */
public final class InvalidReader
	extends Reader
{
	// singleton
	private static Reader INSTANCE = new InvalidReader();

	/**
	 * Return the singleton.
	 */
	public static synchronized Reader instance() {
		return INSTANCE;
	}

	/**
	 * Ensure non-instantiability.
	 */
	private InvalidReader() {
		super();
	}

	@Override
	public int read(char[] cbuf, int off, int len) throws IOException {
		throw new UnsupportedOperationException();
	}

	@Override
	public void close() throws IOException {
		// do nothing
	}

	@Override
	public String toString() {
		return ObjectTools.singletonToString(this);
	}
}