/*******************************************************************************
 * Copyright (c) 2005, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility.filter;

/**
 * This compound filter will "accept" any object that is accepted by either of
 * the wrapped filters, but not both. Both filters will always be evaluated.
 *
 * @param <T> the type of objects to be filtered
 */
@SuppressWarnings("nls")
public class XORFilter<T>
	extends CompoundFilter<T>
{
	private static final long serialVersionUID = 1L;


	/**
	 * Construct a filter that will "accept" any object that is accept by either
	 * of the specified wrapped filters, but not by both.
	 */
	@SuppressWarnings("unchecked")
	public XORFilter(Filter<T> filter1, Filter<T> filter2) {
		super(filter1, filter2);
		if ((filter1 == null) || (filter2 == null)) {
			throw new NullPointerException();
		}
	}

	@Override
	public boolean accept(T o) {
		return this.filters[0].accept(o) ^ this.filters[1].accept(o);
	}

	@Override
	protected String operatorString() {
		return "XOR";
	}
}