/*******************************************************************************
 * Copyright (c) 2009, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility.collection;

import java.io.Serializable;
import java.util.NoSuchElementException;

/**
 * Interface defining the classic queue behavior,
 * without the backdoors allowed by {@link java.util.Queue}.
 * <p>
 * Provisional API: This interface is part of an interim API that is still
 * under development and expected to change significantly before reaching
 * stability. It is available at this early stage to solicit feedback from
 * pioneering adopters on the understanding that any code that uses this API
 * will almost certainly be broken (repeatedly) as the API evolves.
 *
 * @param <E> the type of elements contained by the queue
 * @see org.eclipse.jpt.common.utility.internal.collection.ArrayQueue
 * @see org.eclipse.jpt.common.utility.internal.collection.LinkedQueue
 */
@SuppressWarnings("nls")
public interface Queue<E> {

	/**
	 * "Enqueue" the specified item to the tail of the queue.
	 */
	void enqueue(E element);

	/**
	 * "Dequeue" an item from the head of the queue.
	 */
	E dequeue();

	/**
	 * Return the item on the head of the queue
	 * without removing it from the queue.
	 */
	E peek();

	/**
	 * Return whether the queue is empty.
	 */
	boolean isEmpty();


	final class Empty<E>
		implements Queue<E>, Serializable
	{
		@SuppressWarnings("rawtypes")
		public static final Queue INSTANCE = new Empty();
		@SuppressWarnings("unchecked")
		public static <T> Queue<T> instance() {
			return INSTANCE;
		}
		// ensure single instance
		private Empty() {
			super();
		}
		@Override
		public void enqueue(E o) {
			throw new UnsupportedOperationException();
		}
		@Override
		public E dequeue() {
			throw new NoSuchElementException();
		}
		@Override
		public E peek() {
			throw new NoSuchElementException();
		}
		@Override
		public boolean isEmpty() {
			return true;
		}
		@Override
		public String toString() {
			return "[]";
		}
		private static final long serialVersionUID = 1L;
		private Object readResolve() {
			// replace this object with the singleton
			return INSTANCE;
		}
	}
}