/*******************************************************************************
 * Copyright (c) 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility;

/**
 * A <code>TextRange</code> determines the location of a value within a document.
 *
 * @version 2.6
 */
public interface TextRange {

	/**
	 * Returns the length of this problem where the beginning is the offset location.
	 *
	 * @return The length of this problem
	 */
	int getLength();

	/**
	 * Returns the start position of this problem within the document.
	 *
	 * @return The offset within the document of this problem
	 */
	int getOffset();
}