/*******************************************************************************
 * Copyright (c) 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility;

/**
 * The default implementation of {@link TextRange}.
 * 
 * @version 2.6
 */
@SuppressWarnings("nls")
public final class DefaultTextRange implements TextRange {

	/**
	 * The length where the beginning is the offset location.
	 */
	private int length;

	/**
	 * The start position within the document.
	 */
	private int offset;

	/**
	 * Creates a new <code>DefaultTextRange</code>.
	 *
	 * @param offset The start position within the document
	 * @param length The length where the beginning is the offset location
	 */
	public DefaultTextRange(int offset, int length) {
		super();
		this.offset = offset;
		this.length = length;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int getLength() {
		return length;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int getOffset() {
		return offset;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();
		sb.append("offset=");
		sb.append(offset);
		sb.append(", length=");
		sb.append(length);
		return sb.toString();
	}
}