/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.tests.dom.orm;

import org.eclipse.persistence.tools.mapping.orm.ExternalBasicMapping;
import org.eclipse.persistence.tools.mapping.orm.ExternalEntity;
import org.eclipse.persistence.tools.mapping.orm.ExternalEntityColumn;

/**
 * This unit-tests tests the behavior of {@link ExternalBasicMapping}.
 *
 * @version 2.6
 */
public final class BasicMappingTests extends ConvertibleMappingTests<ExternalBasicMapping> {

	/**
	 * {@inheritDoc}
	 */
	@Override
	void addAttributeTesters(RootNodeTester tester) {
//		tester.addAttribute(buildNameTester());
//		tester.addAttribute(buildFetchTester());
//		tester.addAttribute(buildOptionalTester());
//		tester.addAttribute(buildAccessTester());
//		tester.addAttribute(buildMutableTester());       // EclipseLink
//		tester.addAttribute(buildAttributeTypeTester()); // EclipseLink
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	void addChildTesters(RootNodeTester tester) {
		tester.addNode(buildColumnTester());
//		tester.addNode(buildFieldTester());                  // EclipseLink
//		tester.addNode(buildIndexTester());                  // EclipseLink
//		tester.addNode(buildCacheIndexTester());             // EclipseLink
//		tester.addNode(buildGeneratedValueTester());         // EclipseLink
//		tester.addNode(buildLobTester());
//		tester.addNode(buildTemporalTester());
//		tester.addNode(buildEnumeratedTester());
//		tester.addTextNode(buildConvertTester());
//		tester.addChoiceNodes(buildConverterChoiceTester()); // EclipseLink
//		tester.addNode(buildTableGeneratorTester());         // EclipseLink
//		tester.addNode(buildSequenceGeneratorTester());      // EclipseLink
//		tester.addNode(buildUuidGeneratorTester());          // EclipseLink
//		tester.addListNodes(buildPropertyTester());          // EclipseLink
//		tester.addNodes(buildAccessMethodsTester());         // EclipseLink
//		tester.addNodes(buildReturnInsertTester());          // EclipseLink
//		tester.addNodes(buildReturnUpdateTester());          // EclipseLink
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	ExternalBasicMapping addMapping(ExternalEntity entity) {
		return entity.addBasicMapping(mappingName());
	}

	private ChildNodeTester<ExternalBasicMapping, ExternalEntityColumn> buildColumnTester() {
		return new ChildNodeTester<ExternalBasicMapping, ExternalEntityColumn>() {
			@Override
			public ExternalEntityColumn addChild(ExternalBasicMapping form) {
				return form.addColumn();
			}
			@Override
			public ExternalEntityColumn getChild(ExternalBasicMapping form) {
				return form.getColumn();
			}
			@Override
			public String getNodeName() {
				return ExternalEntityColumn.COLUMN;
			}
			@Override
			public boolean hasChild(ExternalBasicMapping form) {
				return form.hasColumn();
			}
			@Override
			public void removeChild(ExternalBasicMapping form) {
				form.removeColumn();
			}
		};
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	String elementName() {
		return ExternalBasicMapping.BASIC;
	}
}