/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.persistence.dom;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.persistence.tools.mapping.DefaultFormHelper;
import org.eclipse.persistence.tools.mapping.persistence.ExternalPersistenceConfiguration;
import org.eclipse.persistence.tools.mapping.persistence.ExternalPersistenceRepository;
import org.eclipse.persistence.tools.mapping.persistence.PersistenceDocumentType;
import org.eclipse.persistence.tools.utility.XMLTools;
import org.eclipse.persistence.tools.utility.iterable.EmptyIterable;
import org.w3c.dom.Document;

/**
 * This is the concrete implementation of the external repository used to handle the retrieval and
 * creation of Persistence Configuration files.
 *
 * @see ExternalPersistenceConfiguration
 * @see PersistenceConfiguration
 *
 * @version 2.6
 */
@SuppressWarnings("nls")
public final class PersistenceRepository implements ExternalPersistenceRepository {

	/**
	 * The Persistence Configuration file name, which is <code>persistence.xml</code>.
	 */
	public static final String PERSISTENCE_XML = "persistence.xml";

	/**
	 * Creates a new <code>PersistenceRepository</code>.
	 */
	public PersistenceRepository() {
		super();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public ExternalPersistenceConfiguration buildPersistenceConfiguration(URL location, PersistenceDocumentType type) throws IOException {
		DefaultFormHelper helper = new DefaultFormHelper(XMLTools.newDocument(), location);
		PersistenceConfiguration persistence = new PersistenceConfiguration(helper);
		persistence.setDocumentType(type);
		return persistence;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	@SuppressWarnings("resource")
	public ExternalPersistenceConfiguration getPersistenceConfiguration(URL location) {

		InputStream inputStream = null;

		try {

			DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
			factory.setValidating(false);
			factory.setNamespaceAware(false);
			DocumentBuilder documentBuilder = factory.newDocumentBuilder();

			inputStream = location.openStream();
			Document document = documentBuilder.parse(inputStream);

			DefaultFormHelper helper = new DefaultFormHelper(document, location);
			return new PersistenceConfiguration(helper);
		}
		catch (Exception e) {
			e.printStackTrace();
			return null;
		}
		finally {
			try {
				if (inputStream != null) {
					inputStream.close();
				}
			}
			catch (IOException e) {
				e.printStackTrace();
			}
		}
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Iterable<URL> persistenceConfigurationLocations() {
		return EmptyIterable.instance();
	}
}