/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.List;
import org.eclipse.persistence.tools.mapping.AbstractExternalForm;
import org.eclipse.persistence.tools.mapping.orm.ExternalUniqueConstraint;
import org.eclipse.persistence.tools.utility.TextRange;
import org.eclipse.persistence.tools.utility.iterable.ListIterable;
import org.w3c.dom.Element;

/**
 * The external form of a unique constraint.
 *
 * @see TableGenerator
 *
 * @version 2.6
 */
final class UniqueConstraint extends AbstractExternalForm
                             implements ExternalUniqueConstraint {

	/**
	 * The position of the element within the list of children with the same type owned by the parent.
	 */
	private int index;

	/**
	 * Creates a new <code>UniqueConstraint</code>.
	 *
	 * @param parent The parent of this external form
	 * @param index The position of the element within the list of children with the same type owned by the parent
	 */
	UniqueConstraint(AbstractExternalForm parent, int index) {
		super(parent);
		this.index = index;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected void calculateInsertionIndex(Element parent, Element child, String elementName) {
		if (elementName == getElementName()) {
			index = index(parent, child, elementName);
		}
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public List<String> columnNames() {
		return getChildrenTextNode(COLUMN_NAME);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int columnNamesSize() {
		return getChildrenSize(COLUMN_NAME);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public TextRange getColumnTextRange(int index) {
		return getChildTextNodeTextRange(COLUMN_NAME, index);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Element getElement() {
		return getChild(getParent(), getElementName(), index);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected String getElementName() {
		return UNIQUE_CONSTRAINT;
	}

	@Override
	@Deprecated
	public int getIndex() {
		return index;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void removeSelf() {
		removeChild(getParent(), getElementName(), index);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setColumnNames(ListIterable<String> columnNames) {

		removeChildren(COLUMN_NAME);

		for (String columnName : columnNames) {
			addChildTextNode(COLUMN_NAME, columnName);
		}
	}
}