/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm.dom;

import org.eclipse.persistence.tools.mapping.AbstractExternalForm;
import org.eclipse.persistence.tools.mapping.orm.ExternalInstantiationCopyPolicy;

/**
 * The external form of a instantiation copy policy, which is a child of an entity.
 *
 * @see EmbeddableEntity
 *
 * @version 2.6
 */
final class InstantiationCopyPolicy extends AbstractExternalForm
                                    implements ExternalInstantiationCopyPolicy {

	/**
	 * Creates a new <code>InstantiationCopyPolicy</code>.
	 *
	 * @param parent The parent of this external form
	 */
	InstantiationCopyPolicy(Embeddable parent) {
		super(parent);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected String getElementName() {
		return INSTANTIATION_COPY_POLICY;
	}
}