/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.tools.mapping.AbstractExternalForm;
import org.eclipse.persistence.tools.mapping.orm.ExternalCopyPolicy;
import org.eclipse.persistence.tools.utility.TextRange;

/**
 * The external form of a copy policy, which is a child of an entity.
 *
 * @see EmbeddableEntity
 *
 * @version 2.6
 */
final class CopyPolicy extends AbstractExternalForm
                       implements ExternalCopyPolicy {

	/**
	 * Creates a new <code>CopyPolicy</code>.
	 *
	 * @param parent The parent of this external form
	 */
	CopyPolicy(Embeddable parent) {
		super(parent);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected List<String> buildAttributeNamesOrder() {
		List<String> names = new ArrayList<String>();
		names.add(CLASS);
		return names;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getClassName() {
		return getAttribute(CLASS);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public TextRange getClassNameTextRange() {
		return getAttributeTextRange(CLASS);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected String getElementName() {
		return COPY_POLICY;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setClassName(String className) {
		setAttribute(CLASS, className);
	}
}