/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

import java.util.List;

/**
 * This interface and inherited behavior describe the configurable properties defined for a table
 * that is joinable  in the ORM xml. There are a variety of places where a table may be used or
 * declared in the ORM xml.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @see javax.persistence.Table
 * @see http://jcp.org/aboutJava/communityprocess/final/jsr220/index.html, persistence specificaton
 *
 * @version 2.6
 */
public interface ExternalReferenceTable extends ExternalEntityTable {

	/**
	 * Adds a join column with the given name.
	 */
	ExternalJoinColumn addJoinColumn(String name);

	/**
	 * Returns the join column at the given position.
	 */
	ExternalJoinColumn getJoinColumn(int index);

	/**
	 * Indicates whether this join table is in the default state. In other words, no values specified.
	 */
	boolean isDefault();

	/**
	 * Returns a list of join columns used in this table.
	 */
	List<ExternalJoinColumn> joinColumns();

	/**
	 * Returns the count of all the join columns used in this table.
	 */
	int joinColumnsSize();

	/**
	 * Removes the join column at the given position.
	 */
	void removeJoinColumn(int index);
}