/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

import org.eclipse.persistence.tools.mapping.ExternalForm;
import org.eclipse.persistence.tools.utility.TextRange;

/**
 * Represents a primary key join to associate rows of a given table as needed by the ORM.xml. A
 * primary key join column definition can be used in an Entity or an Entity's secondary table
 * definition to associate secondary tables to the primary table. It may also be used in a 1:1
 * mapping to define pk joins that represent the relationship to the target entity's table.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @see http://jcp.org/aboutJava/communityprocess/final/jsr220/index.html, persistence specificaton
 *
 * @version 2.6
 */
@SuppressWarnings("nls")
public interface ExternalPrimaryKeyJoinColumn extends ExternalForm {

	/**
	 * The attribute name used to store and retrieve the column-definition of the property.
	 */
	String COLUMN_DEFINITION = "column-definition";

	/**
	 * The attribute name used to store and retrieve the name property.
	 */
	String NAME = "name";

	/**
	 * The node name used to store and retrieve the element encapsulated by this external form.
	 */
	String PRIMARY_KEY_JOIN_COLUMN = "primary-key-join-column";

	/**
	 * The attribute name used to store and retrieve the referenced-column-name property.
	 */
	String REFERENCED_COLUMN_NAME = "referenced-column-name";

	/**
	 * The DDL or other native sql definition of the column association.
	 */
	String getColumnDefinition();

	/**
	 * Returns the {@link TextRange} for the column definition.
	 */
	TextRange getColumnDefinitionTextRange();

	/**
	 * Returns the name of the primary key column on the source table to join.
	 */
	String getName();

	/**
	 * Returns the {@link TextRange} for the name of the primary key column.
	 */
	TextRange getNameTextRange();

	/**
	 * Returns the name of the reference pk column.
	 */
	String getReferenceColumnName();

	/**
	 * Returns the {@link TextRange} for the name of the reference pk column.
	 */
	TextRange getReferenceColumnNameTextRange();

	/**
	 * Sets the column definition.
	 */
	void setColumnDefinition(String definition);

	/**
	 * Sets the name of the primary key join column.
	 */
	void setName(String name);

	/**
	 * Sets the name of the reference PK column.
	 */
	void setReferenceColumnName(String name);
}