/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

import org.eclipse.persistence.tools.utility.TextRange;

/**
 * This interface and inherited behavior describe the configurable properties defined for a named,
 * native query in the ORM xml. A named, native query may be declared at the root level of the ORM
 * xml or on an individual entity basis.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @see javax.persistence.NamedNativeQuery
 * @see http://jcp.org/aboutJava/communityprocess/final/jsr220/index.html, persistence specificaton
 *
 * @version 2.6
 */
@SuppressWarnings("nls")
public interface ExternalNativeQuery extends ExternalNamedQuery {

	/**
	 * The node name used to store and retrieve the element encapsulated by this external form.
	 */
	String NAMED_NATIVE_QUERY = "named-native-query";

	/**
	 * The attribute name used to store and retrieve the result-class property.
	 */
	String RESULT_CLASS = "result-class";

	/**
	 * The attribute name used to store and retrieve the result-set-mapping property.
	 */
	String RESULT_SET_MAPPING = "result-set-mapping";

	/**
	 * Returns the name of the class that will represent the result of this query.
	 */
	String getResultClassName();

	/**
	 * Returns the {@link TextRange} of the result class name value.
	 */
	TextRange getResultClassNameTextRange();

	/**
	 * Returns a string representing how the result set from this mapping will be mapped to the give
	 * result class type.
	 */
	String getResultSetMapping();

	/**
	 * Returns the {@link TextRange} of the result set mapping value.
	 */
	TextRange getResultSetMappingTextRange();

	/**
	 * Sets the name of the class that will represent the result of this query.
	 */
	void setResultClassName(String name);

	/**
	 * Sets the result set from this mapping.
	 */
	void setResultSetMapping(String mappingName);
}