/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

import org.eclipse.persistence.tools.mapping.ExternalForm;
import org.eclipse.persistence.tools.utility.TextRange;

/**
 * This interface represents the basis for all mapping types defined by the JPA spec that are
 * available for configuration via the ORM xml.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @see http://jcp.org/aboutJava/communityprocess/final/jsr220/index.html, persistence specificaton
 *
 * @version 2.6
 */
@SuppressWarnings("nls")
public interface ExternalMapping extends ExternalForm {

	/**
	 * The attribute name used to store and retrieve the attribute type.
	 */
	String ATTRIBUTE_TYPE = "attribute-type";

	/**
	 * The element name used to store and retrieve the parent element of element represented by this external form.
	 */
	String ATTRIBUTES = "attributes";

	/**
	 * The attribute name used to store and retrieve the mapping's name.
	 */
	String NAME = "name";

	/**
	 * Returns the attribute type of this mapping.
	 */
	String getAttributeType();

	/**
	 * Returns the short name of the attribute type of this mapping.
	 */
	String getAttributeTypeShortName();

	/**
	 * Returns the {@link TextRange} for the attribute type value.
	 */
	TextRange getAttributeTypeTextRange();

	/**
	 * Derives a getter method name for this mapping's attribute.
	 */
	String getGetMethodName();

	/**
	 * Returns the name of the mapping.
	 */
	String getName();

	/**
	 * Returns the {@link TextRange} for the name of the mapping.
	 */
	TextRange getNameTextRange();

	/**
	 * Derives a setter method name for this mapping's attribute.
	 */
	String getSetMethodName();

	/**
	 * Indicates whether this mapping is of type {@link Basic}.
	 * <p>
	 * Note: This method cannot be removed, entity generation is using it. Java code should use
	 * {@link ExternalMappingVisitor}.
	 */
	boolean isBasicMapping();

	/**
	 * Indicates whether this mapping is of type {@link ElementCollection}.
	 * <p>
	 * Note: This method cannot be removed, entity generation is using it, however Java code should
	 * use {@link ExternalMappingVisitor}.
	 */
	boolean isElementCollectionMapping();

	/**
	 * Indicates whether this mapping is of type {@link Embedded}.
	 * <p>
	 * Note: This method cannot be removed, entity generation is using it, however Java code should
	 * use {@link ExternalMappingVisitor}.
	 */
	boolean isEmbeddedMapping();

	/**
	 * Indicates whether this mapping is of type {@link Id}.
	 * <p>
	 * Note: This method cannot be removed, entity generation is using it, however Java code should
	 * use {@link ExternalMappingVisitor}.
	 */
	boolean isIdMapping();

	/**
	 * Sets the attribute type of this mapping.
	 */
	void setAttributeType(String attributeType);

	/**
	 * Sets the name of the mapping.
	 */
	void setName(String name);
}