/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

import java.util.List;

/**
 * This interface and inherited describes the configurable properties for an embedded mapping.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @see javax.persistence.Embedded
 * @see http://jcp.org/aboutJava/communityprocess/final/jsr220/index.html, persistence specificaton
 *
 * @version 2.6
 */
@SuppressWarnings("nls")
public interface ExternalEmbeddedMapping extends ExternalNonTransientMapping {

	/**
	 * The node name used to store and retrieve the element encapsulated by this external form.
	 */
	String EMBEDDED = "embedded";

	/**
	 * Visits this {@link ExternalEmbeddedMapping} by the given {@link ExternalMappingVisitor visitor}.
	 *
	 * @param visitor The {@link ExternalMappingVisitor} to visit this object
	 */
	void accept(ExternalMappingVisitor visitor);

	/**
	 * Adds a override with the given name
	 */
	ExternalAssociationOverride addAssociationOverride();

	/**
	 * Adds a override with the given name
	 */
	ExternalAttributeOverride addAttributeOverride();

	/**
	 * Returns a list of association overrides defined on this mapping.
	 */
	List<ExternalAssociationOverride> associationOverrides();

	/**
	 * Returns the count of association overrides defined on this entity.
	 */
	int associationOverridesSize();

	/**
	 * Returns a list of overridden column mappings for embedded mapping.
	 */
	List<ExternalAttributeOverride> attributeOverrides();

	/**
	 * Returns the count of overridden column mappings for embedded fields.
	 */
	int attributeOverridesSize();

	/**
	 * Returns the association override at the specified index.
	 */
	ExternalAssociationOverride getAssociationOverride(int index);

	/**
	 * Returns the attribute override at the specified index.
	 */
	ExternalAttributeOverride getAttributeOverride(int index);

	/**
	 * Returns the data type's name of the field for a NoSQL database.
	 */
	String getNoSqlField();

	/**
	 * Removes the override named.
	 */
	void removeAssociationOverride(int index);

	/**
	 * Removes the override named.
	 */
	void removeAttributeOverride(int index);

	/**
	 * Sets the data type's name of the field for a NoSQL database.
	 */
	void setNoSqlField(String field);
}